/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.dataprovider.impl;

import bsh.EvalError;
import com.f3p.dataprovider.DataProviderConst;
import com.f3p.dataprovider.DataProviderException;
import com.f3p.scripting.BSHEvaluator;
import java.util.Hashtable;
import java.util.LinkedList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FieldsFormat
implements DataProviderConst {
    private Hashtable<String, LinkedList<FormatDesc>> m_htFieldFormats = new Hashtable();

    public void addFormats(Element formats) throws DataProviderException {
        NodeList nodes = formats.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node instanceof Element && node.getNodeName().equalsIgnoreCase("format")) {
                Element format = (Element)node;
                String sField = format.getAttribute("field");
                String sCondition = format.getAttribute("condition");
                if (sField == null || sField.length() == 0) {
                    throw new DataProviderException(null, "Tag Format non valido, FIELD non specificato");
                }
                String sFieldFormat = format.getTextContent().trim();
                if (sFieldFormat != null) {
                    if (sCondition != null && (sCondition = sCondition.trim()).length() == 0) {
                        sCondition = null;
                    }
                    FormatDesc desc = new FormatDesc();
                    desc.sFormat = sFieldFormat;
                    desc.sCondition = sCondition;
                    LinkedList<FormatDesc> lDesc = this.m_htFieldFormats.get(sField.toLowerCase());
                    if (lDesc == null) {
                        lDesc = new LinkedList();
                    }
                    lDesc.add(desc);
                    this.m_htFieldFormats.put(sField.toLowerCase(), lDesc);
                }
            }
            ++i;
        }
    }

    public String getFormat(String sField, Object value, Object oldValue) throws DataProviderException {
        LinkedList<FormatDesc> lDesc = this.m_htFieldFormats.get(sField.toLowerCase());
        if (lDesc == null) {
            return null;
        }
        BSHEvaluator eval = null;
        String sFormat = null;
        try {
            eval = new BSHEvaluator(null);
            eval.put("value", value);
            eval.put("old", oldValue);
        }
        catch (EvalError e) {
            throw new DataProviderException(null, "getFormat", (Throwable)e);
        }
        for (FormatDesc desc : lDesc) {
            if (desc.sCondition != null) {
                try {
                    if (!eval.eval(desc.sCondition)) continue;
                    sFormat = desc.sFormat;
                    break;
                }
                catch (EvalError e) {
                    throw new DataProviderException(null, "getFormat", (Throwable)e);
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
            }
            sFormat = desc.sFormat;
            break;
        }
        return sFormat;
    }

    private class FormatDesc {
        String sFormat;
        String sCondition;

        private FormatDesc() {
        }
    }
}

