/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.dataprovider.impl;

import com.f3p.dataprovider.DataProviderConfig;
import com.f3p.dataprovider.DataProviderConnection;
import com.f3p.dataprovider.DataProviderConst;
import com.f3p.dataprovider.DataProviderException;
import com.f3p.dataprovider.DataProviderMetadata;
import com.f3p.dataprovider.FieldFormatter;
import com.f3p.dataprovider.impl.FieldsFormat;
import com.f3p.dataprovider.impl.Params;
import com.f3p.dataprovider.impl.Relation;
import com.f3p.dataprovider.impl.SimpleMetadataImpl;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractDataProviderConnection
implements DataProviderConnection,
DataProviderConst {
    protected Log m_log = LogFactory.getLog(AbstractDataProviderConnection.class);
    private DataProviderConfig m_config;
    private String m_sName;
    private String m_sConnectionObjectName = null;
    private Params m_params = null;
    private boolean m_bPosMandatory = false;
    private Hashtable<String, Relation> m_htRelations = new Hashtable();
    private SimpleMetadataImpl m_metadata;
    private FieldFormatter m_formatter = null;
    private FieldsFormat m_fFormats = new FieldsFormat();

    @Override
    public void configure(DataProviderConfig config, String sName, Element cfgelement) throws DataProviderException {
        this.m_log.trace((Object)("[" + sName + "] configure"));
        this.m_sName = sName;
        this.m_config = config;
        this.m_formatter = config.getFormatter();
        NodeList childs = cfgelement.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node node = childs.item(i);
            if (node instanceof Element) {
                Element element = (Element)node;
                String sTag = element.getNodeName().toLowerCase();
                if (sTag.equals("connection")) {
                    this.m_sConnectionObjectName = element.getAttribute("name");
                } else if (sTag.equals("params")) {
                    this.m_params = new Params(element, this.m_bPosMandatory);
                } else if (sTag.equals("relation")) {
                    String sRName = element.getAttribute("name");
                    if (sRName == null) {
                        throw new DataProviderException((DataProviderConnection)this, "Relation non valida, NAME non specificato");
                    }
                    Relation rel = new Relation(this.m_config, sRName, element);
                    this.m_htRelations.put(sRName, rel);
                } else if (sTag.equals("formats")) {
                    this.m_fFormats.addFormats(element);
                }
            }
            ++i;
        }
        if (this.m_params == null) {
            this.m_params = new Params();
        }
        this.m_metadata = new SimpleMetadataImpl(this.m_params);
    }

    @Override
    public String getName() {
        return this.m_sName;
    }

    protected String getConnectionObjectName() {
        return this.m_sConnectionObjectName;
    }

    protected Object getConnectionObject() {
        if (this.m_sConnectionObjectName != null) {
            return this.getConfig().getConnectionObject(this.m_sConnectionObjectName);
        }
        return null;
    }

    protected DataProviderConfig getConfig() {
        return this.m_config;
    }

    @Override
    public void release() {
    }

    public Relation getRelation(String sName) {
        this.m_log.trace((Object)("[" + this.getName() + "] getRelation: " + sName));
        if (this.m_htRelations.containsKey(sName)) {
            return this.m_htRelations.get(sName);
        }
        return null;
    }

    public Params getParams() {
        return this.m_params;
    }

    public void setPosMandatory(boolean val) {
        this.m_bPosMandatory = val;
    }

    @Override
    public void setGenericParam(String sName, Object obValue) throws DataProviderException {
        this.m_log.trace((Object)("[" + this.getName() + "] setGenericParam: name=" + sName + " value: " + obValue + " vtype: " + obValue.getClass()));
        if (obValue instanceof String) {
            this.setParam(sName, (String)obValue);
        } else if (obValue instanceof Calendar) {
            this.setParam(sName, (Calendar)obValue);
        } else if (obValue instanceof InputStream) {
            this.setParam(sName, (InputStream)obValue);
        } else if (obValue instanceof Integer) {
            this.setParam(sName, (Integer)obValue);
        } else if (obValue instanceof Long) {
            this.setParam(sName, (Long)obValue);
        } else if (obValue instanceof Short) {
            this.setParam(sName, (Short)obValue);
        } else if (obValue instanceof Double) {
            this.setParam(sName, (Double)obValue);
        } else if (obValue instanceof BigDecimal) {
            this.setParam(sName, (BigDecimal)obValue);
        } else {
            throw new DataProviderException((DataProviderConnection)this, "Tipo non supportato");
        }
    }

    @Override
    public void setParam(String sName, int iValue) throws DataProviderException {
        this.m_log.trace((Object)("[" + this.getName() + "] setParam (int) : name=" + sName + " value: " + iValue));
        this.setParam(sName, new Integer(iValue));
    }

    @Override
    public void setParam(String sName, long lValue) throws DataProviderException {
        this.m_log.trace((Object)("[" + this.getName() + "] setParam (long) : name=" + sName + " value: " + lValue));
        this.setParam(sName, new Long(lValue));
    }

    @Override
    public void setParam(String sName, short sValue) throws DataProviderException {
        this.m_log.trace((Object)("[" + this.getName() + "] setParam (short) : name=" + sName + " value: " + sValue));
        this.setParam(sName, new Short(sValue));
    }

    @Override
    public void setParam(String sName, double dValue) throws DataProviderException {
        this.m_log.trace((Object)("[" + this.getName() + "] setParam (double) : name=" + sName + " value: " + dValue));
        this.setParam(sName, new Double(dValue));
    }

    @Override
    public DataProviderMetadata getMetadata() {
        return this.m_metadata;
    }

    public String getFormatted(String sName, Object obValue, Object oldValue) throws DataProviderException {
        String sFormat = this.m_fFormats.getFormat(sName, obValue, oldValue);
        this.m_log.trace((Object)("[" + this.getName() + "] getFormatted: name=" + sName + " value: " + obValue + " oldValue: " + oldValue + ". Format: " + sFormat));
        if (sFormat != null) {
            return this.m_formatter.getFormatted(obValue, sFormat);
        }
        return obValue.toString();
    }
}

