/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.dataprovider.impl;

import com.f3p.dataprovider.DataProvider;
import com.f3p.dataprovider.DataProviderConnection;
import com.f3p.dataprovider.DataProviderException;
import com.f3p.dataprovider.DataProviderMetadata;
import com.f3p.dataprovider.ParamProvider;
import com.f3p.dataprovider.impl.AbstractDataProviderConnection;
import com.f3p.dataprovider.impl.Relation;
import java.util.Calendar;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDataProvider
implements DataProvider {
    private Log m_log = LogFactory.getLog(AbstractDataProvider.class);
    protected AbstractDataProviderConnection m_dataproviderconnection;
    protected DataProvider m_relationSource;
    protected Hashtable<String, Object> m_htValues = null;
    protected Hashtable<String, Object> m_htOldValues = null;
    protected Hashtable<String, Object> m_htBuffer = null;
    protected boolean m_bExhausted = false;

    public AbstractDataProvider(AbstractDataProviderConnection dp) {
        this.m_dataproviderconnection = dp;
        this.m_relationSource = null;
        this.m_htValues = new Hashtable();
        this.m_htOldValues = new Hashtable();
        this.m_htBuffer = new Hashtable();
    }

    @Override
    public String getName() {
        return this.m_dataproviderconnection.getName();
    }

    @Override
    public DataProviderMetadata getMetadata() {
        return this.m_dataproviderconnection.getMetadata();
    }

    @Override
    public DataProvider getRelation(String sName, ParamProvider provider) throws DataProviderException {
        this.m_log.trace((Object)("[" + this.getName() + "] getRelation: " + sName));
        Relation relation = this.m_dataproviderconnection.getRelation(sName);
        if (relation != null) {
            return relation.getRelatedDataProvider(this, provider);
        }
        return null;
    }

    @Override
    public DataProvider getRelationSource() throws DataProviderException {
        return this.m_relationSource;
    }

    public void setRelationSource(DataProvider relationSource) {
        this.m_relationSource = relationSource;
    }

    @Override
    public DataProviderConnection getConnection() {
        return this.m_dataproviderconnection;
    }

    @Override
    public String getFormatted(String sName) throws DataProviderException {
        this.m_log.trace((Object)("[" + this.getName() + "] getFormatted: " + sName));
        Object obj = this.getObject(sName);
        Object oldValue = this.m_htOldValues.get(sName);
        if (obj != null) {
            return this.m_dataproviderconnection.getFormatted(sName, obj, oldValue);
        }
        return null;
    }

    public void setCurrentValue(String sName, Object oVal) {
        this.m_htValues.put(sName, oVal);
    }

    public void moveCurrentToOld() {
        Hashtable<String, Object> tmp = this.m_htOldValues;
        this.m_htOldValues = this.m_htValues;
        this.m_htValues = this.m_htBuffer;
        this.m_htBuffer = tmp;
        this.m_htValues.clear();
        this.m_htBuffer.clear();
    }

    @Override
    public Calendar getCalendar(String sName) throws DataProviderException {
        this.m_log.trace((Object)("[" + this.getName() + "] getCalendar: " + sName));
        Calendar ret = this.getCalendarInt(sName);
        if (ret != null) {
            this.m_htValues.put(sName, ret);
        }
        return ret;
    }

    @Override
    public Double getDouble(String sName) throws DataProviderException {
        this.m_log.trace((Object)("[" + this.getName() + "] getDouble: " + sName));
        Double ret = this.getDoubleInt(sName);
        if (ret != null) {
            this.m_htValues.put(sName, ret);
        }
        return ret;
    }

    @Override
    public Float getFloat(String sName) throws DataProviderException {
        this.m_log.trace((Object)("[" + this.getName() + "] getFloat: " + sName));
        Float ret = this.getFloatInt(sName);
        if (ret != null) {
            this.m_htValues.put(sName, ret);
        }
        return ret;
    }

    @Override
    public Boolean getBoolean(String sName) throws DataProviderException {
        this.m_log.trace((Object)("[" + this.getName() + "] getBoolean: " + sName));
        Boolean ret = this.getBooleanInt(sName);
        if (ret != null) {
            this.m_htValues.put(sName, ret);
        }
        return ret;
    }

    @Override
    public Integer getInteger(String sName) throws DataProviderException {
        this.m_log.trace((Object)("[" + this.getName() + "] getInteger: " + sName));
        Integer ret = this.getIntegerInt(sName);
        if (ret != null) {
            this.m_htValues.put(sName, ret);
        }
        return ret;
    }

    @Override
    public Long getLong(String sName) throws DataProviderException {
        this.m_log.trace((Object)("[" + this.getName() + "] getLong: " + sName));
        Long ret = this.getLongInt(sName);
        if (ret != null) {
            this.m_htValues.put(sName, ret);
        }
        return ret;
    }

    @Override
    public Object getObject(String sName) throws DataProviderException {
        this.m_log.trace((Object)("[" + this.getName() + "] getObject: " + sName));
        Object ret = this.getObjectInt(sName);
        if (ret != null) {
            this.m_htValues.put(sName, ret);
        }
        return ret;
    }

    @Override
    public Short getShort(String sName) throws DataProviderException {
        this.m_log.trace((Object)("[" + this.getName() + "] getShort: " + sName));
        Short ret = this.getShortInt(sName);
        if (ret != null) {
            this.m_htValues.put(sName, ret);
        }
        return ret;
    }

    @Override
    public String getString(String sName) throws DataProviderException {
        this.m_log.trace((Object)("[" + this.getName() + "] getString: " + sName));
        String ret = this.getStringInt(sName);
        if (ret != null) {
            this.m_htValues.put(sName, ret);
        }
        return ret;
    }

    protected abstract Calendar getCalendarInt(String var1) throws DataProviderException;

    protected abstract Double getDoubleInt(String var1) throws DataProviderException;

    protected abstract Float getFloatInt(String var1) throws DataProviderException;

    protected abstract Integer getIntegerInt(String var1) throws DataProviderException;

    protected abstract Boolean getBooleanInt(String var1) throws DataProviderException;

    protected abstract Long getLongInt(String var1) throws DataProviderException;

    protected abstract Object getObjectInt(String var1) throws DataProviderException;

    protected abstract Short getShortInt(String var1) throws DataProviderException;

    protected abstract String getStringInt(String var1) throws DataProviderException;

    @Override
    public boolean next() throws DataProviderException {
        this.moveCurrentToOld();
        return true;
    }

    @Override
    public void release() throws DataProviderException {
        this.m_log.trace((Object)("[" + this.getName() + "] release"));
        this.m_htBuffer.clear();
        this.m_htValues.clear();
        this.m_htOldValues.clear();
    }

    public void setExhausted(boolean bExhausted) {
        this.m_bExhausted = bExhausted;
    }

    @Override
    public boolean isExhausted() {
        return this.m_bExhausted;
    }
}

