/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.dataprovider;

import com.f3p.commons.Utils;
import com.f3p.commons.XercesUtils;
import com.f3p.dataprovider.DataProviderConnection;
import com.f3p.dataprovider.DataProviderConst;
import com.f3p.dataprovider.DataProviderException;
import com.f3p.dataprovider.FieldFormatter;
import com.f3p.dataprovider.impl.SimpleFieldFormatter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataProviderConfig
implements DataProviderConst {
    private Hashtable<String, DataProviderConnection> m_htDPConnections = new Hashtable();
    private Hashtable<String, Object> m_htRegisteredCon = new Hashtable();
    private FieldFormatter m_fieldFormatter = new SimpleFieldFormatter();
    private Set<String> m_setFlags = new HashSet<String>();

    public DataProviderConfig(File config) throws DataProviderException {
        this.loadConfig(config);
    }

    public DataProviderConfig(URL config) throws DataProviderException {
        this.loadConfig(config);
    }

    public DataProviderConfig(InputStream is) throws DataProviderException {
        this.loadConfig(is);
    }

    public void loadConfig(File config) throws DataProviderException {
        try {
            this.loadConfig(new FileInputStream(config));
        }
        catch (FileNotFoundException e) {
            throw new DataProviderException(null, "loadConfig fallita", (Throwable)e);
        }
    }

    public void loadConfig(URL config) throws DataProviderException {
        try {
            this.loadConfig(config.openStream());
        }
        catch (IOException e) {
            throw new DataProviderException(null, "loadConfig fallita", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadConfig(InputStream is) throws DataProviderException {
        try {
            Document doc = XercesUtils.getDocument(is);
            Element root = doc.getDocumentElement();
            NodeList nodes = root.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node content = nodes.item(i);
                if (content instanceof Element) {
                    Element element = (Element)content;
                    if (content.getNodeName().toLowerCase().equals("dataprovider")) {
                        String sName = element.getAttribute("name");
                        String sImpl = element.getAttribute("impl");
                        String sOverride = element.getAttribute("override");
                        DataProviderConnection con = this.getConnection(sName);
                        if (con == null) {
                            con = (DataProviderConnection)Class.forName(sImpl).newInstance();
                            con.configure(this, sName, element);
                            this.m_htDPConnections.put(sName, con);
                        } else {
                            if (!sOverride.equalsIgnoreCase("yes")) throw new DataProviderException(null, "Esiste gia' una DataProviderConnection con nome <" + sName + ">");
                            con.configure(this, sName, element);
                        }
                    } else if (content.getNodeName().toLowerCase().equals("flag")) {
                        String sFlag = element.getAttribute("name");
                        if (Utils.isEmptyString(sFlag)) {
                            throw new DataProviderException(null, "Flag senza nome specificato");
                        }
                        this.setFlag(sFlag, true);
                    }
                }
                ++i;
            }
            return;
        }
        catch (Exception e) {
            throw new DataProviderException(null, "loadConfig fallita", (Throwable)e);
        }
    }

    public FieldFormatter getFormatter() {
        return this.m_fieldFormatter;
    }

    public boolean hasFlag(String sFlag) {
        return this.m_setFlags.contains(sFlag.toLowerCase());
    }

    public void setFlag(String sFlag, boolean bOn) {
        if (bOn) {
            this.m_setFlags.add(sFlag.toLowerCase());
        } else {
            this.m_setFlags.remove(sFlag.toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Hashtable<String, DataProviderConnection> hashtable = this.m_htDPConnections;
        synchronized (hashtable) {
            this.m_htDPConnections.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataProviderConnection getConnection(String sName) {
        Hashtable<String, DataProviderConnection> hashtable = this.m_htDPConnections;
        synchronized (hashtable) {
            if (this.m_htDPConnections.containsKey(sName)) {
                return this.m_htDPConnections.get(sName);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionObject(String sName, Object oConnection) throws DataProviderException {
        Hashtable<String, Object> hashtable = this.m_htRegisteredCon;
        synchronized (hashtable) {
            if (oConnection == null) {
                this.m_htRegisteredCon.remove(sName);
            } else if (!this.m_htRegisteredCon.containsKey(sName)) {
                this.m_htRegisteredCon.put(sName, oConnection);
            } else {
                throw new DataProviderException(null, "Esiste gia' un ConnectionObject con nome <" + sName + ">");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getConnectionObject(String sName) {
        Hashtable<String, Object> hashtable = this.m_htRegisteredCon;
        synchronized (hashtable) {
            if (this.m_htRegisteredCon.containsKey(sName)) {
                return this.m_htRegisteredCon.get(sName);
            }
            return null;
        }
    }
}

