/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.commons;

import java.io.InputStream;
import java.io.OutputStream;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;

public class XercesUtils {
    private static DOMImplementationLS g_impl = null;

    private static void getImpl() throws Exception {
        if (System.getProperty("DOMImplementationRegistry.PROPERTY") == null) {
            System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMXSImplementationSourceImpl");
        }
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        g_impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
    }

    public static LSParser getParser() throws Exception {
        if (g_impl == null) {
            XercesUtils.getImpl();
        }
        LSParser parser = g_impl.createLSParser((short)1, null);
        DOMConfiguration config = parser.getDomConfig();
        config.setParameter("validate", false);
        return parser;
    }

    public static Document getDocument(InputStream is) throws Exception {
        LSParser parser = XercesUtils.getParser();
        LSInput input = g_impl.createLSInput();
        input.setByteStream(is);
        return parser.parse(input);
    }

    public static void writeNode(Node node, OutputStream os) throws Exception {
        if (g_impl == null) {
            XercesUtils.getImpl();
        }
        LSSerializer domWriter = g_impl.createLSSerializer();
        DOMConfiguration config = domWriter.getDomConfig();
        config.setParameter("xml-declaration", true);
        LSOutput dOut = g_impl.createLSOutput();
        dOut.setByteStream(os);
        domWriter.write(node, dOut);
        os.flush();
    }
}

