/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.commons;

import com.f3p.commons.Utils;
import org.junit.Assert;
import org.junit.Test;

public class UtilsTest {
    @Test
    public void testSplitSize() throws Exception {
        String sSplitTest = "/modelli/test";
        String[] sArray = Utils.splitIntoArray(sSplitTest, "/");
        Assert.assertTrue((sArray.length == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testSplitNull() throws Exception {
        String[] sArray = Utils.splitIntoArray(null, "/");
        Assert.assertTrue((sArray.length == 0 ? 1 : 0) != 0);
        sArray = Utils.splitIntoArray("  ghghg", null);
        Assert.assertEquals((Object)sArray[0], (Object)"ghghg");
    }

    @Test
    public void testSplitSpecialChar() throws Exception {
        String sSplitTest = ".$modelli.$test";
        String[] sArray = Utils.splitIntoArray(sSplitTest, ".$");
        Assert.assertTrue((sArray.length == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testSplitString() throws Exception {
        String sToSplit = "abc<br>defgghh<br>xyz";
        String sSep = "<br>";
        String[] sResult = Utils.splitIntoArray(sToSplit, sSep);
        Assert.assertEquals((Object)sResult.length, (Object)3);
        Assert.assertEquals((Object)sResult[0], (Object)"abc");
        Assert.assertEquals((Object)sResult[1], (Object)"defgghh");
        Assert.assertEquals((Object)sResult[2], (Object)"xyz");
    }

    @Test
    public void testAscii() throws Exception {
        String sTest = "\u00e0\u00e8\u00f9\u00e9";
        String sCheck = "aeue";
        String sConv = Utils.convertNonAscii(sTest);
        Assert.assertEquals((Object)sConv, (Object)sCheck);
    }
}

