/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.commons;

import com.f3p.commons.Utils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileStreamUtils {
    private static Log s_logger = LogFactory.getLog(FileStreamUtils.class);
    private static final long ONE_KB = 1024L;
    private static final long ONE_MB = 0x100000L;
    private static final long ONE_GB = 0x40000000L;
    private static final String FILENAME_SAFE = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-_+=#. ";

    public static String getNameWithoutExt(String sFileName) {
        String sReturn = sFileName;
        int nIndex = sFileName.lastIndexOf(".");
        if (nIndex != -1) {
            sReturn = sFileName.substring(0, nIndex);
        }
        return sReturn;
    }

    public static void closeImageStream(ImageInputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception e) {
                s_logger.error((Object)e);
            }
        }
    }

    public static void closeImageStream(ImageOutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception e) {
                s_logger.error((Object)e);
            }
        }
    }

    public static void closeStream(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception e) {
                s_logger.error((Object)e);
            }
        }
    }

    public static void closeStream(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception e) {
                s_logger.error((Object)e);
            }
        }
    }

    public static void closeStream(Reader rd) {
        if (rd != null) {
            try {
                rd.close();
            }
            catch (Exception e) {
                s_logger.error((Object)e);
            }
        }
    }

    public static void closeStream(Writer wr) {
        if (wr != null) {
            try {
                wr.close();
            }
            catch (Exception e) {
                s_logger.error((Object)e);
            }
        }
    }

    public static void bytesToFile(byte[] bytes, File file) throws IOException {
        ByteArrayInputStream bis = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            bis = new ByteArrayInputStream(bytes);
            FileStreamUtils.transferStream(bis, fos);
        }
        catch (Throwable throwable) {
            FileStreamUtils.closeStream(fos);
            FileStreamUtils.closeStream(bis);
            bis = null;
            fos = null;
            throw throwable;
        }
        FileStreamUtils.closeStream(fos);
        FileStreamUtils.closeStream(bis);
        bis = null;
        fos = null;
    }

    public static byte[] fileToBytes(File file) throws IOException {
        byte[] byArray;
        FileInputStream fis = null;
        ByteArrayOutputStream bos = null;
        try {
            fis = new FileInputStream(file);
            bos = new ByteArrayOutputStream();
            FileStreamUtils.transferStream(fis, bos);
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            FileStreamUtils.closeStream(fis);
            FileStreamUtils.closeStream(bos);
            throw throwable;
        }
        FileStreamUtils.closeStream(fis);
        FileStreamUtils.closeStream(bos);
        return byArray;
    }

    public static String fileToString(File file, String sCharsetName) throws IOException {
        String string;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fis, sCharsetName));
            StringWriter writer = new StringWriter();
            FileStreamUtils.transferStream(reader, writer);
            string = ((Object)writer).toString();
        }
        catch (Throwable throwable) {
            FileStreamUtils.closeStream(fis);
            throw throwable;
        }
        FileStreamUtils.closeStream(fis);
        return string;
    }

    public static void transferStream(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[16384];
        int iRead = 0;
        do {
            if ((iRead = is.read(buffer)) < 0) continue;
            os.write(buffer, 0, iRead);
        } while (iRead >= 0);
        os.flush();
    }

    public static void transferStream(Reader r, Writer w) throws IOException {
        char[] buffer = new char[16384];
        int iRead = 0;
        do {
            if ((iRead = r.read(buffer)) < 0) continue;
            w.write(buffer, 0, iRead);
        } while (iRead >= 0);
        w.flush();
    }

    public static String setFileExtension(String sPath, String sExt) {
        String sDotExt = "." + sExt;
        if (!sPath.toLowerCase().endsWith(sDotExt)) {
            int iDot = sPath.lastIndexOf(46);
            sPath = iDot >= 0 ? String.valueOf(sPath.substring(0, iDot)) + sDotExt : String.valueOf(sPath) + sDotExt;
            return sPath;
        }
        return sPath;
    }

    public static File setFileExtension(File fOrig, String sExt) {
        String sAbsPath = fOrig.getAbsolutePath();
        String sRen = FileStreamUtils.setFileExtension(sAbsPath, sExt);
        if (sRen == sAbsPath) {
            return fOrig;
        }
        return new File(sRen);
    }

    public static String getFileExtension(String sFilename) {
        String sExt = null;
        int index = sFilename.lastIndexOf(46);
        if (index != -1) {
            sExt = sFilename.substring(index + 1);
        }
        return sExt;
    }

    public static File getTempFile(String sPrefix, String sPostfix) {
        String sName = String.valueOf(sPrefix) + Long.toString(System.currentTimeMillis()) + sPostfix;
        return new File(System.getProperty("java.io.tmpdir"), sName);
    }

    public static String formatAsFileSize(long size) {
        String sDisplaySize = size / 0x40000000L > 0L ? String.valueOf(String.valueOf(size / 0x40000000L)) + " GB" : (size / 0x100000L > 0L ? String.valueOf(String.valueOf(size / 0x100000L)) + " MB" : (size / 1024L > 0L ? String.valueOf(String.valueOf(size / 1024L)) + " KB" : String.valueOf(String.valueOf(size)) + " B"));
        return sDisplaySize;
    }

    public static String convertToSafeFilename(String sFilename, char chInvalidReplace) {
        if (Utils.isEmptyString(sFilename)) {
            return null;
        }
        StringBuilder sbName = new StringBuilder(Utils.convertNonAscii(sFilename.trim()));
        int i = 0;
        while (i < sbName.length()) {
            char cVal = sbName.charAt(i);
            if (FILENAME_SAFE.indexOf(cVal) < 0) {
                sbName.setCharAt(i, chInvalidReplace);
            }
            ++i;
        }
        return sbName.toString();
    }
}

