/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.commons;

import java.sql.Timestamp;
import java.util.Calendar;

public class DateUtils {
    public static Timestamp assembleDateTime(Timestamp tsDate, Timestamp tsTime) {
        Timestamp tsRet = null;
        if (tsDate != null) {
            if (tsTime != null) {
                Calendar calTime = DateUtils.toCalendar(tsTime);
                Calendar calDate = DateUtils.toCalendar(tsDate);
                calTime.set(5, calDate.get(5));
                calTime.set(2, calDate.get(2));
                calTime.set(1, calDate.get(1));
                tsRet = DateUtils.toTimestamp(calTime);
            } else {
                tsRet = tsDate;
            }
        }
        return tsRet;
    }

    public static boolean dateInRange(Calendar x, Calendar start, Calendar end) {
        return !x.before(start) && !x.after(end);
    }

    public static Calendar toCalendar(Timestamp t) {
        Calendar c = Calendar.getInstance();
        c.setTime(t);
        return c;
    }

    public static Timestamp toTimestamp(Calendar c) {
        return new Timestamp(c.getTimeInMillis());
    }

    public static boolean isTimeAfter(Calendar cal1, Calendar cal2) {
        Calendar calC = (Calendar)cal1.clone();
        calC.set(10, cal2.get(10));
        calC.set(12, cal2.get(12));
        calC.set(13, cal2.get(13));
        calC.set(14, cal2.get(14));
        return cal1.after(calC);
    }

    public static boolean isTimeBefore(Calendar cal1, Calendar cal2) {
        Calendar calC = (Calendar)cal1.clone();
        calC.set(10, cal2.get(10));
        calC.set(12, cal2.get(12));
        calC.set(13, cal2.get(13));
        calC.set(14, cal2.get(14));
        return cal1.before(calC);
    }

    public static Calendar getCalendar(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static Calendar getCalendar(int year, int month, int day, int hour, int minute, int second) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        cal.set(14, 0);
        return cal;
    }
}

