/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.workreq.model;

import com.f3p.adempiere.workreq.model.F3PMStatusCategory;
import com.f3p.adempiere.workreq.model.F3PMWFActivity;
import com.f3p.adempiere.workreq.model.F3PMWFResponsible;
import com.f3p.adempiere.workreq.model.F3PMWorkflow;
import org.compiere.model.MClient;
import org.compiere.model.MRequest;
import org.compiere.model.MStatus;
import org.compiere.model.MStatusCategory;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.wf.MWFActivity;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWFProcess;
import org.compiere.wf.MWFResponsible;
import org.compiere.wf.MWorkflow;

public class WorkflowValidator
implements ModelValidator {
    protected static boolean s_bNeedSave = true;
    protected static boolean s_bIsNewRecord = false;
    public static final String SQL_GET_REQ_STATUS = "SELECT R_STATUS_ID FROM R_STATUS,AD_WF_NODE  WHERE R_STATUS.AD_WF_NODE_ID=AD_WF_NODE.AD_WF_NODE_ID AND F3P_ISENTRYNODE = 'Y' AND AD_WF_NODE.AD_WF_NODE_ID = ? AND R_STATUS.ISACTIVE = 'Y' AND AD_WF_NODE.ISACTIVE = 'Y'";

    @Override
    public String docValidate(PO arg0, int arg1) {
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return 0;
    }

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        engine.addModelChange("AD_Workflow", this);
        engine.addModelChange("R_Status", this);
        engine.addModelChange("AD_WF_Node", this);
        engine.addModelChange("AD_WF_NodeNext", this);
        engine.addModelChange("AD_WF_Activity", this);
        engine.addModelChange("AD_WF_Process", this);
    }

    @Override
    public String login(int arg0, int arg1, int arg2) {
        return null;
    }

    @Override
    public String modelChange(PO model, int nType) throws Exception {
        String sReturn = null;
        if (model instanceof MWFActivity) {
            sReturn = this.processActivity(model, nType);
        } else if (model instanceof MWFProcess) {
            sReturn = this.processWFProcess(model, nType);
        } else {
            sReturn = this.processWorkflowValidation(model, nType);
            F3PMWorkflow.resetCache();
        }
        return sReturn;
    }

    protected String processWorkflowValidation(PO model, int nType) throws Exception {
        MWorkflow wf;
        String sReturn = null;
        if (s_bNeedSave && (nType == 2 || nType == 1) && model instanceof MWorkflow && (wf = (MWorkflow)model).getWorkflowType().equals("R")) {
            F3PMWorkflow.validate(wf);
        }
        if (nType == 5 || nType == 4 || nType == 6) {
            MWFNodeNext nextNode;
            int nodeId;
            wf = null;
            if (model instanceof MWFNode) {
                MWFNode node = (MWFNode)model;
                wf = new F3PMWorkflow(model.getCtx(), node.getAD_Workflow_ID(), model.get_TrxName());
            } else if (model instanceof MStatus) {
                MStatus status = (MStatus)model;
                int nStatusCatId = status.getR_StatusCategory_ID();
                MStatusCategory cat = new MStatusCategory(model.getCtx(), nStatusCatId, model.get_TrxName());
                int nWfId = F3PMStatusCategory.getAD_Workflow_ID(cat);
                if (nWfId != 0) {
                    wf = new F3PMWorkflow(model.getCtx(), nWfId, model.get_TrxName());
                }
            } else if (model instanceof MWFNodeNext && (nodeId = (nextNode = (MWFNodeNext)model).getAD_WF_Next_ID()) > 0) {
                MWFNode node = MWFNode.get(model.getCtx(), nodeId);
                wf = new F3PMWorkflow(model.getCtx(), node.getAD_Workflow_ID(), model.get_TrxName());
            }
            if (wf != null) {
                if (wf.getWorkflowType().equals("R")) {
                    sReturn = F3PMWorkflow.validate(wf);
                    s_bNeedSave = false;
                    wf.save();
                }
                s_bNeedSave = true;
            }
        }
        return sReturn;
    }

    protected String processActivity(PO model, int nType) {
        String sReturn = null;
        MWFActivity activity = (MWFActivity)model;
        String state = activity.getWFState();
        int nWfId = activity.getAD_Workflow_ID();
        MWorkflow wf = new MWorkflow(model.getCtx(), nWfId, model.get_TrxName());
        String sWfType = wf.getWorkflowType();
        if (state.equals("CA")) {
            if (nType == 2 && sWfType.equals("R")) {
                int nRequestId = activity.getRecord_ID();
                MRequest request = new MRequest(model.getCtx(), nRequestId, model.get_TrxName());
                request.setProcessed(true);
                MUser user = MUser.get(model.getCtx(), Env.getAD_User_ID(model.getCtx()));
                String msg = String.valueOf(user.getName()) + Msg.getMsg(model.getCtx(), "F3P_WR_ABORT");
                request.setSummary(String.valueOf(request.getSummary()) + " " + msg);
                request.save(activity.get_TrxName());
            }
        } else if (nType == 1 || nType == 2 && !state.equals("OR")) {
            boolean isRespChanged = this.isRespChanged(activity);
            MWFResponsible responsible = activity.getResponsible();
            MWFNode node = activity.getNode();
            int nRuleId = -1;
            int nUserId = -1;
            if (!activity.getWFState().equals("CC") && !isRespChanged && F3PMWFResponsible.isRule(responsible)) {
                nRuleId = F3PMWFResponsible.getAD_Rule_ID(responsible);
                nUserId = F3PMWFResponsible.evaluateRuleResp(null, activity, wf, node, model.getCtx(), nRuleId);
                if (nUserId > 0) {
                    activity.setAD_User_ID(nUserId);
                }
            }
            if (nUserId <= 0) {
                nUserId = activity.getAD_User_ID();
            }
            if (sWfType.equals("R") && (activity.getWFState().equals("ON") || activity.getWFState().equals("OS"))) {
                boolean bUpdateFromRequest = false;
                if (model instanceof F3PMWFActivity) {
                    bUpdateFromRequest = ((F3PMWFActivity)activity).getUpdateFromRequest();
                }
                if (!bUpdateFromRequest && (isRespChanged || activity.is_ValueChanged("WFState"))) {
                    int nRequestId = activity.getRecord_ID();
                    int nStatusId = DB.getSQLValue(model.get_TrxName(), SQL_GET_REQ_STATUS, node.get_ID());
                    MRequest request = new MRequest(model.getCtx(), nRequestId, model.get_TrxName());
                    if (nStatusId > 0) {
                        request.setR_Status_ID(nStatusId);
                    }
                    request.setSalesRep_ID(nUserId);
                    if (!request.save(model.get_TrxName())) {
                        sReturn = Msg.getMsg(activity.getCtx(), "F3P_WR_GENERIC_ERROR");
                    }
                }
            }
        }
        return sReturn;
    }

    protected String processWFProcess(PO model, int nType) {
        MWFProcess process;
        MWFResponsible responsible;
        if (nType == 1 && F3PMWFResponsible.isRule(responsible = (MWFResponsible)(process = (MWFProcess)model).getAD_WF_Responsible())) {
            MWorkflow wf = (MWorkflow)process.getAD_Workflow();
            int nRuleId = F3PMWFResponsible.getAD_Rule_ID(responsible);
            int AD_User_ID = F3PMWFResponsible.evaluateRuleResp(process, null, wf, null, model.getCtx(), nRuleId);
            if (AD_User_ID != 0) {
                process.setAD_User_ID(AD_User_ID);
            }
        }
        return null;
    }

    protected boolean isRespChanged(MWFActivity activity) {
        boolean bChanged = activity.is_ValueChanged("AD_User_ID");
        if (activity.get_ValueOld("AD_User_ID") == null) {
            bChanged = false;
        }
        return bChanged;
    }
}

