/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.workreq.model;

import com.f3p.adempiere.util.EnvHelper;
import com.f3p.adempiere.util.IDResolver;
import com.f3p.adempiere.workreq.model.F3PMRequest;
import com.f3p.adempiere.workreq.model.F3PMRequestType;
import com.f3p.adempiere.workreq.model.F3PMStatus;
import com.f3p.adempiere.workreq.model.F3PMWFActivity;
import com.f3p.adempiere.workreq.model.F3PMWorkflow;
import com.f3p.adempiere.workreq.model.RequestHelper;
import com.f3p.commons.Utils;
import java.util.Properties;
import java.util.logging.Level;
import javax.script.ScriptEngine;
import org.compiere.model.MClient;
import org.compiere.model.MRequest;
import org.compiere.model.MRule;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Workflow;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.wf.MWorkflow;

public class RequestValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(RequestValidator.class);
    public static final String SCRIPT_GROOVY = "groovy";
    public static final String SCRIPT_BEANSHELL = "beanshell";
    public static final String F3P_ARGUMENTS_PREFIX = "F3P_";
    protected static boolean s_needUpdate = true;

    @Override
    public String docValidate(PO arg0, int arg1) {
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return 0;
    }

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        engine.addModelChange("R_Request", this);
    }

    @Override
    public String login(int arg0, int arg1, int arg2) {
        return null;
    }

    @Override
    public String modelChange(PO model, int nType) throws Exception {
        Integer obj;
        int nRuleId;
        String sReturn = null;
        MRequest request = (MRequest)model;
        int nRequestTypeId = request.getR_RequestType_ID();
        F3PMRequestType reqType = new F3PMRequestType(request.getCtx(), nRequestTypeId, request.get_TrxName());
        if ((nType == 2 || nType == 1 || nType == 3 || nType == 9) && (nRuleId = (obj = Integer.valueOf(reqType.getAD_Rule_ID())).intValue()) > 0) {
            sReturn = this.evaluateRule(request, nRuleId, nType, request.getCtx());
        }
        if (Utils.isEmptyString(sReturn)) {
            if (nType == 4) {
                int nWorkflowId = F3PMRequest.getWorkFlowID(request);
                if (nWorkflowId > 0) {
                    F3PMWorkflow wf = new F3PMWorkflow(request.getCtx(), nWorkflowId, request.get_TrxName());
                    if (wf.isValid()) {
                        int AD_Table_ID = IDResolver.getAD_Table_ID("R_Request");
                        int AD_Process_ID = 305;
                        ProcessInfo pi = new ProcessInfo(wf.getName(), AD_Process_ID, AD_Table_ID, request.get_ID());
                        pi.setAD_User_ID(Env.getAD_User_ID(request.getCtx()));
                        pi.setAD_Client_ID(request.getAD_Client_ID());
                        if (wf.start(pi, request.get_TrxName()) != null) {
                            log.config(wf.getName());
                        } else {
                            sReturn = Msg.getMsg(request.getCtx(), "F3P_WR_CANT_START");
                        }
                    } else {
                        sReturn = String.valueOf(Msg.getMsg(request.getCtx(), "F3P_WR_VALID_INVALIDWF")) + F3PMWorkflow.getValidationErrors(wf);
                    }
                }
            } else if (nType == 2 && s_needUpdate) {
                int nWorkflowId = F3PMRequest.getWorkFlowID(request);
                X_AD_Workflow wf = null;
                if (nWorkflowId > 0) {
                    wf = F3PMWorkflow.get(request.getCtx(), nWorkflowId);
                }
                if (wf != null && wf.isValid()) {
                    F3PMWFActivity activity;
                    if (request.is_ValueChanged("R_Status_ID")) {
                        int nOldNodeId;
                        Integer ii = (Integer)request.get_ValueOld("R_Status_ID");
                        int nOldStatusId = 0;
                        if (ii instanceof Integer) {
                            nOldStatusId = ii;
                        }
                        F3PMStatus statusNew = new F3PMStatus(request.getCtx(), request.getR_Status_ID(), request.get_TrxName());
                        F3PMStatus statusOld = new F3PMStatus(request.getCtx(), nOldStatusId, request.get_TrxName());
                        int nNewNodeId = F3PMStatus.getAD_WF_Node_Id(statusNew);
                        if (nNewNodeId != (nOldNodeId = F3PMStatus.getAD_WF_Node_Id(statusOld))) {
                            boolean bRespManualChanged = false;
                            if (request.is_ValueChanged("SalesRep_ID")) {
                                bRespManualChanged = true;
                            }
                            s_needUpdate = false;
                            sReturn = F3PMRequest.fireRequestChangedStatus(request, nNewNodeId, bRespManualChanged);
                            s_needUpdate = true;
                            request.load(request.get_TrxName());
                            if (!Utils.isEmptyString(sReturn)) {
                                return sReturn;
                            }
                        }
                    }
                    if (request.is_ValueChanged("SalesRep_ID") && (activity = F3PMRequest.getCurrentActivity(request, -1)) != null && activity.getAD_User_ID() != request.getSalesRep_ID()) {
                        activity.setUpdateFromRequest(true);
                        activity.setAD_User_ID(request.getSalesRep_ID());
                        s_needUpdate = false;
                        activity.save(request.get_TrxName());
                        s_needUpdate = true;
                        activity.setUpdateFromRequest(false);
                    }
                } else if (wf != null) {
                    sReturn = F3PMWorkflow.getValidationErrors((MWorkflow)wf);
                }
            }
        }
        return sReturn;
    }

    public String evaluateRule(MRequest request, int nRuleId, int nType, Properties ctx) {
        String retValue = "";
        MRule rule = MRule.get(ctx, nRuleId);
        String sRuleName = rule.getValue().toLowerCase();
        if (sRuleName.startsWith(SCRIPT_GROOVY) || sRuleName.startsWith(SCRIPT_BEANSHELL)) {
            ScriptEngine engine = rule.getScriptEngine();
            int winNo = -1;
            try {
                winNo = EnvHelper.getFocusWindowNo();
            }
            catch (Exception e) {
                winNo = Env.createWindowNo(null);
            }
            MRule.setContext(engine, ctx, winNo);
            RequestHelper requestHelper = new RequestHelper(request);
            engine.put("A_WindowNo", winNo);
            engine.put("A_Ctx", ctx);
            engine.put("A_Request", request);
            engine.put("F3P_RequestHelper", requestHelper);
            engine.put("F3P_InvocationType", nType);
            try {
                retValue = engine.eval(rule.getScript()).toString();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getLocalizedMessage());
                retValue = String.valueOf(Msg.getMsg(request.getCtx(), "F3P_WR_RULE_REQ_WRONG")) + e.toString();
            }
        } else {
            retValue = Msg.getMsg(ctx, "F3P_WR_RULE_REQ_WRONGTYPE");
            log.log(Level.SEVERE, retValue);
        }
        return retValue;
    }
}

