/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.workreq.model;

import com.f3p.adempiere.workreq.model.WFValidationRule;
import com.f3p.commons.JDBCUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWorkflow;

public class F3PMWorkflow
extends MWorkflow {
    private static final long serialVersionUID = 1L;
    private static CLogger log = CLogger.getCLogger(F3PMWorkflow.class);
    public static final String MANUAL_ACTION = "'X','C','T','W'";
    public static final String WORKFLOWTYPE_Request = "R";
    public static final String ERROR_DELIMITER = "##\n";
    public static LinkedList<WFValidationRule> s_validationRules = null;
    public static final String SQL_WFCOND_0 = "select 'ko', n.name from ad_workflow wf join ad_wf_node n ON n.ad_wf_node_id=wf.ad_wf_node_id where wf.ad_workflow_id=?\tAND n.ACTION NOT IN (#)";
    public static final String SQL_WFCOND_1 = "SELECT n.AD_WF_NODE_ID, n.VALUE FROM AD_WF_NODE n WHERE n.AD_WORKFLOW_ID = ? AND n.ACTION IN (#) AND n.ISACTIVE='Y' AND NOT EXISTS (SELECT 'ko' FROM R_STATUS s WHERE s.AD_WF_NODE_ID=n.AD_WF_NODE_ID AND s.F3P_ISENTRYNODE='Y' AND s.ISACTIVE='Y')";
    public static final String SQL_WFCOND_2 = "SELECT n.AD_WF_NODE_ID, n.VALUE FROM AD_WF_NODE n WHERE n.AD_WORKFLOW_ID = ? AND n.ACTION IN (#) AND NOT EXISTS (SELECT 'ko'  FROM AD_WF_NODENEXT next JOIN AD_WF_NODE node ON  node.ad_wf_node_id=next.ad_wf_next_id  WHERE n.AD_WF_NODE_ID=next.AD_WF_NODE_ID AND next.AD_WF_NEXT_ID IS NOT NULL  AND next.AD_WF_NEXT_ID<>n.AD_WF_NODE_ID AND next.ISACTIVE='Y' AND node.isactive='Y') AND n.ISACTIVE='Y'";
    public static final String SQL_WFCOND_3 = "SELECT n.AD_WF_NODE_ID, n.VALUE FROM AD_WF_NODE n, R_STATUS s WHERE n.AD_WORKFLOW_ID = ? AND s.AD_WF_NODE_ID=n.AD_WF_NODE_ID AND n.ACTION IN (#) AND n.ISACTIVE='Y' AND s.ISFINALCLOSE='Y' AND s.ISACTIVE='Y'";
    public static final String SQL_WFCOND_4 = "SELECT n.AD_WF_NODE_ID, n.VALUE FROM AD_WF_NODE n WHERE n.AD_WORKFLOW_ID = ? AND n.ACTION NOT IN (#) AND n.ISACTIVE='Y' AND NOT EXISTS (SELECT 'ko' FROM AD_WF_NODENEXT next JOIN AD_WF_NODE node ON  node.ad_wf_node_id=next.ad_wf_next_id  WHERE n.AD_WF_NODE_ID=next.AD_WF_NODE_ID AND next.AD_WF_NEXT_ID IS NOT NULL AND next.AD_WF_NEXT_ID<>n.AD_WF_NODE_ID AND next.ISACTIVE='Y' AND node.isactive='Y')  AND NOT EXISTS (SELECT 'ko' FROM R_STATUS s WHERE s.AD_WF_NODE_ID=n.AD_WF_NODE_ID AND s.ISFINALCLOSE='Y' AND s.ISACTIVE='Y')";
    public static final String SQL_WFCOND_5 = "SELECT n.AD_WF_NODE_ID, n.VALUE FROM AD_WF_NODE n  WHERE NOT EXISTS (SELECT 'ko' FROM R_STATUS s WHERE s.AD_WF_NODE_ID=n.AD_WF_NODE_ID AND s.F3P_ISENTRYNODE='Y' AND s.ISACTIVE='Y') AND n.AD_WF_NODE_ID IN (select DISTINCT(AD_WF_NODENEXT.AD_WF_NEXT_ID) from AD_WF_NODE,AD_WF_NODENEXT join ad_wf_node node ON node.ad_wf_node_id=AD_WF_NODENEXT.ad_wf_next_id  WHERE AD_WF_NODE.AD_WF_NODE_ID=AD_WF_NODENEXT.AD_WF_NODE_ID AND AD_WF_NODE.AD_WORKFLOW_ID = ? AND AD_WF_NODE.ACTION IN (#) AND AD_WF_NODE.ISACTIVE='Y' AND AD_WF_NODENEXT.ISACTIVE='Y'  AND node.isactive='Y')";
    public static final String SQL_WFCOND_6 = "select COUNT(*), 'Categoria Stati' from r_statuscategory c where c.ad_workflow_id = ? and c.isactive='Y' having COUNT(*) > 1";
    public static final String SQL_WFCOND_7 = "select 'ko', s.r_status_id ||' - '|| s.name from r_statuscategory c join r_status s ON s.r_statuscategory_id=c.r_statuscategory_id join ad_wf_node n ON n.ad_wf_node_id=s.ad_wf_node_id where c.ad_workflow_id = ? and c.isactive='Y' and s.isactive='Y' and n.isactive='Y' and n.ad_workflow_id <> c.ad_workflow_id";
    private static final CCache<Integer, F3PMWorkflow> s_cache = new CCache("F3P_AD_Workflow", 20);
    protected int m_nNextNodeId = -1;
    protected String m_sValidationErrors = null;

    public F3PMWorkflow(Properties ctx, int AD_Workflow_ID, String trxName) {
        super(ctx, AD_Workflow_ID, trxName);
    }

    public F3PMWorkflow(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static F3PMWorkflow get(Properties ctx, int AD_Workflow_ID) {
        Integer key = new Integer(AD_Workflow_ID);
        F3PMWorkflow retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new F3PMWorkflow(ctx, AD_Workflow_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static void resetCache() {
        s_cache.clear();
    }

    @Override
    public MWFNodeNext[] getNodeNexts(int AD_WF_Node_ID, int AD_Client_ID) {
        MWFNodeNext[] retValue = new MWFNodeNext[1];
        if (this.m_nNextNodeId > 0) {
            MWFNode[] nodes = this.getNodesInOrder(AD_Client_ID);
            int i = 0;
            while (i < nodes.length) {
                if (nodes[i].getAD_WF_Node_ID() == AD_WF_Node_ID) {
                    MWFNodeNext[] tree = nodes[i].getTransitions(AD_Client_ID);
                    int j = 0;
                    while (j < tree.length) {
                        if (tree[j].getAD_WF_Next_ID() == this.m_nNextNodeId) {
                            retValue[0] = tree[j];
                            this.m_nNextNodeId = 0;
                            return retValue;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return null;
        }
        return super.getNodeNexts(AD_WF_Node_ID, AD_Client_ID);
    }

    public static String validate(MWorkflow wf, LinkedList<WFValidationRule> lstValidationRules) {
        boolean bValid = true;
        String sReturn = null;
        StringBuffer sbValidationFail = new StringBuffer();
        if (wf.getAD_WF_Node_ID() == 0) {
            sbValidationFail.append(Msg.getMsg(wf.getCtx(), "F3P_WR_VALID_NOSTARTNODE"));
            bValid = false;
        }
        for (WFValidationRule valRule : lstValidationRules) {
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    String sqlQuery = valRule.getSQLRule().replaceAll("#", MANUAL_ACTION);
                    pstmt = DB.prepareStatement(sqlQuery, wf.get_TrxName());
                    pstmt.setInt(1, wf.get_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        bValid = false;
                        sbValidationFail.append("Elemento: " + rs.getString(2) + Msg.getMsg(wf.getCtx(), valRule.getAD_Msg()));
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, e.getLocalizedMessage());
                    sReturn = "SQL ERROR: " + e.getLocalizedMessage();
                    bValid = false;
                    JDBCUtils.closeResults(pstmt, rs);
                    continue;
                }
            }
            catch (Throwable throwable) {
                JDBCUtils.closeResults(pstmt, rs);
                throw throwable;
            }
            JDBCUtils.closeResults(pstmt, rs);
        }
        wf.setIsValid(bValid);
        F3PMWorkflow.setValidationErrors(wf, sbValidationFail.toString());
        return sReturn;
    }

    public static String validate(MWorkflow wf) {
        if (s_validationRules == null) {
            s_validationRules = new LinkedList();
            s_validationRules.add(new WFValidationRule(SQL_WFCOND_0, "F3P_WR_VALID_COND0"));
            s_validationRules.add(new WFValidationRule(SQL_WFCOND_1, "F3P_WR_VALID_COND1"));
            s_validationRules.add(new WFValidationRule(SQL_WFCOND_2, "F3P_WR_VALID_COND2"));
            s_validationRules.add(new WFValidationRule(SQL_WFCOND_3, "F3P_WR_VALID_COND3"));
            s_validationRules.add(new WFValidationRule(SQL_WFCOND_4, "F3P_WR_VALID_COND4"));
            s_validationRules.add(new WFValidationRule(SQL_WFCOND_5, "F3P_WR_VALID_COND5"));
            s_validationRules.add(new WFValidationRule(SQL_WFCOND_6, "F3P_WR_VALID_COND6"));
            s_validationRules.add(new WFValidationRule(SQL_WFCOND_7, "F3P_WR_VALID_COND7"));
        }
        return F3PMWorkflow.validate(wf, s_validationRules);
    }

    public static String getValidationErrors(MWorkflow wf) {
        String sHelp = wf.getHelp();
        int nIndex = sHelp.indexOf(ERROR_DELIMITER);
        if (nIndex > -1) {
            return sHelp.substring(nIndex + ERROR_DELIMITER.length(), sHelp.length() - ERROR_DELIMITER.length() - 1);
        }
        return sHelp;
    }

    public static void setValidationErrors(MWorkflow wf, String sErrors) {
        int nIndex;
        String sHelp = wf.getHelp();
        if (sHelp == null) {
            sHelp = "";
        }
        if ((nIndex = sHelp.indexOf(ERROR_DELIMITER)) > -1) {
            sHelp = sHelp.substring(0, nIndex);
        }
        if (sErrors.length() > 0) {
            sHelp = String.valueOf(sHelp) + ERROR_DELIMITER + sErrors.toString() + ERROR_DELIMITER;
        }
        wf.setHelp(sHelp);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.isValid()) {
            return super.beforeSave(newRecord);
        }
        return true;
    }

    protected void setNextNodeId(int nextNodeId) {
        this.m_nNextNodeId = nextNodeId;
    }

    protected int getNextNodeId() {
        return this.m_nNextNodeId;
    }

    public static /* bridge */ /* synthetic */ MWorkflow get(Properties properties, int n) {
        return F3PMWorkflow.get(properties, n);
    }
}

