/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.workreq.model;

import com.f3p.adempiere.util.EnvHelper;
import com.f3p.commons.JDBCUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.script.ScriptEngine;
import org.compiere.model.MRule;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.wf.MWFActivity;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFProcess;
import org.compiere.wf.MWFResponsible;
import org.compiere.wf.MWorkflow;

public class F3PMWFResponsible
extends MWFResponsible {
    private static final long serialVersionUID = 1L;
    private static CLogger log = CLogger.getCLogger(F3PMWFResponsible.class);
    public static final String RESPONSIBLETYPE_Rule = "D";
    public static final String COLUMNNAME_AD_RULE_ID = "AD_RULE_ID";

    public F3PMWFResponsible(Properties ctx, int AD_WF_Responsible_ID, String trxName) {
        super(ctx, AD_WF_Responsible_ID, trxName);
    }

    public F3PMWFResponsible(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static boolean isRule(MWFResponsible resp) {
        return RESPONSIBLETYPE_Rule.equals(resp.getResponsibleType());
    }

    public boolean isRule() {
        return RESPONSIBLETYPE_Rule.equals(this.getResponsibleType());
    }

    public static int getAD_Rule_ID(MWFResponsible resp) {
        Object ii = resp.get_Value(COLUMNNAME_AD_RULE_ID);
        if (ii instanceof Integer) {
            return (Integer)ii;
        }
        return 0;
    }

    public static int evaluateRuleResp(MWFProcess process, MWFActivity activity, MWorkflow wf, MWFNode node, Properties ctx, int nRuleId) {
        int nUserId = 0;
        MRule rule = MRule.get(ctx, nRuleId);
        String sRuleType = rule.getRuleType();
        if (sRuleType.equals("S")) {
            ScriptEngine engine = rule.getScriptEngine();
            int winNo = EnvHelper.getFocusWindowNo();
            MRule.setContext(engine, ctx, winNo);
            engine.put("A_WindowNo", winNo);
            engine.put("A_Ctx", ctx);
            if (process != null) {
                engine.put("A_Process", process);
            }
            if (activity != null) {
                engine.put("A_Activity", activity);
            }
            if (wf != null) {
                engine.put("A_Wf", wf);
            }
            if (node != null) {
                engine.put("A_WFNode", node);
            }
            try {
                Object obj = engine.eval(rule.getScript());
                if (obj instanceof Integer) {
                    nUserId = (Integer)obj;
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getLocalizedMessage());
                nUserId = 0;
            }
        } else if (sRuleType.equals("Q")) {
            int winNo = EnvHelper.getFocusWindowNo();
            Properties ctxCloned = new Properties();
            ctxCloned.putAll((Map<?, ?>)ctx);
            String sTrx = null;
            if (process != null) {
                Env.setContext(ctxCloned, winNo, "AD_WF_Process_ID", process.get_ID());
                sTrx = process.get_TrxName();
            }
            if (activity != null) {
                Env.setContext(ctxCloned, winNo, "AD_WF_Activity_ID", activity.get_ID());
                Env.setContext(ctxCloned, winNo, "AD_Table_ID", activity.getAD_Table_ID());
                Env.setContext(ctxCloned, winNo, "Record_ID", activity.getRecord_ID());
                sTrx = activity.get_TrxName();
            }
            String sSQL = EnvHelper.parseStringWithEnv(ctxCloned, rule.getScript(), winNo, -1);
            CPreparedStatement pstmt = DB.prepareStatement(sSQL, sTrx);
            ResultSet rs = null;
            try {
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    nUserId = rs.getInt(1);
                }
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, e.getLocalizedMessage());
                nUserId = 0;
            }
            JDBCUtils.closeResults(pstmt, rs);
        } else {
            log.log(Level.SEVERE, Msg.getMsg(ctx, "F3P_WR_RULE_RESP_WRONGTYPE"));
        }
        return nUserId;
    }
}

