/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.workreq.model;

import com.f3p.adempiere.util.IDResolver;
import com.f3p.adempiere.workreq.model.F3PMRequestType;
import com.f3p.adempiere.workreq.model.F3PMStatusCategory;
import com.f3p.adempiere.workreq.model.F3PMWFActivity;
import com.f3p.commons.JDBCUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MRequest;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.wf.MWFNode;

public class F3PMRequest
extends MRequest {
    private static final long serialVersionUID = 1L;
    private static CLogger s_log = CLogger.getCLogger(F3PMRequest.class);
    public static final String COLUMNNAME_F3P_PROGRESS = "F3P_Progress";
    public static final String COLUMNNAME_F3P_WFNODE_ID = "F3P_WFNode_ID";
    public static final String SQL_WF_ACTIVITY = "SELECT ac.* FROM AD_WF_PROCESS pr,AD_WF_ACTIVITY ac WHERE pr.RECORD_ID=? AND pr.AD_TABLE_ID= ? AND pr.AD_WF_PROCESS_ID=ac.AD_WF_PROCESS_ID AND ac.WFSTATE = ?";
    public static final String SQL_ACTUAL_NODE = "SELECT node.* FROM AD_WF_NODE node, AD_WF_PROCESS pr,AD_WF_ACTIVITY ac WHERE pr.RECORD_ID=? AND pr.AD_TABLE_ID= ? AND pr.AD_WF_PROCESS_ID=ac.AD_WF_PROCESS_ID AND node.AD_WF_NODE_ID=ac.AD_WF_NODE_ID AND ac.WFSTATE = ?";
    public static final String SQL_GET_REQ_STATUS = "SELECT R_STATUS_ID FROM R_STATUS,AD_WF_NODE  WHERE R_STATUS.AD_WF_NODE_ID=AD_WF_NODE.AD_WF_NODE_ID AND F3P_ISENTRYNODE = 'Y' AND AD_WF_NODE.AD_WF_NODE_ID = ? AND R_STATUS.ISACTIVE = 'Y' AND AD_WF_NODE.ISACTIVE = 'Y'";
    public static final String TRX_NAME = "F3PWFREQ";

    public F3PMRequest(Properties ctx, int R_Request_ID, String trxName) {
        super(ctx, R_Request_ID, trxName);
    }

    public F3PMRequest(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public F3PMRequest(Properties arg0, int arg1, int arg2, String arg3, boolean arg4, String arg5) {
        super(arg0, arg1, arg2, arg3, arg4, arg5);
    }

    public static int getWorkFlowID(MRequest request) {
        Properties ctx = request.getCtx();
        String sTrx = request.get_TrxName();
        int nRequestTypeId = request.getR_RequestType_ID();
        F3PMRequestType reqType = new F3PMRequestType(ctx, nRequestTypeId, sTrx);
        int nStatusCategoryId = reqType.getR_StatusCategory_ID();
        F3PMStatusCategory statusCategory = new F3PMStatusCategory(ctx, nStatusCategoryId, sTrx);
        int nWorkflowId = F3PMStatusCategory.getAD_Workflow_ID(statusCategory);
        return nWorkflowId;
    }

    public static String fireRequestChangedStatus(MRequest request, int nextNodeId, boolean bRespManualChanged) {
        String sReturn = null;
        String textMsg = request.getLastResult();
        F3PMWFActivity activity = F3PMRequest.getCurrentActivity(request, nextNodeId);
        if (activity != null) {
            int AD_User_ID = Env.getAD_User_ID(Env.getCtx());
            activity.set_TrxName(request.get_TrxName());
            try {
                activity.setUserConfirmation(AD_User_ID, textMsg);
            }
            catch (RuntimeException e) {
                s_log.log(Level.SEVERE, e.getLocalizedMessage());
                sReturn = String.valueOf(e.toString()) + ": " + Msg.getMsg(request.getCtx(), "F3P_WR_RULE_RESP_WRONG");
            }
        } else {
            sReturn = Msg.getMsg(request.getCtx(), "F3P_WR_NO_ACTIVITY");
        }
        return sReturn;
    }

    public static MWFNode getActualNode(MRequest request) throws SQLException {
        MWFNode node = null;
        CPreparedStatement pstmt = DB.prepareStatement(SQL_ACTUAL_NODE, request.get_TrxName());
        pstmt.setInt(1, request.get_ID());
        pstmt.setInt(2, IDResolver.getAD_Table_ID("R_Request"));
        pstmt.setString(3, "OS");
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            node = new MWFNode(request.getCtx(), rs, request.get_TrxName());
        }
        JDBCUtils.closeResults(pstmt, rs);
        return node;
    }

    public static F3PMWFActivity getCurrentActivity(MRequest request, int nextNodeId) {
        F3PMWFActivity activity = null;
        CPreparedStatement pstmt = DB.prepareStatement(SQL_WF_ACTIVITY, request.get_TrxName());
        try {
            pstmt.setInt(1, request.get_ID());
            pstmt.setInt(2, IDResolver.getAD_Table_ID("R_Request"));
            pstmt.setString(3, "OS");
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                activity = new F3PMWFActivity(request.getCtx(), rs, request.get_TrxName(), nextNodeId);
            }
            JDBCUtils.closeResults(pstmt, rs);
        }
        catch (SQLException e1) {
            s_log.log(Level.SEVERE, e1.getLocalizedMessage());
            activity = null;
        }
        return activity;
    }

    public static BigDecimal getF3P_Progress(MRequest request) {
        Object ii = request.get_Value(COLUMNNAME_F3P_PROGRESS);
        if (ii instanceof BigDecimal) {
            return (BigDecimal)ii;
        }
        return BigDecimal.ZERO;
    }

    public static void setF3P_Progress(MRequest request, BigDecimal bdProgress) {
        request.set_ValueOfColumn(COLUMNNAME_F3P_PROGRESS, (Object)bdProgress);
    }

    public static void setF3P_WFNode_ID(MRequest request, Integer F3P_WFNode_ID) {
        request.set_ValueOfColumn(COLUMNNAME_F3P_WFNODE_ID, (Object)F3P_WFNode_ID);
    }

    public static Integer getF3P_WFNode_ID(MRequest request) {
        Object ii = request.get_Value(COLUMNNAME_F3P_WFNODE_ID);
        if (ii instanceof Integer) {
            return (Integer)ii;
        }
        return 0;
    }
}

