/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MSequence;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Sequence_No;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Trx;

public class SequenceHelper {
    private static final Level LOGLEVEL = Level.ALL;
    private static final int QUERY_TIME_OUT = 10;
    private static final CLogger s_log = CLogger.getCLogger(SequenceHelper.class);

    public static void ensureYearSequenceNoExists(Properties ctx, int AD_Sequence_ID, String sYear, String sTrx) {
        int iStartNo;
        int iCheck = DB.getSQLValue(sTrx, "SELECT 1 FROM AD_Sequence_No WHERE AD_Sequence_ID = ? AND CalendarYear = ?", AD_Sequence_ID, sYear);
        if (iCheck < 0 && (iStartNo = DB.getSQLValue(sTrx, "SELECT StartNo FROM AD_Sequence WHERE AD_Sequence_ID = ? AND StartNewYear = 'Y'", AD_Sequence_ID)) > 0) {
            X_AD_Sequence_No mSeqNo = new X_AD_Sequence_No(ctx, 0, sTrx);
            mSeqNo.setCalendarYear(sYear);
            mSeqNo.setAD_Sequence_ID(AD_Sequence_ID);
            mSeqNo.setCurrentNext(iStartNo);
            mSeqNo.saveEx();
        }
    }

    public static String getDocumentNo(int AD_Client_ID, int AD_Sequence_ID, String trxName, PO po) {
        String dateColumn;
        boolean isStartNewYear;
        ResultSet rs;
        PreparedStatement pstmt;
        boolean adempiereSys;
        block43: {
            if (AD_Sequence_ID <= 0) {
                throw new IllegalArgumentException("SequenceID missing");
            }
            adempiereSys = Ini.isPropertyBool("AdempiereSys");
            if (adempiereSys && AD_Client_ID > 11) {
                adempiereSys = false;
            }
            if (CLogMgt.isLevel(LOGLEVEL)) {
                s_log.log(LOGLEVEL, String.valueOf(AD_Sequence_ID) + " - AdempiereSys=" + adempiereSys + " [" + trxName + "]");
            }
            pstmt = null;
            rs = null;
            isStartNewYear = false;
            dateColumn = null;
            if (!adempiereSys) {
                String startNewYearSQL = "SELECT StartNewYear, DateColumn FROM AD_Sequence WHERE AD_Sequence_ID = ? AND IsActive = 'Y' AND IsTableID = 'N' AND IsAutoSequence='Y' AND AD_Client_ID = ?";
                try {
                    try {
                        pstmt = DB.prepareStatement(startNewYearSQL, trxName);
                        pstmt.setInt(1, AD_Sequence_ID);
                        pstmt.setInt(2, AD_Client_ID);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            isStartNewYear = "Y".equals(rs.getString(1));
                            dateColumn = rs.getString(2);
                        }
                    }
                    catch (Exception e) {
                        s_log.log(Level.SEVERE, "(Table) [" + trxName + "]", e);
                        DB.close(rs, pstmt);
                        break block43;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
                DB.close(rs, pstmt);
            }
        }
        String selectSQL = null;
        selectSQL = !DB.isOracle() ? (isStartNewYear ? "SELECT y.CurrentNext, s.CurrentNextSys, s.IncrementNo, s.Prefix, s.Suffix, s.DecimalPattern, s.AD_Sequence_ID FROM AD_Sequence_No y, AD_Sequence s WHERE y.AD_Sequence_ID = s.AD_Sequence_ID AND s.Name = ? AND s.AD_Client_ID = ? AND y.CalendarYear = ? AND s.IsActive='Y' AND s.IsTableID='N' AND s.IsAutoSequence='Y' ORDER BY s.AD_Client_ID DESC FOR UPDATE OF y" : "SELECT CurrentNext, CurrentNextSys, IncrementNo, Prefix, Suffix, DecimalPattern, AD_Sequence_ID FROM AD_Sequence WHERE Name = ? AND AD_Client_ID = ? AND IsActive='Y' AND IsTableID='N' AND IsAutoSequence='Y' ORDER BY AD_Client_ID DESC FOR UPDATE OF AD_Sequence") : (isStartNewYear ? "SELECT y.CurrentNext, s.CurrentNextSys, s.IncrementNo, Prefix, Suffix, DecimalPattern, s.AD_Sequence_ID FROM AD_Sequence_No y, AD_Sequence s WHERE y.AD_Sequence_ID = s.AD_Sequence_ID AND s.AD_Sequence_ID = ? AND s.AD_Client_ID = ? AND y.CalendarYear = ? AND s.IsActive='Y' AND s.IsTableID='N' AND s.IsAutoSequence='Y' ORDER BY s.AD_Client_ID DESC" : "SELECT CurrentNext, CurrentNextSys, IncrementNo, Prefix, Suffix, DecimalPattern, AD_Sequence_ID FROM AD_Sequence WHERE AD_Sequence_ID = ? AND AD_Client_ID = ? AND IsActive='Y' AND IsTableID='N' AND IsAutoSequence='Y' ORDER BY AD_Client_ID DESC");
        Connection conn = null;
        Trx trx = trxName == null ? null : Trx.get(trxName, true);
        int incrementNo = 0;
        int next = -1;
        String prefix = "";
        String suffix = "";
        String decimalPattern = "";
        String calendarYear = "";
        try {
            conn = trx != null ? trx.getConnection() : DB.getConnectionID();
            if (conn == null) {
                return null;
            }
            try {
                if (isStartNewYear) {
                    if (po != null && dateColumn != null && dateColumn.length() > 0) {
                        Date docDate = (Date)po.get_Value(dateColumn);
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
                        calendarYear = sdf.format(docDate);
                    } else {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
                        calendarYear = sdf.format(new Date());
                    }
                }
                SequenceHelper.ensureYearSequenceNoExists(Env.getCtx(), AD_Sequence_ID, calendarYear, trxName);
                pstmt = conn.prepareStatement(selectSQL, 1003, 1008);
                pstmt.setInt(1, AD_Sequence_ID);
                pstmt.setInt(2, AD_Client_ID);
                if (isStartNewYear) {
                    pstmt.setString(3, calendarYear);
                }
                if (DB.getDatabase().isQueryTimeoutSupported()) {
                    pstmt.setQueryTimeout(10);
                }
                if ((rs = pstmt.executeQuery()).next()) {
                    prefix = rs.getString(4);
                    suffix = rs.getString(5);
                    decimalPattern = rs.getString(6);
                    incrementNo = rs.getInt(3);
                    PreparedStatement updateSQL = null;
                    try {
                        if (adempiereSys) {
                            updateSQL = conn.prepareStatement("UPDATE AD_Sequence SET CurrentNextSys = CurrentNextSys + ? WHERE AD_Sequence_ID = ?");
                            next = rs.getInt(2);
                        } else {
                            String sql = isStartNewYear ? "UPDATE AD_Sequence_No SET CurrentNext = CurrentNext + ? WHERE AD_Sequence_ID = ? AND CalendarYear = ?" : "UPDATE AD_Sequence SET CurrentNext = CurrentNext + ? WHERE AD_Sequence_ID = ?";
                            updateSQL = conn.prepareStatement(sql);
                            next = rs.getInt(1);
                        }
                        updateSQL.setInt(1, incrementNo);
                        updateSQL.setInt(2, AD_Sequence_ID);
                        if (isStartNewYear) {
                            updateSQL.setString(3, calendarYear);
                        }
                        updateSQL.executeUpdate();
                    }
                    catch (Throwable throwable) {
                        DB.close(updateSQL);
                        throw throwable;
                    }
                    DB.close(updateSQL);
                } else {
                    s_log.warning("(Table) - no record found - " + AD_Sequence_ID);
                    MSequence seq = new MSequence(Env.getCtx(), AD_Sequence_ID, trxName);
                    next = seq.getNextID();
                    seq.save();
                }
                if (trx == null) {
                    conn.commit();
                }
            }
            catch (Exception e) {
                s_log.log(Level.SEVERE, "(Table) [" + trxName + "]", e);
                if (DBException.isTimeout(e)) {
                    throw new AdempiereException("GenerateDocumentNoTimeOut", e);
                }
                throw new AdempiereException("GenerateDocumentNoError", e);
            }
        }
        finally {
            DB.close(rs, pstmt);
            try {
                if (trx == null && conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                s_log.log(Level.SEVERE, "(Table) - finish", e);
            }
        }
        if (next < 0) {
            return null;
        }
        StringBuffer doc = new StringBuffer();
        if (prefix != null && prefix.length() > 0) {
            doc.append(Env.parseVariable(prefix, po, trxName, false));
        }
        if (decimalPattern != null && decimalPattern.length() > 0) {
            doc.append(new DecimalFormat(decimalPattern).format(next));
        } else {
            doc.append(next);
        }
        if (suffix != null && suffix.length() > 0) {
            doc.append(Env.parseVariable(suffix, po, trxName, false));
        }
        String documentNo = doc.toString();
        s_log.finer(String.valueOf(documentNo) + " (" + incrementNo + ")" + " - AD_Sequence_ID=" + AD_Sequence_ID + " [" + trx + "]");
        return documentNo;
    }
}

