/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.util;

import com.f3p.commons.FileStreamUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.logging.Level;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CacheMgt;

public class QueryRepo {
    public static final String CACHE_NAME = "com.f3p.adempiere.query.cache";
    public static final int CACHE_INITIAL_SIZE = 10;
    private static CLogger s_logger = CLogger.getCLogger(QueryRepo.class);
    private static CCache<String, String> s_cacheQuery = new CCache("com.f3p.adempiere.query.cache", 10);

    static {
        CacheMgt cacheMgt = CacheMgt.get();
        cacheMgt.register(s_cacheQuery);
    }

    public static String getQuery(String sQueryName, ClassLoader cl) {
        String sQuery = null;
        if (s_cacheQuery.containsKey(sQueryName)) {
            if (s_logger.isLoggable(Level.FINEST)) {
                s_logger.finest("Query " + sQueryName + " got from cache");
            }
            sQuery = s_cacheQuery.get(sQueryName);
        } else {
            if (s_logger.isLoggable(Level.FINEST)) {
                s_logger.finest("Loading query " + sQueryName + " from classpath");
            }
            try {
                StringBuilder sb = new StringBuilder("");
                sb.append(sQueryName);
                sb.append(".sql");
                InputStream is = cl.getResourceAsStream(sb.toString());
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                StringWriter wri = new StringWriter();
                FileStreamUtils.transferStream(br, wri);
                String sContent = wri.toString();
                s_cacheQuery.put(sQueryName, sContent);
                sQuery = sContent;
            }
            catch (Exception e) {
                s_logger.log(Level.SEVERE, "QueryRepo.getQuery", e);
                sQuery = null;
            }
        }
        return sQuery;
    }

    public static String getQuery(String sQueryName) {
        return QueryRepo.getQuery(sQueryName, QueryRepo.class.getClassLoader());
    }
}

