/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.util;

import java.awt.Container;
import java.awt.Frame;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.compiere.apps.ADialog;
import org.compiere.apps.ProcessCtl;
import org.compiere.apps.ProcessParameter;
import org.compiere.model.GridTab;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.process.ProcessInfo;
import org.compiere.util.ASyncProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class ProcessHelper {
    public static final String PARAM_WindowNo = "F3P_Param_WindowNo";
    public static final String PARAM_TabNo = "F3P_Param_TabNo";

    public static ProcessCtl startProcess(ASyncProcess parent, int WindowNo, int TabNo, ProcessInfo pi, Trx trx) {
        Hashtable<String, Object> params = new Hashtable<String, Object>(2, 1.0f);
        if (WindowNo > 0) {
            params.put(PARAM_WindowNo, WindowNo);
        }
        if (TabNo >= 0) {
            params.put(PARAM_TabNo, TabNo);
        }
        ProcessCtl ctl = null;
        try {
            ctl = ProcessHelper.startProcess(parent, pi, trx, WindowNo, params);
        }
        catch (IllegalAccessError e) {
            ADialog.error(WindowNo, Env.getWindow(WindowNo), e.getLocalizedMessage());
            ctl = null;
        }
        return ctl;
    }

    public static ProcessCtl startProcess(ASyncProcess parent, ProcessInfo pi, Trx trx, int WindowNo, Map<String, Object> extraParams, boolean bForceParentNull) {
        MPInstance instance = new MPInstance(Env.getCtx(), pi.getAD_Process_ID(), pi.getRecord_ID());
        if (!instance.save()) {
            pi.setSummary(Msg.getMsg(Env.getCtx(), "ProcessNoInstance"));
            pi.setError(true);
            return null;
        }
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        int iSeqNo = 1000;
        for (String key : extraParams.keySet()) {
            Object val = extraParams.get(key);
            MPInstancePara param = new MPInstancePara(Env.getCtx(), pi.getAD_PInstance_ID(), iSeqNo++);
            param.setParameterName(key);
            if (val instanceof Integer) {
                param.setP_Number((Integer)val);
            } else if (val instanceof Timestamp) {
                param.setP_Date((Timestamp)val);
            } else if (val instanceof BigDecimal) {
                param.setP_Number((BigDecimal)val);
            } else if (val instanceof String) {
                param.setP_String(val.toString());
            }
            if (param.save()) continue;
            pi.setSummary(Msg.getMsg(Env.getCtx(), "ProcessNoWinNo"));
            pi.setError(true);
            return null;
        }
        ProcessParameter para = new ProcessParameter((Frame)Env.getFrame((Container)((Object)parent)), WindowNo, pi);
        if (para.initDialog()) {
            para.setVisible(true);
            if (!para.isOK()) {
                pi.setSummary(Msg.getMsg(Env.getCtx(), "ProcessCancelled"));
                pi.setError(true);
                return null;
            }
        }
        ProcessCtl worker = null;
        if (bForceParentNull) {
            worker = new ProcessCtl(null, WindowNo, pi, trx);
            worker.run();
        } else {
            worker = new ProcessCtl(parent, WindowNo, pi, trx);
            worker.start();
        }
        return worker;
    }

    public static ProcessCtl startProcess(ASyncProcess parent, ProcessInfo pi, Trx trx, int WindowNo, Map<String, Object> extraParams) {
        return ProcessHelper.startProcess(parent, pi, trx, WindowNo, extraParams, false);
    }

    public static void startProcess(ASyncProcess panel, GridTab tab, int AD_Report_ID) {
        ProcessInfo pi = new ProcessInfo(tab.getTableName(), AD_Report_ID, tab.getAD_Table_ID(), tab.getRecord_ID());
        pi.setAD_User_ID(Env.getAD_User_ID(Env.getCtx()));
        pi.setAD_Client_ID(Env.getAD_Client_ID(Env.getCtx()));
        ProcessHelper.startProcess(panel, tab.getWindowNo(), tab.getTabNo(), pi, null);
    }

    public static boolean isProcessInstanceRunning(ProcessInfo pInfo, Properties pCtx, String sTrx, boolean bThisIstanceRunning) {
        String sOut = DB.getSQLValueString(sTrx, "SELECT 'KO' FROM AD_PInstance where AD_Process_ID = ? AND AD_Org_ID = ? and IsProcessing = 'Y'", pInfo.getAD_Process_ID(), Env.getAD_Org_ID(pCtx));
        if (bThisIstanceRunning) {
            return sOut == null;
        }
        return sOut != null;
    }
}

