/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MPeriod;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class PeriodHelper {
    private static final CLogger s_log = CLogger.getCLogger(PeriodHelper.class);

    public static List<MPeriod> getPeriodsInDates(Properties ctx, Timestamp tsStart, Timestamp tsEnd, String sTrx) {
        int AD_Org_ID = Env.getAD_Org_ID(ctx);
        return PeriodHelper.getPeriodsInDates(ctx, tsStart, tsEnd, AD_Org_ID, sTrx);
    }

    public static List<MPeriod> getPeriodsInDates(Properties ctx, Timestamp tsStart, Timestamp tsEnd, int AD_Org_ID, String sTrx) {
        int C_Calendar_ID = MPeriod.getC_Calendar_ID(ctx, AD_Org_ID);
        Query qPeriod = new Query(ctx, "C_Period", "C_Year_ID IN (SELECT C_Year_ID FROM C_Year WHERE C_Calendar_ID= ?) AND ? <= EndDate AND ? >= StartDate AND PeriodType='S'", sTrx);
        qPeriod.setApplyAccessFilter(true).setOnlyActiveRecords(true);
        qPeriod.setParameters(C_Calendar_ID, TimeUtil.getDay(tsStart), TimeUtil.getDay(tsEnd));
        return qPeriod.list();
    }

    public static int setPeriodStatus(Properties ctx, int C_Period_ID, String sPeriodAction, String sTrx) {
        MPeriod mPeriod = MPeriod.get(ctx, C_Period_ID);
        StringBuffer sql = new StringBuffer("UPDATE C_PeriodControl ");
        sql.append("SET PeriodStatus='");
        if ("O".equals(sPeriodAction)) {
            sql.append("O");
        } else if ("C".equals(sPeriodAction)) {
            sql.append("C");
        } else if ("P".equals(sPeriodAction)) {
            sql.append("P");
        } else {
            return -1;
        }
        sql.append("', PeriodAction='N', Updated=SysDate,UpdatedBy=").append(Env.getAD_User_ID(ctx));
        sql.append(" WHERE C_Period_ID=").append(mPeriod.getC_Period_ID()).append(" AND PeriodStatus<>'P'").append(" AND PeriodStatus<>'").append(sPeriodAction).append("'");
        int no = DB.executeUpdate(sql.toString(), sTrx);
        CacheMgt.get().reset("C_PeriodControl", 0);
        CacheMgt.get().reset("C_Period", C_Period_ID);
        return no;
    }

    public static MPeriod getLastInYear(Properties ctx, Timestamp DateAcct, int AD_Org_ID) {
        MPeriod retValue;
        block6: {
            retValue = null;
            int C_Calendar_ID = MPeriod.get(ctx, DateAcct, AD_Org_ID).getC_Calendar_ID();
            String sql = "SELECT * FROM C_Period WHERE C_Year_ID IN (SELECT p.C_Year_ID FROM C_Year y INNER JOIN C_Period p ON (y.C_Year_ID=p.C_Year_ID) WHERE y.C_Calendar_ID=?     AND ? BETWEEN StartDate AND EndDate) AND IsActive=? AND PeriodType=? ORDER BY StartDate DESC";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, C_Calendar_ID);
                    pstmt.setTimestamp(2, DateAcct);
                    pstmt.setString(3, "Y");
                    pstmt.setString(4, "S");
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = new MPeriod(ctx, rs, null);
                    }
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }
}

