/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.util;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import org.compiere.model.MPaySchedule;
import org.compiere.model.MPaymentTerm;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class PaymentScheduleHelper {
    public static final BigDecimal HUNDRED = new BigDecimal(100);
    private static CLogger log = CLogger.getCLogger(PaymentScheduleHelper.class);

    public static Instalment[] calculatePaymentSchedule(int C_PaymentTerm_ID, BigDecimal bdTotalAmount, Timestamp tsDateDoc, String sTrx) {
        if (bdTotalAmount.compareTo(BigDecimal.ZERO) == 0 || C_PaymentTerm_ID == 0) {
            return null;
        }
        MPaymentTerm pt = new MPaymentTerm(Env.getCtx(), C_PaymentTerm_ID, sTrx);
        MPaySchedule[] paySchedule = pt.getSchedule(true);
        Instalment[] docSched = new Instalment[paySchedule.length];
        try {
            int i = 0;
            while (i < paySchedule.length) {
                docSched[i] = new Instalment(paySchedule[i], tsDateDoc, bdTotalAmount, sTrx);
                ++i;
            }
        }
        catch (SQLException e) {
            docSched = null;
            log.log(Level.SEVERE, e.toString());
        }
        return docSched;
    }

    public static class Instalment {
        protected Timestamp m_tsDueDate;
        protected BigDecimal m_bdTotal;

        public Instalment(Timestamp tsDueDate, BigDecimal bdTotal) {
            this.m_tsDueDate = tsDueDate;
            this.m_bdTotal = bdTotal;
        }

        protected Instalment(MPaySchedule paySchedule, Timestamp tsDateDoc, BigDecimal bdTotalAmount, String sTrx) throws SQLException {
            boolean bLastDayMonth = false;
            boolean bDueFixed = false;
            int FixMonthOffset = -1;
            int iFixMonthDay = -1;
            int scale = 2;
            BigDecimal due = bdTotalAmount;
            this.m_bdTotal = due = due.multiply(paySchedule.getPercentage()).divide(HUNDRED, scale, 4);
            String sSQL = "SELECT C_PAYMENTTERM.F3P_ISLASTMONTHDAY, C_PAYSCHEDULE.FIXMONTHOFFSET,C_PAYMENTTERM.IsDueFixed,C_PAYMENTTERM.fixMonthDay FROM C_PAYSCHEDULE,C_PAYMENTTERM WHERE C_PAYSCHEDULE.C_PAYMENTTERM_ID=C_PAYMENTTERM.C_PAYMENTTERM_ID AND C_PAYSCHEDULE.C_PAYSCHEDULE_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement(sSQL, sTrx);
                pstmt.setInt(1, paySchedule.get_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    bLastDayMonth = "Y".equals(rs.getObject("F3P_ISLASTMONTHDAY"));
                    FixMonthOffset = rs.getInt("FixMonthOffset");
                    bDueFixed = "Y".equals(rs.getObject("IsDueFixed"));
                    iFixMonthDay = rs.getInt("fixMonthDay");
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
            if (bLastDayMonth) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(tsDateDoc);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.set(5, 1);
                cal.add(2, FixMonthOffset);
                int maxDayCut = cal.getActualMaximum(5);
                cal.set(5, maxDayCut);
                Date date = cal.getTime();
                this.m_tsDueDate = new Timestamp(date.getTime());
            } else if (bDueFixed) {
                MPaymentTerm payTerm = paySchedule.getParent();
                String sql = "SELECT paymenttermduedate(?, ?) FROM C_PAYMENTTERM WHERE C_PAYMENTTERM_ID = ?";
                Timestamp startDate = DB.getSQLValueTS(sTrx, sql, payTerm.getC_PaymentTerm_ID(), tsDateDoc, payTerm.getC_PaymentTerm_ID());
                Calendar calDate = GregorianCalendar.getInstance();
                calDate.setTime(startDate);
                calDate.add(2, FixMonthOffset);
                if (iFixMonthDay > calDate.get(5)) {
                    iFixMonthDay = Math.min(iFixMonthDay, calDate.getActualMaximum(5));
                    calDate.set(5, iFixMonthDay);
                }
                this.m_tsDueDate = new Timestamp(calDate.getTimeInMillis());
            } else {
                Timestamp dueDate;
                this.m_tsDueDate = dueDate = TimeUtil.addDays(tsDateDoc, paySchedule.getNetDays());
            }
        }

        public Timestamp getDueDate() {
            return this.m_tsDueDate;
        }

        public void setDueDate(Timestamp tsDueDate) {
            this.m_tsDueDate = tsDueDate;
        }

        public BigDecimal getTotal() {
            return this.m_bdTotal;
        }

        public void setTotal(BigDecimal bdTotal) {
            this.m_bdTotal = bdTotal;
        }
    }
}

