/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.compiere.model.MQuery;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class ParentTableHelper {
    public static String getSQLForParentClause(int AD_Window_ID, MQuery query) throws SQLException {
        TabParent elem;
        ArrayList<TabParent> lstParent = new ArrayList<TabParent>();
        int nLevel = -1;
        int nCurrentLevel = -1;
        String sTable = null;
        String sColumn = null;
        String sFirstParent = null;
        boolean bFirstElmFound = false;
        String sSQL = "SELECT AD_TAB.tablevel, AD_TAB.seqno, AD_TABLE.tablename, AD_COLUMN.COLUMNNAME FROM AD_TAB, AD_TABLE, AD_COLUMN WHERE AD_TAB.AD_WINDOW_ID = ? AND AD_TAB.AD_TABLE_ID=AD_TABLE.AD_TABLE_ID AND AD_TAB.isactive='Y' AND AD_COLUMN.isactive='Y' AND AD_COLUMN.AD_TABLE_ID=AD_TABLE.AD_TABLE_ID AND ((AD_COLUMN.AD_COLUMN_ID= AD_TAB.AD_COLUMN_ID) OR (AD_TAB.AD_COLUMN_ID IS NULL AND AD_COLUMN.ISPARENT='Y')) ORDER BY AD_TAB.SEQNO desc, AD_TAB.TABLEVEL desc";
        String sSQLFirstParent = "SELECT AD_TABLE.tablename FROM AD_TAB,AD_TABLE WHERE AD_TAB.AD_TABLE_ID = AD_TABLE.AD_TABLE_ID AND AD_TAB.tablevel=0 AND AD_TAB.AD_window_ID= ?";
        CPreparedStatement pstmt = DB.prepareStatement(sSQL, null);
        pstmt.setInt(1, AD_Window_ID);
        ResultSet rs = pstmt.executeQuery();
        while (rs.next()) {
            nLevel = rs.getInt(1);
            sTable = rs.getString(3);
            sColumn = rs.getString(4);
            if (sTable.equals(query.getTableName()) && !bFirstElmFound) {
                bFirstElmFound = true;
                nCurrentLevel = nLevel;
                elem = new TabParent(sTable, sColumn);
                lstParent.add(elem);
            }
            if (!bFirstElmFound || nLevel != nCurrentLevel - 1) continue;
            elem = new TabParent(sTable, sColumn);
            lstParent.add(elem);
            --nCurrentLevel;
        }
        rs.close();
        pstmt.close();
        pstmt = DB.prepareStatement(sSQLFirstParent, null);
        pstmt.setInt(1, AD_Window_ID);
        rs = pstmt.executeQuery();
        if (rs.next()) {
            sFirstParent = rs.getString(1);
            elem = new TabParent(sFirstParent, null);
            lstParent.add(elem);
        }
        rs.close();
        pstmt.close();
        if (lstParent.size() > 0) {
            StringBuilder sbFrom = new StringBuilder();
            StringBuilder sbWhere = new StringBuilder();
            String sParentTable = null;
            int nLstIndex = 0;
            while (nLstIndex < lstParent.size() - 1) {
                TabParent elem2 = (TabParent)lstParent.get(nLstIndex);
                sbFrom.append(elem2.getTable()).append(',');
                sParentTable = ((TabParent)lstParent.get(nLstIndex + 1)).getTable();
                sbWhere.append(String.valueOf(elem2.getTable()) + "." + elem2.getColumn() + "=" + sParentTable + "." + elem2.getColumn() + " AND ");
                ++nLstIndex;
            }
            if (sbFrom.length() > 0 && sbWhere.length() > 0) {
                sbFrom.setCharAt(sbFrom.length() - 1, ' ');
                sbWhere.append(query.getWhereClause(true));
                return "EXISTS (SELECT * FROM " + sbFrom.toString() + " WHERE " + sbWhere + ")";
            }
        }
        return null;
    }

    private static class TabParent {
        private String m_sTable = null;
        private String m_sColumn = null;

        private TabParent(String table, String column) {
            this.m_sTable = table;
            this.m_sColumn = column;
        }

        private String getTable() {
            return this.m_sTable;
        }

        private String getColumn() {
            return this.m_sColumn;
        }
    }
}

