/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.util;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class PDFHelper {
    public static void concatPDFFile(List<File> lstFile, OutputStream os, boolean paginate) throws FileNotFoundException {
        LinkedList<InputStream> lstStream = new LinkedList<InputStream>();
        for (File file : lstFile) {
            lstStream.add(new FileInputStream(file));
        }
        PDFHelper.concatPDFStream(lstStream, os, paginate);
    }

    public static void concatPDFStream(List<InputStream> pdfs, OutputStream os, boolean paginate) {
        Document document = new Document();
        try {
            try {
                ArrayList<PdfReader> readers = new ArrayList<PdfReader>();
                int totalPages = 0;
                for (InputStream is : pdfs) {
                    PdfReader pdfReader = new PdfReader(is);
                    readers.add(pdfReader);
                    totalPages += pdfReader.getNumberOfPages();
                }
                PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)os);
                document.open();
                BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
                PdfContentByte cb = writer.getDirectContent();
                int currentPageNumber = 0;
                int pageOfCurrentReaderPDF = 0;
                for (PdfReader reader : readers) {
                    while (pageOfCurrentReaderPDF < reader.getNumberOfPages()) {
                        document.newPage();
                        ++currentPageNumber;
                        PdfImportedPage page = writer.getImportedPage(reader, ++pageOfCurrentReaderPDF);
                        cb.addTemplate((PdfTemplate)page, 0.0f, 0.0f);
                        if (!paginate) continue;
                        cb.beginText();
                        cb.setFontAndSize(bf, 9.0f);
                        cb.showTextAligned(1, currentPageNumber + " of " + totalPages, 520.0f, 5.0f, 0.0f);
                        cb.endText();
                    }
                    pageOfCurrentReaderPDF = 0;
                }
                os.flush();
                document.close();
                os.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (document.isOpen()) {
                    document.close();
                }
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        finally {
            if (document.isOpen()) {
                document.close();
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

