/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JComponent;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VEditorFactory;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.GridField;
import org.compiere.model.GridFieldVO;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.swing.CLabel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;

public class FieldHelper {
    private static CLogger s_log = CLogger.getCLogger(FieldHelper.class);

    public static VLookup getTableLookup(int WindowNo, int AD_Column_ID, String sColumnName, int AD_Reference_Value_ID) {
        try {
            MLookup lookup = MLookupFactory.get(Env.getCtx(), WindowNo, AD_Column_ID, 18, Env.getLanguage(Env.getCtx()), sColumnName, AD_Reference_Value_ID, false, "");
            return new VLookup(sColumnName, false, false, true, lookup);
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "AHelper.getTableLookup", e);
            return null;
        }
    }

    public static VLookup getTableLookup(int WindowNo, int AD_Column_ID, String sColumnName) {
        try {
            MLookup lookup = MLookupFactory.get(Env.getCtx(), WindowNo, 0, AD_Column_ID, 18);
            return new VLookup(sColumnName, false, false, true, lookup);
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "AHelper.getTableLookup", e);
            return null;
        }
    }

    public static GridField getField(int WindowNo, int AD_Column_ID) {
        return FieldHelper.getField(WindowNo, AD_Column_ID, false);
    }

    public static GridField getField(int WindowNo, int AD_Column_ID, boolean bForceDisplay) {
        return FieldHelper.getField(Env.getCtx(), WindowNo, AD_Column_ID, bForceDisplay);
    }

    public static GridField getField(Properties ctx, int WindowNo, int AD_Column_ID, boolean bForceDisplay) {
        GridField field = null;
        String sIsDisplay = "";
        if (bForceDisplay) {
            sIsDisplay = ",'Y' as IsDisplayed ";
        }
        try {
            GridFieldVO gfoEE;
            CPreparedStatement pstmt = DB.prepareStatement("SELECT AD_FIELD_V.*, 'Y' as IsAlwaysUpdateable" + sIsDisplay + " FROM AD_FIELD_V WHERE AD_Column_ID = ?", null);
            pstmt.setInt(1, AD_Column_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next() && DisplayType.isLookup((field = new GridField(gfoEE = GridFieldVO.create(ctx, WindowNo, 0, 0, 0, false, rs))).getDisplayType())) {
                field.loadLookup();
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, "AHelper.getEditor", e);
        }
        return field;
    }

    public static Editor getEditor(int WindowNo, int AD_Column_ID) {
        GridField field = FieldHelper.getField(WindowNo, AD_Column_ID, true);
        VEditor ved = null;
        CLabel label = null;
        if (field != null) {
            ved = VEditorFactory.getEditor(field, true);
            label = new CLabel(Msg.translate(Env.getCtx(), field.getColumnName()), field.getDescription());
            label.setName(field.getColumnName());
            return new Editor(ved, label);
        }
        return null;
    }

    public static List<NamePair> getLookupValuesAsList(Properties ctx, int WindowNo, int AD_Column_ID) {
        GridField field = FieldHelper.getField(ctx, WindowNo, AD_Column_ID, true);
        Lookup lookup = field.getLookup();
        ArrayList<Object> lstRaw = lookup.getData(true, true, true, false);
        ArrayList<NamePair> lstValues = new ArrayList<NamePair>();
        for (Object e : lstRaw) {
            if (!(e instanceof NamePair)) continue;
            lstValues.add((NamePair)e);
        }
        return lstValues;
    }

    public static NamePair[] getLookupValues(Properties ctx, int WindowNo, int AD_Column_ID) {
        List<NamePair> lstValues = FieldHelper.getLookupValuesAsList(ctx, WindowNo, AD_Column_ID);
        return lstValues.toArray(new NamePair[lstValues.size()]);
    }

    public static MLookup getLookup(VEditor editor) {
        VLookup vlookup;
        Lookup lookup;
        MLookup res = null;
        if (editor instanceof VLookup && (lookup = (vlookup = (VLookup)editor).getLookup()) instanceof MLookup) {
            res = (MLookup)lookup;
        }
        return res;
    }

    public static void fireVetoableChange(VEditor editor) {
        VetoableChangeListener[] listeners = ((JComponent)((Object)editor)).getVetoableChangeListeners();
        PropertyChangeEvent evt = new PropertyChangeEvent(editor, editor.getName(), null, editor.getValue());
        VetoableChangeListener[] vetoableChangeListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            VetoableChangeListener listener = vetoableChangeListenerArray[n2];
            try {
                listener.vetoableChange(evt);
            }
            catch (PropertyVetoException e) {
                s_log.log(Level.SEVERE, "AHelper.fireVetoableChange", e);
            }
            ++n2;
        }
    }

    public static class Editor {
        private VEditor m_editor;
        private CLabel m_label;

        private Editor(VEditor editor, CLabel label) {
            this.m_editor = editor;
            this.m_label = label;
        }

        public VEditor getEditor() {
            return this.m_editor;
        }

        public JComponent getEditorComponent() {
            return (JComponent)((Object)this.m_editor);
        }

        public CLabel getLabel() {
            return this.m_label;
        }

        public int getValueAsInt() {
            Number n = (Number)this.m_editor.getValue();
            if (n == null) {
                return -1;
            }
            return n.intValue();
        }

        public Timestamp getValueAsTimestamp() {
            return (Timestamp)this.m_editor.getValue();
        }
    }

    public static class NamePairComparator
    implements Comparator<NamePair> {
        @Override
        public int compare(NamePair o1, NamePair o2) {
            return o1.getID().compareTo(o2.getID());
        }
    }
}

