/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.util;

import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.StringTokenizer;
import org.compiere.apps.AWindow;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class EnvHelper {
    protected static CLogger s_log = CLogger.getCLogger(EnvHelper.class);

    public static String parseStringWithEnv(Properties ctx, String sString, int WindowNo, int TabNo) {
        StringBuffer sParsed = new StringBuffer();
        StringTokenizer sTokenizer = new StringTokenizer(sString, "@");
        while (sTokenizer.hasMoreTokens()) {
            sParsed.append(sTokenizer.nextToken());
            if (!sTokenizer.hasMoreTokens()) continue;
            String sVar = sTokenizer.nextToken();
            String sVal = Env.getContext(ctx, WindowNo, TabNo, sVar);
            if (sVal.length() == 0) {
                sParsed.append("NULL");
                continue;
            }
            sParsed.append(sVal);
        }
        return sParsed.toString();
    }

    public static void pushEnv(String sQuery, int WindowNo, int TabNo, Properties ctx) throws SQLException {
        String sSQL = EnvHelper.parseStringWithEnv(ctx, sQuery, WindowNo, TabNo);
        CPreparedStatement pstmt = DB.prepareStatement(sSQL, null);
        ResultSet rs = null;
        try {
            rs = pstmt.executeQuery();
            EnvHelper.pushEnv(rs, WindowNo, TabNo, ctx);
        }
        finally {
            DB.close(rs, pstmt);
        }
    }

    public static void pushEnv(ResultSet rs, int WindowNo, int TabNo, Properties ctx) throws SQLException {
        EnvHelper.pushEnv(rs, WindowNo, TabNo, ctx, null);
    }

    public static void pushEnv(ResultSet rs, int WindowNo, int TabNo, Properties ctx, POInfo poInfo) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        if (rs.next()) {
            int i = 0;
            while (i < meta.getColumnCount()) {
                String sName = meta.getColumnName(i + 1);
                String sVal = rs.getString(i + 1);
                if (poInfo != null) {
                    int iCols = poInfo.getColumnCount();
                    int c = 0;
                    while (c < iCols) {
                        String sColName = poInfo.getColumnName(c);
                        if (sColName.equalsIgnoreCase(sName)) {
                            sName = poInfo.getColumnName(c);
                        }
                        ++c;
                    }
                }
                if (sName.startsWith("G#")) {
                    Env.setContext(ctx, sName.substring(1), sVal);
                } else {
                    Env.setContext(ctx, WindowNo, sName, sVal);
                }
                ++i;
            }
        }
    }

    public static void fillFieldsFromResults(ResultSet rs, GridTab gTab, Properties ctx) throws SQLException {
        if (rs.next()) {
            ResultSetMetaData rsMeta = rs.getMetaData();
            int iCount = rsMeta.getColumnCount();
            int i = 0;
            while (i < iCount) {
                Object oColValue;
                String sColName = rsMeta.getColumnName(i + 1);
                if (sColName.startsWith("C#")) {
                    oColValue = rs.getObject(i + 1);
                    Env.setContext(ctx, gTab.getWindowNo(), sColName.substring(2), oColValue.toString());
                }
                if (sColName.startsWith("G#")) {
                    oColValue = rs.getObject(i + 1);
                    Env.setContext(ctx, sColName.substring(2), oColValue.toString());
                } else {
                    oColValue = null;
                    Object oOriginalColValue = gTab.getValue(sColName);
                    GridField field = gTab.getField(sColName);
                    if (field != null) {
                        String sVal;
                        int dtype = field.getVO().displayType;
                        oColValue = DisplayType.isNumeric(dtype) ? rs.getBigDecimal(i + 1) : (DisplayType.isDate(dtype) ? rs.getTimestamp(i + 1) : (20 == dtype ? ((sVal = rs.getString(i + 1)) != null && sVal.equals("Y") ? new Boolean(true) : new Boolean(false)) : (sColName.endsWith("_ID") ? new Integer(rs.getInt(i + 1)) : rs.getObject(i + 1))));
                        boolean bSet = true;
                        if (oOriginalColValue == null) {
                            if (oColValue == null) {
                                bSet = false;
                            }
                        } else if (oOriginalColValue.equals(oColValue)) {
                            bSet = false;
                        }
                        if (bSet) {
                            gTab.setValue(sColName, oColValue);
                        }
                    } else {
                        s_log.fine("Field " + sColName + " not found on tab");
                    }
                }
                ++i;
            }
        }
    }

    public static void executeAndFill(String sQuery, GridTab gTab, Properties ctx) throws Exception {
        String sSQL = EnvHelper.parseStringWithEnv(ctx, sQuery, gTab.getWindowNo(), gTab.getTabNo());
        CPreparedStatement pstmt = DB.prepareStatement(sSQL, null);
        ResultSet rs = null;
        try {
            try {
                rs = pstmt.executeQuery();
                EnvHelper.fillFieldsFromResults(rs, gTab, ctx);
            }
            catch (Exception e) {
                throw new Exception("EnvHelper.executeAndFill", e);
            }
        }
        finally {
            DB.close(rs, pstmt);
        }
    }

    public static String getMsg(String sMsg) {
        return Msg.translate(Env.getCtx(), sMsg);
    }

    public static String getMsg(String sMsg, Object[] params) {
        return Msg.getMsg(Env.getCtx(), sMsg, params);
    }

    @Deprecated
    public static AWindow getFocusAWindow(Properties ctx) {
        return EnvHelper.getFocusAWindow();
    }

    public static AWindow getFocusAWindow() {
        AWindow AWin = null;
        Window win = EnvHelper.getFocusWindow();
        if (win instanceof AWindow) {
            AWin = (AWindow)win;
        }
        return AWin;
    }

    public static int getFocusWindowNo() {
        AWindow aw = EnvHelper.getFocusAWindow();
        if (aw != null) {
            return aw.getWindowNo();
        }
        return 0;
    }

    public static Window getFocusWindow() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
    }

    public static void fillEnvWithPOValues(PO po, Properties env, int iWindowNo) {
        EnvHelper.fillEnvWithPOValues(po, env, iWindowNo, -1);
    }

    public static void fillEnvWithPOValues(PO po, Properties env, int iWindowNo, int iTabNo) {
        int i = 0;
        while (i < po.get_ColumnCount()) {
            String sName = po.get_ColumnName(i);
            Object oVal = po.get_Value(i);
            String sVal = null;
            if (oVal != null) {
                sVal = oVal.toString();
            }
            if (iTabNo >= 0) {
                Env.setContext(env, iWindowNo, iTabNo, sName, sVal);
            } else if (oVal instanceof Timestamp) {
                Env.setContext(env, iWindowNo, sName, (Timestamp)oVal);
            } else if (oVal instanceof Integer) {
                Env.setContext(env, iWindowNo, sName, (Integer)oVal);
            } else if (oVal instanceof Boolean) {
                Env.setContext(env, iWindowNo, sName, (Boolean)oVal);
            } else {
                Env.setContext(env, iWindowNo, sName, sVal);
            }
            ++i;
        }
    }
}

