/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.util;

import com.f3p.adempiere.util.IRegisterableAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.MultiHashMap;

public class ActionRegistry {
    public static final String EVENTTYPE_ReopenInvoice_Line = "ReopenInvoiceLine";
    public static final String EVENTTYPE_ReopenInvoice = "ReopenInvoice";
    public static final String EVENTTYPE_ReopenInOut = "ReopenInOut";
    public static final String EVENTTYPE_ReopenInOutLine = "ReopenInOutLine";
    public static final String EVENTTYPE_LITIsDocPostable = "LITIsDocPostable";
    private static MultiHashMap s_lstRegistry = new MultiHashMap();

    private ActionRegistry() {
    }

    public static void register(String sEventType, IRegisterableAction action) {
        s_lstRegistry.put((Object)sEventType, (Object)action);
    }

    public static List<IRegisterableAction> getActions(String sEventType) {
        Collection cActions = s_lstRegistry.getCollection((Object)sEventType);
        if (cActions != null) {
            return new LinkedList<IRegisterableAction>(cActions);
        }
        return new LinkedList<IRegisterableAction>();
    }

    public static String runPreActions(String sEventType, HashMap<String, Object> params, boolean bFastFail) {
        return ActionRegistry.runActions(sEventType, params, true, false, false, bFastFail);
    }

    public static String runExecuteActions(String sEventType, HashMap<String, Object> params, boolean bFastFail) {
        return ActionRegistry.runActions(sEventType, params, false, true, false, bFastFail);
    }

    public static String runPostActions(String sEventType, HashMap<String, Object> params, boolean bFastFail) {
        return ActionRegistry.runActions(sEventType, params, false, false, true, bFastFail);
    }

    public static String runActions(String sEventType, HashMap<String, Object> params, boolean bRunBefore, boolean bRunExecute, boolean bRunPost, boolean bFastFail) {
        List<IRegisterableAction> actions = ActionRegistry.getActions(sEventType);
        if (actions == null) {
            return null;
        }
        StringBuilder sbActionError = new StringBuilder();
        for (IRegisterableAction action : actions) {
            String sError = null;
            if (bRunBefore) {
                sError = action.doBefore(params);
            }
            if (sError == null && bRunExecute) {
                sError = action.execute(params);
            }
            if (sError == null && bRunPost) {
                sError = action.doPost(params);
            }
            if (sError == null) continue;
            if (bFastFail) {
                sbActionError.append(sError);
                break;
            }
            if (sbActionError.length() == 0) {
                sbActionError.append(sError);
                continue;
            }
            sbActionError.append(" - ").append(sError);
        }
        if (sbActionError.length() == 0) {
            return null;
        }
        return sbActionError.toString();
    }
}

