/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.umserials.search;

import com.f3p.adempiere.search.TableIdentifierParser;
import com.f3p.adempiere.umserials.model.MMStorageLabel;
import com.f3p.adempiere.util.IDResolver;
import com.f3p.adempiere.util.SearchCreator;
import com.f3p.adempiere.util.SearchCreatorRegistry;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.compiere.apps.search.AbstractInfo;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.Info_Column;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.GridField;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class InfoStorageLabel
extends AbstractInfo {
    private static final int PRODUCT_FILTER_IDX = 1;
    private static final int ISSUED_FILTER_IDX = 2;
    private static final int LOCATOR_FILTER_IDX = 3;
    private static final int ASI_FILTER_IDX = 4;
    protected boolean m_bMultiSelect = false;
    protected int m_iWindowNo = -1;
    protected int m_M_Product_ID = -1;
    protected VCheckBox m_vbSelectAll;
    private static final long serialVersionUID = -6429755412167925253L;
    private static final Info_Column[] STORAGE_LABEL_LAYOUT = new Info_Column[]{new Info_Column(" ", "M_Storage_Label_ID", IDColumn.class, false), new Info_Column(Msg.getMsg(Env.getCtx(), "F3P_UMS_LBL_Label"), "LabelNo", String.class, true), new Info_Column(Msg.getMsg(Env.getCtx(), "F3P_UMS_LBL_LabelQty"), "LabelQty", BigDecimal.class, true), new Info_Column(Msg.translate(Env.getCtx(), "M_Product_ID"), "M_Product", String.class, true), new Info_Column(Msg.translate(Env.getCtx(), "M_Locator_ID"), "M_Locator", String.class, true), new Info_Column(Msg.translate(Env.getCtx(), "M_AttributeSetInstance_ID"), "M_AttributeSetInstance", String.class, true), new Info_Column(Msg.translate(Env.getCtx(), "IsIssued"), "IsIssued", Boolean.class, true)};

    public InfoStorageLabel(Frame frame, boolean bModal, int WindowNo, boolean bMulti, String sWhere, VLookup vLookup) {
        super(frame, bModal, WindowNo, bMulti, sWhere);
        this.setTitle("F3P_UMS_Title_StorageLabelInfo");
        this.m_bMultiSelect = bMulti;
        this.m_iWindowNo = WindowNo;
        this.m_M_Product_ID = Env.getContextAsInt(Env.getCtx(), WindowNo, "M_Product_ID");
        this.initialize();
        if (vLookup != null) {
            this.setInitialFilterValue(vLookup.getDisplay());
        }
    }

    protected void setInitialFilterValue(String sVal) {
        if (TableIdentifierParser.isParsable(sVal)) {
            TableIdentifierParser parser = new TableIdentifierParser("M_Storage_Label");
            parser.parseString(sVal);
            String sLabel = parser.getValue("LabelNo");
            if (sLabel != null) {
                this.setFilterValue(0, sLabel);
            }
        } else {
            this.setFilterValue(0, sVal);
        }
    }

    public void lockProductLocatorASIIssued(int M_Product_ID, int M_Locator_ID, int M_AttributeSetInstance_ID, boolean bIssued) {
        this.getFilterEditor(1).removeVetoableChangeListener(this);
        this.getFilterEditor(3).removeVetoableChangeListener(this);
        this.getFilterEditor(4).removeVetoableChangeListener(this);
        this.getFilterEditor(2).removeVetoableChangeListener(this);
        this.getFilterEditor(1).setValue(M_Product_ID);
        this.getFilterEditor(1).setReadWrite(false);
        this.getFilterEditor(3).setValue(M_Locator_ID);
        this.getFilterEditor(3).setReadWrite(false);
        this.getFilterEditor(4).setValue(M_AttributeSetInstance_ID);
        this.getFilterEditor(4).setReadWrite(false);
        this.getFilterEditor(2).setValue(bIssued);
        this.getFilterEditor(2).setReadWrite(false);
        this.setFilterAsTranscoded(1, false);
    }

    @Override
    public void initialize() {
        this.addFilter(IDResolver.getAD_Column_ID("M_Storage_Label", "LabelNo"));
        this.addFilter(IDResolver.getAD_Column_ID("M_InOutLine", "M_Product_ID"));
        this.addFilter(IDResolver.getAD_Column_ID("M_Storage_Label", "IsIssued"));
        this.setLineBreakOnFilter(2, true);
        this.addFilter(IDResolver.getAD_Column_ID("M_InOutLine", "M_Locator_ID"));
        this.addFilter(IDResolver.getAD_Column_ID("M_InOutLine", "M_AttributeSetInstance_ID"));
        if (this.m_bMultiSelect) {
            this.setLineBreakOnFilter(4, true);
            this.m_vbSelectAll = new VCheckBox();
            this.m_vbSelectAll.addVetoableChangeListener(this);
            this.m_vbSelectAll.setText(Msg.getMsg(Env.getCtx(), "select.all"));
            this.addUIElement(this.m_vbSelectAll, null, false);
        }
        this.getFilterEditor(4).setValue(null);
        this.getFilterLabel(2).setHorizontalAlignment(0);
        this.setShowTotals(false);
        this.getFilterEditor(1).addVetoableChangeListener(this);
        this.setFilterAsTranscoded(1, true);
        this.removePrintButton();
        super.initialize();
    }

    @Override
    public String getOrderBy() {
        return "LabelNo";
    }

    @Override
    public String getQueryName() {
        return "com/f3p/adempiere/umserials/search/info_storage_label";
    }

    @Override
    public Info_Column[] getTableLayout() {
        return STORAGE_LABEL_LAYOUT;
    }

    @Override
    public String getTableName() {
        return "M_Storage_Label";
    }

    @Override
    public boolean isMultiSelectable() {
        return this.m_bMultiSelect;
    }

    @Override
    public Object transcodeParam(VEditor field, Object value) {
        Integer M_Product_ID = (Integer)this.getFilterEditor(1).getValue();
        int M_AttributeSetInstance_ID = 0;
        if (M_Product_ID != null && value != null) {
            M_AttributeSetInstance_ID = MMStorageLabel.getRealAttributeSetInstanceID(Env.getCtx(), M_Product_ID, (Integer)value);
        }
        return M_AttributeSetInstance_ID;
    }

    @Override
    protected ArrayList<Integer> getSelectedRowKeys() {
        ArrayList<Integer> lstDataList = new ArrayList<Integer>();
        int rows = this.p_table.getRowCount();
        int row = 0;
        while (row < rows) {
            if (!this.p_table.getShowTotals() || row != rows - 1) {
                Object data = this.p_table.getModel().getValueAt(row, 0);
                if (data instanceof IDColumn) {
                    Boolean bIssued;
                    IDColumn dataColumn = (IDColumn)data;
                    if (dataColumn.isSelected() && !(bIssued = (Boolean)this.p_table.getModel().getValueAt(row, STORAGE_LABEL_LAYOUT.length - 1)).booleanValue()) {
                        lstDataList.add(dataColumn.getRecord_ID());
                    }
                } else {
                    this.log.severe("For multiple selection, IDColumn should be key column for selection");
                }
            }
            ++row;
        }
        return lstDataList;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (evt.getSource() == this.getFilterEditor(1)) {
            Number nrProd = (Number)evt.getNewValue();
            int M_Product_ID = 0;
            if (nrProd != null) {
                M_Product_ID = nrProd.intValue();
            }
            Env.setContext(Env.getCtx(), this.m_iWindowNo, "M_Product_ID", M_Product_ID);
            super.vetoableChange(evt);
        } else if (evt.getSource() == this.m_vbSelectAll) {
            boolean bCheck = (Boolean)evt.getNewValue();
            int iRows = this.p_table.getRowCount();
            int i = 0;
            while (i < iRows) {
                IDColumn idc = (IDColumn)this.p_table.getValueAt(i, 0);
                if (idc != null) {
                    idc.setSelected(bCheck);
                    this.p_table.setValueAt(idc, i, 0);
                }
                ++i;
            }
        } else {
            super.vetoableChange(evt);
        }
    }

    @Override
    public void dispose(boolean ok) {
        Env.setContext(Env.getCtx(), this.m_iWindowNo, "M_Product_ID", this.m_M_Product_ID);
        super.dispose(ok);
    }

    public static class Creator
    implements SearchCreator {
        public static void register() {
            SearchCreatorRegistry.register(new Creator());
        }

        @Override
        public Info create(String sCol, Frame frame, boolean bModal, int WindowNo, String sWhere, VLookup vLookup) {
            if (sCol.equals("M_Storage_Label_ID")) {
                boolean bMultiSelect = false;
                if (vLookup != null) {
                    GridField gField = vLookup.getField();
                    int AD_Table_ID = MColumn.getTable_ID(Env.getCtx(), gField.getAD_Column_ID(), null);
                    MTable mTable = MTable.get(Env.getCtx(), AD_Table_ID);
                    bMultiSelect = "M_Storage_OutLabel".equals(mTable.getTableName());
                } else {
                    bMultiSelect = false;
                }
                return new InfoStorageLabel(frame, bModal, WindowNo, bMultiSelect, "", vLookup);
            }
            return null;
        }
    }
}

