/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.umserials.model;

import com.f3p.adempiere.model.AbstractBoostrappableValidator;
import com.f3p.adempiere.model.AbstractBootstrapValidator;
import com.f3p.adempiere.umserials.model.MMStorageOutLabel;
import com.f3p.adempiere.umserials.model.X_M_Storage_OutLabel;
import com.f3p.adempiere.util.QueryRepo;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.I_C_OrderLine;
import org.compiere.model.I_M_InOut;
import org.compiere.model.I_M_InOutConfirm;
import org.compiere.model.I_M_InOutLine;
import org.compiere.model.MClient;
import org.compiere.model.MSysConfig;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.X_M_InOutLineConfirm;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class OutLabelValidator
extends AbstractBoostrappableValidator {
    public static final String MSYS_STORAGE_OUTLABEL_DEFAULT_GEN = "STORAGE_OUTLABEL_DEFAULT_GEN";
    private static final CLogger s_log = CLogger.getCLogger(OutLabelValidator.class);
    private AbstractBootstrapValidator m_valBootstrap;

    @Override
    public void setBootstrapValidator(AbstractBootstrapValidator abv) {
        this.m_valBootstrap = abv;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_valBootstrap.getAD_Client_ID();
    }

    @Override
    public void initialize(ModelValidationEngine engine, MClient mClient) {
        engine.addModelChange("M_Storage_OutLabel", this.getValidator());
        engine.addModelChange("M_InOutLineConfirm", this.getValidator());
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    @Override
    public String docValidate(PO arg0, int arg1) {
        return null;
    }

    @Override
    public String modelChange(PO model, int nType) throws Exception {
        if (model instanceof X_M_Storage_OutLabel) {
            MMStorageOutLabel mStorageOutLabel = (MMStorageOutLabel)model;
            return this.processStorageOutLabel(mStorageOutLabel, nType);
        }
        if (model instanceof X_M_InOutLineConfirm) {
            String sRet = null;
            X_M_InOutLineConfirm mInOutLineConfirm = (X_M_InOutLineConfirm)model;
            if (nType == 4) {
                sRet = this.pregenerateStorageOutLabels(mInOutLineConfirm);
            }
            return sRet;
        }
        return null;
    }

    protected String processStorageOutLabel(MMStorageOutLabel mStorageOutLabel, int nType) {
        if (nType == 4) {
            mStorageOutLabel.setLabelIssued(true);
        }
        if (nType == 6) {
            mStorageOutLabel.setLabelIssued(false);
        }
        if (nType == 5) {
            if (mStorageOutLabel.is_ValueChanged("IsActive")) {
                mStorageOutLabel.setLabelIssued(mStorageOutLabel.isActive());
            }
            if (mStorageOutLabel.is_ValueChanged("M_Storage_Label_ID")) {
                int M_StorageLabel_ID = mStorageOutLabel.getM_Storage_Label_ID();
                int oldM_StorageLabel_ID = (Integer)mStorageOutLabel.get_ValueOld("M_Storage_Label_ID");
                mStorageOutLabel.setM_Storage_Label_ID(oldM_StorageLabel_ID);
                mStorageOutLabel.setLabelIssued(false);
                mStorageOutLabel.setM_Storage_Label_ID(M_StorageLabel_ID);
                mStorageOutLabel.setLabelIssued(true);
            }
        }
        return null;
    }

    protected String pregenerateStorageOutLabels(X_M_InOutLineConfirm mInOutLineConfirm) throws Exception {
        Properties ctx = mInOutLineConfirm.getCtx();
        String sRet = null;
        I_M_InOutConfirm mIoConfirm = mInOutLineConfirm.getM_InOutConfirm();
        String sTrx = mInOutLineConfirm.get_TrxName();
        if (s_log.isLoggable(Level.FINER)) {
            s_log.finer("Eval. autocreate of OutLable for InOutLineConfirm " + mInOutLineConfirm.getM_InOutLineConfirm_ID());
        }
        if (!mIoConfirm.getConfirmType().equals("PC")) {
            if (s_log.isLoggable(Level.FINER)) {
                s_log.finer("No autocreation: InOutConfirm is not of type SC");
            }
            return sRet;
        }
        I_M_InOut mInOut = mIoConfirm.getM_InOut();
        if (mInOut == null || !mInOut.isSOTrx()) {
            if (s_log.isLoggable(Level.FINER)) {
                s_log.finer("No autocreation: no inout or is not SOTrx");
            }
            return sRet;
        }
        I_M_InOutLine mInOutLine = mInOutLineConfirm.getM_InOutLine();
        if (mInOutLine == null) {
            if (s_log.isLoggable(Level.FINER)) {
                s_log.finer("No autocreation: no inoutline");
            }
            return sRet;
        }
        I_C_OrderLine mOrderLine = mInOutLine.getC_OrderLine();
        if (mOrderLine == null) {
            if (s_log.isLoggable(Level.FINER)) {
                s_log.finer("No autocreation: no orderline");
            }
            return sRet;
        }
        boolean bDefaultGen = MSysConfig.getBooleanValue(MSYS_STORAGE_OUTLABEL_DEFAULT_GEN, false, Env.getAD_Client_ID(ctx), Env.getAD_Org_ID(ctx));
        CPreparedStatement pstmtGen = null;
        ResultSet rsGen = null;
        try {
            String sSQLOrder;
            if (mOrderLine.getLink_OrderLine_ID() > 0) {
                if (s_log.isLoggable(Level.FINER)) {
                    s_log.finer("Autocreating from link orderline: " + mOrderLine.getLink_OrderLine_ID());
                }
                sSQLOrder = QueryRepo.getQuery("com/f3p/adempiere/umserials/model/pregenerate_outlabel_orderline");
                pstmtGen = DB.prepareStatement(sSQLOrder, sTrx);
                pstmtGen.setInt(1, mOrderLine.getLink_OrderLine_ID());
            } else if (bDefaultGen) {
                if (s_log.isLoggable(Level.FINER)) {
                    s_log.finer("Autocreating from default");
                }
                sSQLOrder = QueryRepo.getQuery("com/f3p/adempiere/umserials/model/pregenerate_outlabel_default");
                pstmtGen = DB.prepareStatement(sSQLOrder, sTrx);
                pstmtGen.setInt(1, mInOutLine.getM_Product_ID());
                pstmtGen.setInt(2, mInOutLine.getM_Locator_ID());
                pstmtGen.setInt(3, mInOutLine.getM_AttributeSetInstance_ID());
            } else if (s_log.isLoggable(Level.FINER)) {
                s_log.finer("No autocreation enabled");
            }
            BigDecimal bdTargetQty = mInOutLineConfirm.getTargetQty();
            BigDecimal bdCurrentQty = BigDecimal.ZERO;
            if (pstmtGen != null) {
                rsGen = pstmtGen.executeQuery();
                while (rsGen.next() && bdCurrentQty.compareTo(bdTargetQty) < 0) {
                    int M_Storage_Label_ID = rsGen.getInt("M_Storage_Label_ID");
                    BigDecimal bdQty = rsGen.getBigDecimal("LabelQty");
                    MMStorageOutLabel mOutLabel = new MMStorageOutLabel(ctx, 0, sTrx);
                    mOutLabel.setM_InOutLineConfirm_ID(mInOutLineConfirm.getM_InOutLineConfirm_ID());
                    mOutLabel.setM_Storage_Label_ID(M_Storage_Label_ID);
                    mOutLabel.saveEx();
                    if (s_log.isLoggable(Level.FINER)) {
                        s_log.finer("Created Storage Out Label for " + M_Storage_Label_ID + " with qty " + bdQty);
                    }
                    bdCurrentQty = bdCurrentQty.add(bdQty);
                }
            }
        }
        catch (Throwable throwable) {
            DB.close(rsGen, pstmtGen);
            throw throwable;
        }
        DB.close(rsGen, pstmtGen);
        if (s_log.isLoggable(Level.FINER)) {
            s_log.finer("Autocreation evaluation ended");
        }
        return null;
    }
}

