/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.umserials.model;

import com.f3p.adempiere.model.AbstractBoostrappableValidator;
import com.f3p.adempiere.umserials.model.I_M_Storage_Label;
import com.f3p.adempiere.umserials.model.X_M_Storage_Label;
import com.f3p.adempiere.umserials.model.X_M_Storage_OutLabel;
import java.math.BigDecimal;
import org.compiere.model.I_M_InOut;
import org.compiere.model.I_M_InOutLine;
import org.compiere.model.I_M_InOutLineConfirm;
import org.compiere.model.MClient;
import org.compiere.model.MInOutLineConfirm;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.SetGetModel;
import org.compiere.model.SetGetUtil;
import org.compiere.model.X_A_Asset;
import org.compiere.model.X_M_InOutLineConfirm;
import org.compiere.util.CLogger;
import org.eevolution.model.I_PP_Cost_Collector;
import org.eevolution.model.X_PP_Cost_Collector;

public class LabelValidator
extends AbstractBoostrappableValidator {
    private static final String ASSET_SERNO_WHERE = "M_InOutLineConfirm_ID = ? AND NOT EXISTS (SELECT 'ok' from M_Storage_Label,A_Asset \t\tWHERE M_Storage_Label.M_Storage_Label_Id = M_Storage_Outlabel.M_Storage_Label_id \t\tAND A_Asset.SerNo = M_Storage_Label.LabelNo)";
    private static final CLogger s_log = CLogger.getCLogger(LabelValidator.class);

    @Override
    public void initialize(ModelValidationEngine engine, MClient mClient) {
        engine.addModelChange("M_Storage_Label", this.getValidator());
        engine.addModelChange("M_Storage_OutLabel", this.getValidator());
        engine.addModelChange("A_Asset", this.getValidator());
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        return null;
    }

    @Override
    public String modelChange(PO model, int nType) throws Exception {
        if (model instanceof X_M_Storage_Label) {
            X_M_Storage_Label mStorageLabel = (X_M_Storage_Label)model;
            return this.processStorageLabel(mStorageLabel, nType);
        }
        if (model instanceof X_A_Asset) {
            X_A_Asset mAsset = (X_A_Asset)model;
            return this.processAsset(mAsset, nType);
        }
        return null;
    }

    protected String processStorageLabel(X_M_Storage_Label mStorageLabel, int nType) {
        if (nType == 1) {
            SetGetModel mdl = SetGetUtil.wrap(mStorageLabel);
            if (mStorageLabel.getM_Product_ID() <= 0 || mStorageLabel.getM_Locator_ID() <= 0 || mStorageLabel.get_Value("M_AttributeSetInstance_ID") == null) {
                LabelValidator.setProductLocatorASI(mdl, false);
            }
            if (mStorageLabel.getDateReceived() == null) {
                if (mStorageLabel.getM_InOutLineConfirm_ID() > 0) {
                    I_M_InOutLineConfirm mIoLineConfirm = mStorageLabel.getM_InOutLineConfirm();
                    I_M_InOutLine mIoLine = mIoLineConfirm.getM_InOutLine();
                    I_M_InOut mInout = mIoLine.getM_InOut();
                    mStorageLabel.setDateReceived(mInout.getMovementDate());
                } else if (mStorageLabel.getPP_Cost_Collector_ID() > 0) {
                    I_PP_Cost_Collector mCostCollector = mStorageLabel.getPP_Cost_Collector();
                    mStorageLabel.setDateReceived(mCostCollector.getMovementDate());
                }
            }
        }
        return null;
    }

    protected String processAsset(X_A_Asset mAsset, int nType) {
        if (nType == 1 && mAsset.getQty().equals(BigDecimal.ONE)) {
            I_M_Storage_Label mStorageLabel;
            Query qStorageOutLabel;
            X_M_Storage_OutLabel mStorageOutLabel;
            int M_InOutLine_ID = mAsset.getM_InOutLine_ID();
            Query qInOutLineConfirm = new Query(mAsset.getCtx(), "M_InOutLineConfirm", "M_InOutLine_ID = ?", mAsset.get_TrxName()).setApplyAccessFilter(true).setParameters(M_InOutLine_ID);
            X_M_InOutLineConfirm mInOutConfirm = (X_M_InOutLineConfirm)qInOutLineConfirm.first();
            if (mInOutConfirm != null && (mStorageOutLabel = (X_M_Storage_OutLabel)(qStorageOutLabel = new Query(mAsset.getCtx(), "M_Storage_OutLabel", ASSET_SERNO_WHERE, mAsset.get_TrxName()).setApplyAccessFilter(true).setParameters(mInOutConfirm.getM_InOutLineConfirm_ID())).first()) != null && (mStorageLabel = mStorageOutLabel.getM_Storage_Label()) != null && mStorageLabel.getLabelQty().equals(BigDecimal.ONE)) {
                mAsset.setSerNo(mStorageLabel.getLabelNo());
            }
        }
        return null;
    }

    public static void setProductLocatorASI(SetGetModel sgm, boolean bOverwrite) {
        int M_InOutLineConfirm_ID = SetGetUtil.get_AttrValueAsInt(sgm, "M_InOutLineConfirm_ID");
        int PP_CostCollector_ID = SetGetUtil.get_AttrValueAsInt(sgm, "PP_Cost_Collector_ID");
        int M_Product_ID = -1;
        int M_Locator_ID = -1;
        int M_AttributeSetInstance_ID = -1;
        if (M_InOutLineConfirm_ID > 0) {
            MInOutLineConfirm mInOutConfirm = new MInOutLineConfirm(sgm.getCtx(), M_InOutLineConfirm_ID, sgm.get_TrxName());
            I_M_InOutLine mInOutLine = mInOutConfirm.getM_InOutLine();
            M_Product_ID = mInOutLine.getM_Product_ID();
            M_Locator_ID = mInOutLine.getM_Locator_ID();
            M_AttributeSetInstance_ID = mInOutLine.getM_AttributeSetInstance_ID();
        } else if (PP_CostCollector_ID > 0) {
            X_PP_Cost_Collector mCostCollector = new X_PP_Cost_Collector(sgm.getCtx(), PP_CostCollector_ID, sgm.get_TrxName());
            M_Product_ID = mCostCollector.getM_Product_ID();
            M_Locator_ID = mCostCollector.getM_Locator_ID();
            M_AttributeSetInstance_ID = mCostCollector.getM_AttributeSetInstance_ID();
        }
        if (bOverwrite || SetGetUtil.get_AttrValueAsInt(sgm, "M_Product_ID") <= 0) {
            sgm.set_AttrValue("M_Product_ID", M_Product_ID);
        }
        if (bOverwrite || SetGetUtil.get_AttrValueAsInt(sgm, "M_Locator_ID") <= 0) {
            sgm.set_AttrValue("M_Locator_ID", M_Locator_ID);
        }
        if (bOverwrite || sgm.get_AttrValue("M_AttributeSetInstance_ID") == null) {
            sgm.set_AttrValue("M_AttributeSetInstance_ID", M_AttributeSetInstance_ID);
        }
    }
}

