/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.umserials.form;

import com.f3p.adempiere.umserials.form.AbstractLabelForm;
import com.f3p.adempiere.umserials.model.MMStorageLabel;
import com.f3p.adempiere.umserials.model.MMStorageOutLabel;
import com.f3p.adempiere.umserials.search.InfoStorageLabel;
import com.f3p.hal.barcode.BarcodeEvent;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.compiere.apps.ADialog;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.swing.CButton;
import org.compiere.swing.CPanel;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class SelectLabelForm
extends AbstractLabelForm
implements TableModelListener {
    private static final long serialVersionUID = 2123657528850174605L;
    protected CButton m_cbSelect;

    @Override
    protected CPanel createHdrPanel() {
        return this.m_panelBarcode;
    }

    @Override
    protected CPanel createBarcodePanel() {
        CPanel cPanel = super.createBarcodePanel();
        this.m_cbSelect = new CButton(Msg.getMsg(this.m_ctx, "select"));
        this.m_cbSelect.addActionListener(this);
        cPanel.add(this.m_cbSelect);
        return cPanel;
    }

    @Override
    protected MiniTable initTable() {
        MiniTable mt = super.initTable();
        mt.getModel().addTableModelListener(this);
        return mt;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String sCommand = e.getActionCommand();
        if (sCommand.equals("Ok")) {
            if (this.askQtyConfirmation()) {
                try {
                    this.createStorageOutLabels();
                    this.dispose();
                }
                catch (Exception ex) {
                    ADialog.error(this.m_iWindowNo, this.m_frame.getParent(), ex.getLocalizedMessage());
                }
            }
        } else if (e.getSource() == this.m_cbSelect) {
            InfoStorageLabel infoSL = new InfoStorageLabel(this.m_frame, true, this.m_iWindowNo, true, null, null);
            infoSL.lockProductLocatorASIIssued(this.m_M_Product_ID, this.m_M_Locator_ID, this.m_M_AttributeSetInstance_ID_Real, false);
            infoSL.setVisible(true);
            if (!infoSL.isCancelled()) {
                Object[] objectArray = infoSL.getSelectedKeys();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    int M_Storage_Label_ID = ((Number)o).intValue();
                    MMStorageLabel msl = new MMStorageLabel(this.m_ctx, M_Storage_Label_ID, null);
                    if (!msl.is_new() && !this.addLabelToTable(msl, true)) {
                        this.warnUser();
                    }
                    ++n2;
                }
            }
        } else if (sCommand.equals("Cancel")) {
            this.dispose();
        }
    }

    @Override
    public void valueRead(BarcodeEvent evt) {
        String sLabel = evt.getValue();
        this.addExistingLabelToTable(sLabel);
    }

    protected void createStorageOutLabels() throws SQLException {
        int iRows = this.m_tableLabels.getRowCount();
        String sTrx = Trx.createTrxName();
        boolean bSuccess = false;
        try {
            int i = 0;
            while (i < iRows) {
                IDColumn idC = (IDColumn)this.m_tableLabels.getValueAt(i, 0);
                MMStorageOutLabel mOutLabel = new MMStorageOutLabel(this.m_ctx, 0, sTrx);
                mOutLabel.setM_Storage_Label_ID(idC.getRecord_ID());
                if (this.m_PP_CostCollector_ID > 0) {
                    mOutLabel.setPP_Cost_Collector_ID(this.m_PP_CostCollector_ID);
                } else {
                    mOutLabel.setM_InOutLineConfirm_ID(this.m_M_InOutLineConfirm_ID);
                }
                mOutLabel.saveEx();
                ++i;
            }
            bSuccess = true;
        }
        finally {
            if (bSuccess) {
                DB.commit(true, sTrx);
            } else {
                DB.rollback(true, sTrx);
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.m_tableLabels.getRowCount() > 0) {
            this.m_cbSelect.setEnabled(false);
        } else {
            this.m_cbSelect.setEnabled(true);
        }
    }
}

