/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.umserials.form;

import com.f3p.adempiere.umserials.form.AbstractLabelForm;
import com.f3p.adempiere.umserials.model.MMStorageLabel;
import com.f3p.adempiere.umserials.model.X_M_Storage_Label;
import com.f3p.adempiere.util.ModelFactory;
import com.f3p.commons.Utils;
import com.f3p.hal.barcode.BarcodeEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.miginfocom.swing.MigLayout;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.grid.ed.VComboBox;
import org.compiere.grid.ed.VNumber;
import org.compiere.grid.ed.VString;
import org.compiere.model.I_M_InOutLine;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MInOutConfirm;
import org.compiere.model.MInOutLineConfirm;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.MSysConfig;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.eevolution.model.X_PP_Cost_Collector;

public class GenerateLabelForm
extends AbstractLabelForm
implements ItemListener {
    private static final long serialVersionUID = -8406291573536587959L;
    protected CPanel m_panelManual = null;
    protected VString m_vsPrefix = null;
    protected VString m_vsFormat = null;
    protected VString m_vsSuffix = null;
    protected VNumber m_vnNextNum = null;
    protected VNumber m_vnNumLabels = null;
    protected VNumber m_vnQty = null;
    protected VComboBox m_cbProductLocatorASI = null;
    protected CLabel m_lblNeededQty = null;
    protected CButton m_btnGenerate = null;
    protected CButton m_btnDelete = ConfirmPanel.createCancelButton(false);
    protected CButton m_btnCreate = ConfirmPanel.createNewButton(false);

    @Override
    public void init(int WindowNo, FormFrame frame) {
        super.init(WindowNo, frame);
        this.m_panelConfirm.getCancelButton().setVisible(false);
        this.m_panelConfirm.addComponent(this.m_btnCreate);
        this.m_panelConfirm.addComponent(this.m_btnDelete);
        this.m_btnDelete.addActionListener(this);
        this.m_btnCreate.addActionListener(this);
        this.setDefaults();
        this.fillProductLocatorASIList();
    }

    protected void setDefaults() {
        this.m_vnQty.setValue(BigDecimal.ONE);
        String sFormat = MSysConfig.getValue("F3P_UMS_DEFAULT_LABEL_FORMAT", "0000");
        this.m_vsFormat.setValue(sFormat);
    }

    @Override
    protected CPanel createHdrPanel() {
        this.m_panelManual = this.createManualPanel();
        CPanel panelHdr = new CPanel((LayoutManager)new MigLayout());
        panelHdr.add((Component)this.m_panelManual, "wrap");
        panelHdr.add(this.m_panelBarcode);
        return panelHdr;
    }

    protected CPanel createManualPanel() {
        MigLayout layout = new MigLayout();
        CPanel cPanel = new CPanel((LayoutManager)layout);
        this.m_cbProductLocatorASI = new VComboBox();
        this.m_lblNeededQty = new CLabel();
        cPanel.add((Component)new CLabel(Msg.getMsg(this.m_ctx, "F3P_UMS_LBL_ProductLocatorAsi")), "spanx 3");
        cPanel.add((Component)new CLabel(Msg.translate(this.m_ctx, "Qty")), "wrap");
        cPanel.add((Component)this.m_cbProductLocatorASI, "spanx 3");
        cPanel.add((Component)this.m_lblNeededQty, "wrap");
        cPanel.add(new CLabel(Msg.getMsg(this.m_ctx, "F3P_UMS_LBL_Prefix")));
        cPanel.add(new CLabel(Msg.getMsg(this.m_ctx, "F3P_UMS_LBL_LabelFormat")));
        cPanel.add((Component)new CLabel(Msg.getMsg(this.m_ctx, "F3P_UMS_LBL_Suffix")), "spanx 2,wrap");
        this.m_vsPrefix = new VString();
        this.m_vsFormat = new VString();
        this.m_vsSuffix = new VString();
        cPanel.add(this.m_vsPrefix);
        cPanel.add(this.m_vsFormat);
        cPanel.add((Component)this.m_vsSuffix, "spanx 2,wrap");
        cPanel.add(new CLabel(Msg.getMsg(this.m_ctx, "F3P_UMS_LBL_Next")));
        cPanel.add(new CLabel(Msg.getMsg(this.m_ctx, "F3P_UMS_LBL_NLabels")));
        cPanel.add((Component)new CLabel(Msg.getMsg(this.m_ctx, "F3P_UMS_LBL_LabelQty")), "wrap");
        this.m_vnNextNum = new VNumber();
        this.m_vnNumLabels = new VNumber();
        this.m_vnQty = new VNumber();
        this.m_vnNextNum.setDisplayType(11);
        this.m_vnNumLabels.setDisplayType(11);
        this.m_vnQty.setDisplayType(12);
        cPanel.add(this.m_vnNextNum);
        cPanel.add(this.m_vnNumLabels);
        cPanel.add(this.m_vnQty);
        this.m_btnGenerate = new CButton(Msg.getMsg(this.m_ctx, "F3P_UMS_LBL_Generate"));
        this.m_btnGenerate.addActionListener(this);
        cPanel.add((Component)this.m_btnGenerate, "alignx right");
        return cPanel;
    }

    protected void fillProductLocatorASIList() {
        Collection<ProductLocatorASI> listPLA = null;
        if (this.m_PP_CostCollector_ID > 0) {
            if (this.m_bdTargetQty.compareTo(this.m_bdAlreadyCreatedQty) > 0) {
                ProductLocatorASI pla = new ProductLocatorASI();
                pla.m_M_Product_ID = this.m_M_Product_ID;
                pla.m_M_Locator_ID = this.m_M_Locator_ID;
                pla.m_M_AttributeSetInstance_ID = this.m_M_AttributeSetInstance_ID_Real;
                pla.setCostCollector(new X_PP_Cost_Collector(this.m_ctx, this.m_PP_CostCollector_ID, null));
                pla.buildLabel();
                pla.addAlreadyCreatedQty(this.m_bdAlreadyCreatedQty);
                pla.addTargetQty(this.m_bdTargetQty);
                listPLA = new ArrayList<ProductLocatorASI>();
                listPLA.add(pla);
            }
        } else {
            List<MInOutLineConfirm> lstLines = null;
            if (this.m_M_InOutLineConfirm_ID > 0) {
                MInOutLineConfirm mIOLC = ModelFactory.getInOutLineConfirm(this.m_ctx, this.m_M_InOutLineConfirm_ID, null);
                lstLines = new ArrayList<MInOutLineConfirm>();
                lstLines.add(mIOLC);
            } else if (this.m_M_InOutConfirm_ID > 0) {
                MInOutConfirm mIOC = ModelFactory.getInOutConfirm(this.m_ctx, this.m_M_InOutConfirm_ID, null);
                lstLines = Arrays.asList(mIOC.getLines(true));
            }
            if (lstLines != null) {
                listPLA = this.buildPLAListFromInOutConfirmLines(lstLines);
            }
        }
        this.m_cbProductLocatorASI.removeItemListener(this);
        this.m_cbProductLocatorASI.setSelectedItem(null);
        this.m_cbProductLocatorASI.removeAllItems();
        if (listPLA != null) {
            for (ProductLocatorASI pla : listPLA) {
                this.m_cbProductLocatorASI.addItem(pla);
            }
        }
        this.m_cbProductLocatorASI.addItemListener(this);
        this.updateQtyAndLabel();
    }

    protected Collection<ProductLocatorASI> buildPLAListFromInOutConfirmLines(List<MInOutLineConfirm> lstLines) {
        HashMap<ProductLocatorASI, ProductLocatorASI> mapPLA = new HashMap<ProductLocatorASI, ProductLocatorASI>();
        for (MInOutLineConfirm lineConfirm : lstLines) {
            I_M_InOutLine line;
            BigDecimal bdAlreadyCreatedQty;
            if (!lineConfirm.isActive() || (bdAlreadyCreatedQty = this.getAlreadyCreatedQty(lineConfirm.getM_InOutLineConfirm_ID(), true)).compareTo(lineConfirm.getConfirmedQty()) >= 0 || (line = lineConfirm.getM_InOutLine()) == null || line.getM_Product_ID() <= 0 || line.getM_Locator_ID() <= 0) continue;
            ProductLocatorASI pla = new ProductLocatorASI();
            pla.m_M_Product_ID = line.getM_Product_ID();
            pla.m_M_Locator_ID = line.getM_Locator_ID();
            pla.m_M_AttributeSetInstance_ID = MMStorageLabel.getRealAttributeSetInstanceID(this.m_ctx, pla.m_M_Product_ID, line.getM_AttributeSetInstance_ID());
            if (mapPLA.containsKey(pla)) {
                pla = (ProductLocatorASI)mapPLA.get(pla);
            } else {
                pla.buildLabel();
                mapPLA.put(pla, pla);
            }
            lineConfirm.setTargetQty(lineConfirm.getTargetQty().subtract(bdAlreadyCreatedQty));
            pla.addTargetQty(lineConfirm.getConfirmedQty());
            pla.addAlreadyCreatedQty(bdAlreadyCreatedQty);
            pla.addInOutLineConfirm(lineConfirm);
        }
        return mapPLA.values();
    }

    @Override
    public void valueRead(BarcodeEvent evt) {
        ProductLocatorASI pla = (ProductLocatorASI)this.m_cbProductLocatorASI.getSelectedItem();
        if (pla != null) {
            this.addLabelToTable(evt.getValue(), (BigDecimal)this.m_vnQty.getValue(), pla.m_M_Product_ID);
        }
    }

    protected void generateLabels() {
        String sPrefix = (String)this.m_vsPrefix.getValue();
        String sSuffix = (String)this.m_vsSuffix.getValue();
        String sDecimalPattern = (String)this.m_vsFormat.getValue();
        sPrefix = Utils.isEmptyString(sPrefix) ? "" : Env.parseVariable(sPrefix, null, null, false);
        sSuffix = Utils.isEmptyString(sSuffix) ? "" : Env.parseVariable(sSuffix, null, null, false);
        DecimalFormat decFormat = null;
        if (!Utils.isEmptyString(sDecimalPattern)) {
            decFormat = new DecimalFormat(sDecimalPattern);
        }
        if (this.m_vnNextNum.getValue() == null || this.m_vnNumLabels.getValue() == null || this.m_vnQty.getValue() == null || this.m_cbProductLocatorASI.getSelectedItem() == null) {
            this.warnUser();
            return;
        }
        int iNext = (Integer)this.m_vnNextNum.getValue();
        int iNumLabels = (Integer)this.m_vnNumLabels.getValue();
        BigDecimal bdLabelQty = (BigDecimal)this.m_vnQty.getValue();
        int i = 0;
        while (i < iNumLabels) {
            StringBuilder sbLabel = new StringBuilder(sPrefix);
            if (decFormat != null) {
                sbLabel.append(decFormat.format(iNext++));
            } else {
                sbLabel.append(iNext++);
            }
            sbLabel.append(sSuffix);
            ProductLocatorASI pla = (ProductLocatorASI)this.m_cbProductLocatorASI.getSelectedItem();
            if (!this.addLabelToTable(sbLabel.toString(), bdLabelQty, pla.m_M_Product_ID)) break;
            ++i;
        }
    }

    protected void createStorageLabels() throws SQLException {
        int iRows = this.m_tableLabels.getRowCount();
        String sTrx = Trx.createTrxName();
        boolean bSuccess = false;
        ProductLocatorASI pla = (ProductLocatorASI)this.m_cbProductLocatorASI.getSelectedItem();
        ArrayList<MInOutLineConfirm> lstInOutLine = pla.m_listLines;
        X_PP_Cost_Collector mCostCollector = pla.m_mCostCollector;
        try {
            int i = 0;
            while (i < iRows) {
                String sLabel = (String)this.m_tableLabels.getValueAt(i, 1);
                BigDecimal bdQty = (BigDecimal)this.m_tableLabels.getValueAt(i, 2);
                MMStorageLabel mLabel = new MMStorageLabel(this.m_ctx, 0, sTrx);
                mLabel.setLabelNo(sLabel);
                mLabel.setLabelQty(bdQty);
                mLabel.setM_Product_ID(this.m_M_Product_ID);
                mLabel.setM_Locator_ID(this.m_M_Locator_ID);
                mLabel.setM_AttributeSetInstance_ID(this.m_M_AttributeSetInstance_ID_Real);
                if (mCostCollector != null) {
                    mLabel.setPP_Cost_Collector_ID(this.m_PP_CostCollector_ID);
                } else {
                    if (lstInOutLine.size() == 0) break;
                    MInOutLineConfirm inOutLineConfirm = (MInOutLineConfirm)lstInOutLine.get(0);
                    int iCmp = bdQty.compareTo(inOutLineConfirm.getTargetQty());
                    if (iCmp < 0) {
                        inOutLineConfirm.setTargetQty(inOutLineConfirm.getTargetQty().subtract(bdQty));
                    } else if (iCmp == 0) {
                        lstInOutLine.remove(0);
                    } else {
                        throw new AdempiereException("@Invalid@ @Qty@");
                    }
                    mLabel.setM_InOutLineConfirm_ID(inOutLineConfirm.getM_InOutLineConfirm_ID());
                }
                mLabel.saveEx();
                ++i;
            }
            bSuccess = true;
        }
        finally {
            if (bSuccess) {
                DB.commit(true, sTrx);
            } else {
                DB.rollback(true, sTrx);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String sCommand = e.getActionCommand();
        if (e.getSource() == this.m_btnGenerate) {
            this.generateLabels();
        } else if (e.getSource() == this.m_btnCreate) {
            if (this.askQtyConfirmation()) {
                try {
                    this.createStorageLabels();
                    if (this.m_PP_CostCollector_ID > 0) {
                        this.m_bdAlreadyCreatedQty = this.getAlreadyCreatedQty(this.m_PP_CostCollector_ID, false);
                    }
                    this.fillProductLocatorASIList();
                    this.clearLabelTable();
                }
                catch (Exception ex) {
                    ADialog.error(this.m_iWindowNo, this.m_frame.getParent(), ex.getLocalizedMessage());
                    this.dispose();
                }
            }
        } else if (e.getSource() == this.m_btnDelete) {
            this.clearLabelTable();
        } else if (sCommand.equals("Ok")) {
            this.dispose();
        }
    }

    @Override
    protected void clearLabelTable() {
        super.clearLabelTable();
        this.updateQtyAndLabel();
        this.m_cbProductLocatorASI.setEnabled(true);
    }

    @Override
    protected boolean addLabelToTable(String sLabel, BigDecimal bdQty, Integer M_Product_ID) {
        boolean bAdded = super.addLabelToTable(sLabel, bdQty, M_Product_ID);
        if (this.m_tableLabels.getRowCount() > 0) {
            this.m_cbProductLocatorASI.setEnabled(false);
        }
        if (bAdded) {
            this.updateQtyAndLabel();
        }
        return bAdded;
    }

    @Override
    protected boolean addLabelToTable(X_M_Storage_Label mLabel, boolean bCheck) {
        boolean bAdded = super.addLabelToTable(mLabel, bCheck);
        if (this.m_tableLabels.getRowCount() > 0) {
            this.m_cbProductLocatorASI.setEnabled(false);
        }
        if (bAdded) {
            this.updateQtyAndLabel();
        }
        return bAdded;
    }

    protected void updateQtyAndLabel() {
        StringBuilder sbLabel = new StringBuilder("");
        ProductLocatorASI pla = (ProductLocatorASI)this.m_cbProductLocatorASI.getSelectedItem();
        if (pla != null) {
            BigDecimal bdTotalQtyInTable = this.getTotalQtyInTable();
            BigDecimal bdNeededQty = pla.m_bdTargetQty.subtract(pla.m_bdAlreadyCreated);
            sbLabel.append(this.getTotalQtyInTable().setScale(2, RoundingMode.HALF_UP));
            sbLabel.append(" / ");
            sbLabel.append(bdNeededQty.setScale(2, RoundingMode.HALF_UP));
            int cmp = bdTotalQtyInTable.compareTo(bdNeededQty);
            if (cmp < 0) {
                this.m_lblNeededQty.setForeground(Color.GREEN);
            } else if (cmp > 0) {
                this.m_lblNeededQty.setForeground(Color.RED);
            } else {
                this.m_lblNeededQty.setForeground(AdempierePLAF.getTextColor_Normal());
            }
            this.m_bdAlreadyCreatedQty = pla.m_bdAlreadyCreated;
            this.m_bdTargetQty = pla.m_bdTargetQty;
        } else {
            this.m_bdAlreadyCreatedQty = Env.ZERO;
            this.m_bdTargetQty = Env.ZERO;
            this.m_lblNeededQty.setForeground(AdempierePLAF.getTextColor_Normal());
        }
        this.m_lblNeededQty.setText(sbLabel.toString());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.m_cbProductLocatorASI) {
            this.updateQtyAndLabel();
        }
    }

    protected class ProductLocatorASI {
        protected int m_M_Product_ID;
        protected int m_M_Locator_ID;
        protected int m_M_AttributeSetInstance_ID;
        protected String m_sLabel;
        protected BigDecimal m_bdAlreadyCreated;
        protected BigDecimal m_bdTargetQty;
        protected ArrayList<MInOutLineConfirm> m_listLines = null;
        protected X_PP_Cost_Collector m_mCostCollector = null;

        protected ProductLocatorASI() {
        }

        public void addInOutLineConfirm(MInOutLineConfirm lineConfirm) {
            this.m_mCostCollector = null;
            if (this.m_listLines == null) {
                this.m_listLines = new ArrayList();
            }
            this.m_listLines.add(lineConfirm);
        }

        public void setCostCollector(X_PP_Cost_Collector cc) {
            this.m_listLines = null;
            this.m_mCostCollector = cc;
        }

        public void addAlreadyCreatedQty(BigDecimal bdDelta) {
            this.m_bdAlreadyCreated = this.m_bdAlreadyCreated == null ? bdDelta : this.m_bdAlreadyCreated.add(bdDelta);
        }

        public void addTargetQty(BigDecimal bdDelta) {
            this.m_bdTargetQty = this.m_bdTargetQty == null ? bdDelta : this.m_bdTargetQty.add(bdDelta);
        }

        public void buildLabel() {
            MProduct mProd = MProduct.get(GenerateLabelForm.this.m_ctx, this.m_M_Product_ID);
            MLocator mLoc = MLocator.get(GenerateLabelForm.this.m_ctx, this.m_M_Locator_ID);
            MAttributeSetInstance mASI = MAttributeSetInstance.get(GenerateLabelForm.this.m_ctx, this.m_M_AttributeSetInstance_ID, this.m_M_Product_ID);
            StringBuilder sbLabel = new StringBuilder(mProd.getValue());
            sbLabel.append(" / ").append(mLoc.getValue());
            String sASIDesc = mASI.getDescription();
            if (sASIDesc != null) {
                if (sASIDesc.length() > 20) {
                    sASIDesc = sASIDesc.substring(0, 20);
                }
                sbLabel.append(" / ").append(sASIDesc);
            }
            this.m_sLabel = sbLabel.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof ProductLocatorASI) {
                ProductLocatorASI other = (ProductLocatorASI)obj;
                return this.m_M_Product_ID == other.m_M_Product_ID && this.m_M_Locator_ID == other.m_M_Locator_ID && this.m_M_AttributeSetInstance_ID == other.m_M_AttributeSetInstance_ID;
            }
            throw new RuntimeException("Not a ProductLocatorASI");
        }

        public String toString() {
            if (this.m_sLabel == null) {
                this.buildLabel();
            }
            return this.m_sLabel;
        }

        public int hashCode() {
            return this.m_M_AttributeSetInstance_ID + this.m_M_Locator_ID + this.m_M_Product_ID;
        }
    }
}

