/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.umserials.form;

import com.f3p.adempiere.umserials.Message;
import com.f3p.adempiere.umserials.model.MMStorageLabel;
import com.f3p.adempiere.umserials.model.X_M_Storage_Label;
import com.f3p.adempiere.util.FieldHelper;
import com.f3p.adempiere.util.IDResolver;
import com.f3p.adempiere.util.ModelFactory;
import com.f3p.hal.barcode.BarcodeListener;
import com.f3p.hal.barcode.impl.BarcodeReaderField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.compiere.apps.ADialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VCellRenderer;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.GridField;
import org.compiere.model.I_M_InOutConfirm;
import org.compiere.model.I_M_InOutLine;
import org.compiere.model.I_M_InOutLineConfirm;
import org.compiere.model.MInOutLineConfirm;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.model.I_PP_Cost_Collector;
import org.eevolution.model.X_PP_Cost_Collector;

public abstract class AbstractLabelForm
extends CPanel
implements FormPanel,
BarcodeListener,
ActionListener,
Message {
    private static final long serialVersionUID = 6719615988234529099L;
    private static final IDColumn EMPTY_ID = new IDColumn(-1);
    public static final int COL_ID = 0;
    public static final int COL_LABEL = 1;
    public static final int COL_QTY = 2;
    public static final int COL_PRODUCT = 3;
    protected CPanel m_panelContent = null;
    protected CPanel m_panelBarcode = null;
    protected CPanel m_panelHdr = null;
    protected ConfirmPanel m_panelConfirm = null;
    protected MiniTable m_tableLabels = new MiniTable();
    protected FormFrame m_frame;
    protected int m_iWindowNo;
    protected int m_PP_CostCollector_ID = -1;
    protected int m_M_InOutLineConfirm_ID = -1;
    protected int m_M_InOutConfirm_ID = -1;
    protected int m_M_Product_ID = -1;
    protected int m_M_AttributeSetInstance_ID = -1;
    protected int m_M_AttributeSetInstance_ID_Real = -1;
    protected int m_M_Locator_ID = -1;
    protected Properties m_ctx;
    protected Set<String> m_setLabels = new HashSet<String>();
    protected BigDecimal m_bdTargetQty = BigDecimal.ZERO;
    protected BigDecimal m_bdAlreadyCreatedQty = BigDecimal.ZERO;
    protected BarcodeReaderField m_brfBarcode;

    @Override
    public void init(int WindowNo, FormFrame frame) {
        this.m_iWindowNo = WindowNo;
        this.m_frame = frame;
        this.m_ctx = Env.getCtx();
        this.initRecordIDs();
        this.initIDsAndQtyData();
        this.m_tableLabels = this.initTable();
        this.m_panelBarcode = this.createBarcodePanel();
        this.m_panelHdr = this.createHdrPanel();
        this.m_panelContent = new CPanel(new BorderLayout());
        this.m_panelContent.add((Component)this.m_panelHdr, "North");
        this.m_panelConfirm = new ConfirmPanel(true);
        this.m_panelConfirm.addActionListener(this);
        this.m_panelContent.add((Component)this.m_panelConfirm, "South");
        JScrollPane jsp = new JScrollPane(this.m_tableLabels);
        this.m_panelContent.add(jsp);
        frame.setContentPane(this.m_panelContent);
        frame.setPreferredSize(new Dimension(600, 650));
    }

    protected void initRecordIDs() {
        int iTableID = this.m_frame.getProcessInfo().getTable_ID();
        int iRecordID = this.m_frame.getProcessInfo().getRecord_ID();
        if (iTableID == I_PP_Cost_Collector.Table_ID) {
            this.m_PP_CostCollector_ID = iRecordID;
            this.m_M_InOutConfirm_ID = -1;
            this.m_M_InOutLineConfirm_ID = -1;
        } else if (iTableID == I_M_InOutConfirm.Table_ID) {
            this.m_M_InOutConfirm_ID = iRecordID;
            this.m_PP_CostCollector_ID = -1;
            this.m_M_InOutLineConfirm_ID = -1;
        } else if (iTableID == I_M_InOutLineConfirm.Table_ID) {
            this.m_M_InOutLineConfirm_ID = iRecordID;
            this.m_PP_CostCollector_ID = -1;
            this.m_M_InOutConfirm_ID = -1;
        }
    }

    protected void initIDsAndQtyData() {
        if (this.m_PP_CostCollector_ID > 0) {
            X_PP_Cost_Collector pcc = ModelFactory.getCostCollector(this.m_ctx, this.m_PP_CostCollector_ID, null);
            this.m_M_AttributeSetInstance_ID = pcc.getM_AttributeSetInstance_ID();
            this.m_M_Product_ID = pcc.getM_Product_ID();
            this.m_M_Locator_ID = pcc.getM_Locator_ID();
            this.m_bdTargetQty = pcc.getMovementQty();
            this.m_bdAlreadyCreatedQty = this.getAlreadyCreatedQty(this.m_PP_CostCollector_ID, false);
            this.m_M_AttributeSetInstance_ID_Real = MMStorageLabel.getRealAttributeSetInstanceID(this.m_ctx, this.m_M_Product_ID, this.m_M_AttributeSetInstance_ID);
        } else if (this.m_M_InOutLineConfirm_ID > 0) {
            MInOutLineConfirm ioc = ModelFactory.getInOutLineConfirm(this.m_ctx, this.m_M_InOutLineConfirm_ID, null);
            I_M_InOutLine iol = ioc.getM_InOutLine();
            this.m_M_Product_ID = iol.getM_Product_ID();
            this.m_M_Locator_ID = iol.getM_Locator_ID();
            this.m_M_AttributeSetInstance_ID = iol.getM_AttributeSetInstance_ID();
            this.m_bdTargetQty = ioc.getConfirmedQty();
            this.m_bdAlreadyCreatedQty = this.getAlreadyCreatedQty(this.m_M_InOutLineConfirm_ID, true);
            this.m_M_AttributeSetInstance_ID_Real = MMStorageLabel.getRealAttributeSetInstanceID(this.m_ctx, this.m_M_Product_ID, this.m_M_AttributeSetInstance_ID);
        }
        if (this.m_bdAlreadyCreatedQty == null) {
            this.m_bdAlreadyCreatedQty = BigDecimal.ZERO;
        }
    }

    protected BigDecimal getAlreadyCreatedQty(int iID, boolean bIsInOutLineConfirm) {
        BigDecimal bdAlreadyCreatedQty = null;
        bdAlreadyCreatedQty = bIsInOutLineConfirm ? DB.getSQLValueBD(null, "SELECT SUM(LabelQty) FROM M_Storage_Label WHERE M_InOutLineConfirm_ID = ? AND IsActive='Y' GROUP BY M_InOutLineConfirm_ID", iID) : DB.getSQLValueBD(null, "SELECT SUM(LabelQty) FROM M_Storage_Label WHERE PP_Cost_Collector_ID = ? AND IsActive='Y' GROUP BY PP_Cost_Collector_ID", iID);
        if (bdAlreadyCreatedQty == null) {
            bdAlreadyCreatedQty = Env.ZERO;
        }
        return bdAlreadyCreatedQty;
    }

    protected CPanel createBarcodePanel() {
        MigLayout layout = new MigLayout();
        CPanel cPanel = new CPanel((LayoutManager)layout);
        cPanel.add(new CLabel(Msg.getMsg(this.m_ctx, "F3P_UMS_LBL_Barcode")));
        this.m_brfBarcode = new BarcodeReaderField(20);
        this.m_brfBarcode.addListener(this);
        cPanel.add(this.m_brfBarcode);
        return cPanel;
    }

    protected abstract CPanel createHdrPanel();

    protected MiniTable initTable() {
        MiniTable mt = new MiniTable();
        mt.addColumn(" ");
        mt.addColumn(Msg.getMsg(this.m_ctx, "F3P_UMS_LBL_Label"));
        mt.addColumn(Msg.getMsg(this.m_ctx, "F3P_UMS_LBL_LabelQty"));
        mt.addColumn(Msg.translate(this.m_ctx, "M_Product_ID"));
        mt.setColumnClass(0, IDColumn.class, true);
        mt.setColumnClass(1, String.class, true);
        mt.setColumnClass(2, BigDecimal.class, true);
        mt.setColumnClass(3, Integer.class, true);
        int iColMProductID = IDResolver.getAD_Column_ID("M_InOutLine", "M_Product_ID");
        GridField fieldProduct = FieldHelper.getField(this.m_iWindowNo, iColMProductID);
        mt.getColumn(3).setCellRenderer(new VCellRenderer(fieldProduct));
        mt.setAutoResizeMode(1);
        mt.autoSize();
        return mt;
    }

    protected boolean addLabelToTable(String sLabel, BigDecimal bdQty, Integer M_Product_ID) {
        if (sLabel == null || bdQty.signum() <= 0 || this.isLabelInTable(sLabel) || M_Product_ID == null || M_Product_ID <= 0) {
            this.warnUser();
            return false;
        }
        String sCheckLabel = sLabel.toUpperCase();
        this.m_setLabels.add(sCheckLabel);
        int iRow = this.m_tableLabels.getRowCount();
        this.m_tableLabels.setRowCount(iRow + 1);
        this.m_tableLabels.setValueAt(EMPTY_ID, iRow, 0);
        this.m_tableLabels.setValueAt(sLabel, iRow, 1);
        this.m_tableLabels.setValueAt(bdQty, iRow, 2);
        this.m_tableLabels.setValueAt(M_Product_ID, iRow, 3);
        this.m_tableLabels.autoSize();
        return true;
    }

    protected void addExistingLabelToTable(String sLabel) {
        if (this.isLabelInTable(sLabel)) {
            this.warnUser();
            return;
        }
        X_M_Storage_Label mLabel = MMStorageLabel.getLabelByNameAndProdLocASI(this.m_ctx, sLabel, this.m_M_Product_ID, this.m_M_Locator_ID, this.m_M_AttributeSetInstance_ID, true, null);
        if (!this.addLabelToTable(mLabel, false)) {
            this.warnUser();
        }
    }

    protected boolean addLabelToTable(X_M_Storage_Label mLabel, boolean bCheck) {
        boolean bAdded = false;
        if (mLabel != null) {
            if (bCheck && this.isLabelInTable(mLabel.getLabelNo())) {
                return false;
            }
            String sLabel = mLabel.getLabelNo();
            this.m_setLabels.add(sLabel.toUpperCase());
            int iRow = this.m_tableLabels.getRowCount();
            this.m_tableLabels.setRowCount(iRow + 1);
            this.m_tableLabels.setValueAt(new IDColumn(mLabel.getM_Storage_Label_ID()), iRow, 0);
            this.m_tableLabels.setValueAt(sLabel, iRow, 1);
            this.m_tableLabels.setValueAt(mLabel.getLabelQty(), iRow, 2);
            this.m_tableLabels.setValueAt(mLabel.getM_Product_ID(), iRow, 3);
            this.m_tableLabels.autoSize();
            bAdded = true;
        }
        return bAdded;
    }

    protected void clearLabelTable() {
        this.m_setLabels.clear();
        this.m_tableLabels.setRowCount(0);
        this.m_tableLabels.autoSize();
    }

    protected BigDecimal getTotalQtyInTable() {
        int iRows = this.m_tableLabels.getRowCount();
        BigDecimal bdQty = BigDecimal.ZERO;
        int i = 0;
        while (i < iRows) {
            BigDecimal bdRowQty = (BigDecimal)this.m_tableLabels.getValueAt(i, 2);
            bdQty = bdQty.add(bdRowQty);
            ++i;
        }
        return bdQty;
    }

    protected boolean askQtyConfirmation() {
        BigDecimal bdNeededQty;
        BigDecimal bdTableQty = this.getTotalQtyInTable();
        int cmp = bdTableQty.compareTo(bdNeededQty = this.m_bdTargetQty.subtract(this.m_bdAlreadyCreatedQty));
        if (cmp != 0) {
            String sMsg = Msg.getMsg(Env.getLanguage(this.m_ctx), "F3P_UMS_ERR_QtyNotMatches", (Object[])new BigDecimal[]{this.m_bdTargetQty, bdTableQty, this.m_bdAlreadyCreatedQty});
            if (cmp < 0) {
                return ADialog.ask(this.m_iWindowNo, this, sMsg);
            }
            if (cmp > 0) {
                ADialog.error(this.m_iWindowNo, this, sMsg);
                return false;
            }
        }
        return true;
    }

    protected boolean isLabelInTable(String sLabel) {
        String sCheckLabel = sLabel.toUpperCase();
        return this.m_setLabels.contains(sCheckLabel);
    }

    protected void warnUser() {
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }
}

