/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.tree;

import com.f3p.adempiere.tree.TreeTypeDef;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Properties;
import org.compiere.model.MTree;
import org.compiere.model.MTree_Base;
import org.compiere.model.MTree_Node;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class TreeHelper {
    public static final String INITIALIZATION_SQL = "SELECT TREETYPE,TABLENAME,KEYCOLUMNNAME,TREENAME,TREEDESCR FROM F3P_TREETYPE";
    public static final String SQL_MAXSEQNO = "SELECT MAX(SEQNO) FROM AD_TREENODE WHERE AD_TREE_ID = ?";
    public static final String SQL_NODE_CHILDREN = "SELECT NODE_ID FROM AD_TREENODE WHERE AD_TREE_ID=? AND PARENT_ID=? ORDER BY SEQNO";
    public static final String SQL_NODE_CHILDREN_PARENT0 = "SELECT NODE_ID FROM AD_TREENODE WHERE AD_TREE_ID=? AND PARENT_ID IS NULL AND NODE_ID <> 0 ORDER BY SEQNO";
    public static final String SQL_CUSTOM_TREETYPE = "SELECT 'OK' FROM F3P_TREETYPE WHERE TREETYPE = ?";
    public static final int MAX_TREENAME_LENGTH = 60;
    private static CLogger s_log = CLogger.getCLogger(TreeHelper.class);
    private static boolean s_bInitilized = false;
    private static boolean s_bExtensionNotInstalled = false;
    private static HashMap<String, Boolean> s_customTree = new HashMap();
    private static HashMap<String, TreeTypeDef> s_mapSourceTable = new HashMap();
    private static HashMap<String, String> s_mapTreeType = new HashMap();

    private static void init() {
        if (s_bExtensionNotInstalled) {
            return;
        }
        CPreparedStatement pstmt = DB.prepareStatement(INITIALIZATION_SQL, null);
        ResultSet rs = null;
        try {
            try {
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String sTreeType = rs.getString("TREETYPE");
                    String sKeyColumn = rs.getString("KEYCOLUMNNAME");
                    String sTreeName = rs.getString("TREENAME");
                    String sTreeDesc = rs.getString("TREEDESCR");
                    String sTableName = rs.getString("TABLENAME");
                    TreeTypeDef treeDef = new TreeTypeDef(sTreeName, sTreeDesc, sTableName);
                    s_mapSourceTable.put(sTreeType, treeDef);
                    s_mapTreeType.put(sKeyColumn, sTreeType);
                }
                s_bInitilized = true;
                s_bExtensionNotInstalled = false;
            }
            catch (SQLException e) {
                s_bExtensionNotInstalled = true;
                s_log.warning("TreeHelper initialiazion error, TreeExtension probably not installed");
                DB.close(rs, pstmt);
            }
        }
        finally {
            DB.close(rs, pstmt);
        }
    }

    public static String getTreeType(String sKeyColumnName) {
        String sTreeType = null;
        if (!s_bInitilized) {
            TreeHelper.init();
        }
        if (s_bInitilized) {
            sTreeType = s_mapTreeType.get(sKeyColumnName);
        }
        return sTreeType;
    }

    public static String getSourceTable(String sTreeType) {
        TreeTypeDef treeDef;
        String sSourceTable = null;
        if (!s_bInitilized) {
            TreeHelper.init();
        }
        if (s_bInitilized && (treeDef = s_mapSourceTable.get(sTreeType)) != null) {
            sSourceTable = treeDef.getTableName();
        }
        return sSourceTable;
    }

    public static MTree createTree(Properties ctx, String sTreeType, String sTrx) throws SQLException {
        MTree mTree = null;
        if (!s_bInitilized) {
            TreeHelper.init();
        }
        if (s_bInitilized) {
            TreeTypeDef treeDef = s_mapSourceTable.get(sTreeType);
            mTree = new MTree(ctx, 0, sTrx);
            mTree.setTreeType(sTreeType);
            String sTime = String.valueOf(System.currentTimeMillis());
            String sTreeName = treeDef.getTreeName();
            String sFullTreeName = String.valueOf(sTreeName) + "_" + sTime;
            if (sFullTreeName.length() > 60) {
                int nIndexLength = sTime.length();
                int nOffset = 60 - nIndexLength;
                sTreeName = sTreeName.substring(0, nOffset);
                sFullTreeName = String.valueOf(sTreeName) + sTime;
            }
            mTree.setName(sFullTreeName);
            mTree.setDescription(treeDef.getTreeDesc());
            mTree.setIsAllNodes(true);
            mTree.setIsDefault(false);
            if (!mTree.save()) {
                mTree = null;
            }
        }
        return mTree;
    }

    public static boolean createNode(Properties sCtx, int nLine, int nTreeID, int nodeID, String sTrx) {
        MTree_Base mTree = new MTree_Base(sCtx, nTreeID, sTrx);
        MTree_Node mNode = new MTree_Node(mTree, nodeID);
        mNode.setSeqNo(nLine);
        return mNode.save();
    }

    public static boolean createNode(Properties sCtx, int nLine, int nTreeID, int nodeID, int nParent, String sTrx) {
        MTree_Base mTree = new MTree_Base(sCtx, nTreeID, sTrx);
        MTree_Node mNode = new MTree_Node(mTree, nodeID);
        mNode.setSeqNo(nLine);
        mNode.setParent_ID(nParent);
        return mNode.save();
    }

    public static boolean deleteTree(Properties ctx, int nTreeID, String sTrx) {
        MTree mTree = new MTree(ctx, nTreeID, sTrx);
        return mTree.delete(true, sTrx);
    }

    public static LinkedList<Integer> moveNode(int nSourceTreeId, int nDestTreeId, int nNodeId, String sTrx) throws SQLException {
        LinkedList<Integer> lstProcessedId = new LinkedList<Integer>();
        TreeHelper.moveNode(nSourceTreeId, nDestTreeId, nNodeId, 0, lstProcessedId, sTrx);
        return lstProcessedId;
    }

    private static void moveNode(int nSourceTreeId, int nDestTreeId, int nNodeId, int nParentId, LinkedList<Integer> lstProcessedId, String sTrx) throws SQLException {
        Properties ctx = Env.getCtx();
        lstProcessedId.add(nNodeId);
        MTree tree = new MTree(ctx, nSourceTreeId, sTrx);
        MTree_Node treeNode = new MTree_Node(tree, nNodeId);
        LinkedList<Integer> lstChildrenIds = TreeHelper.getChildrens(nSourceTreeId, nNodeId, sTrx);
        treeNode.setAD_Tree_ID(nDestTreeId);
        int nSeqNo = TreeHelper.getMaxSeqNo(nDestTreeId, sTrx) + 10;
        treeNode.setSeqNo(nSeqNo);
        treeNode.setParent_ID(nParentId);
        treeNode.save();
        TreeHelper.deleteNode(ctx, nSourceTreeId, nNodeId, sTrx);
        nParentId = nNodeId;
        for (Integer nodeId : lstChildrenIds) {
            TreeHelper.moveNode(nSourceTreeId, nDestTreeId, nodeId, nParentId, lstProcessedId, sTrx);
        }
    }

    public static LinkedList<Integer> getChildrens(int nTreeId, int nNodeParentId, String sTrx) throws SQLException {
        LinkedList<Integer> lstIds = new LinkedList<Integer>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            if (nNodeParentId != 0) {
                pstmt = DB.prepareStatement(SQL_NODE_CHILDREN, sTrx);
                pstmt.setInt(1, nTreeId);
                pstmt.setInt(2, nNodeParentId);
            } else {
                pstmt = DB.prepareStatement(SQL_NODE_CHILDREN_PARENT0, sTrx);
                pstmt.setInt(1, nTreeId);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                lstIds.add(rs.getInt(1));
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
        return lstIds;
    }

    public static boolean deleteNode(Properties ctx, int nTreeID, int nNodeID, String sTrx) {
        MTree_Base mTree = new MTree_Base(ctx, nTreeID, sTrx);
        MTree_Node mNode = MTree_Node.get(mTree, nNodeID);
        return mNode.delete(true);
    }

    public static int getMaxSeqNo(int nTreeId, String sTrx) throws SQLException {
        int nValue = -1;
        CPreparedStatement pstmt = DB.prepareStatement(SQL_MAXSEQNO, sTrx);
        pstmt.setInt(1, nTreeId);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            nValue = rs.getInt(1);
        }
        pstmt.close();
        rs.close();
        return nValue;
    }

    public static boolean isCustomTree(String sTreeType, String sTrx) {
        boolean bReturn;
        block8: {
            bReturn = false;
            Boolean bValue = s_customTree.get(sTreeType);
            if (bValue != null) {
                bReturn = bValue;
            } else {
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(SQL_CUSTOM_TREETYPE, sTrx);
                        pstmt.setString(1, sTreeType);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            bReturn = true;
                        }
                        s_customTree.put(sTreeType, bReturn);
                    }
                    catch (SQLException e) {
                        s_log.warning("TreeHelper initialiazion error, TreeExtension probably not installed");
                        DB.close(rs, pstmt);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
                DB.close(rs, pstmt);
            }
        }
        return bReturn;
    }
}

