/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.search;

import com.f3p.adempiere.search.InfoPrepareFilterData;
import com.f3p.adempiere.util.ClientHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import javax.script.ScriptEngine;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.model.MRule;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class ScriptedInfoDefinitionFilter {
    public static final String SYSC_SEP = "_";
    public static final String SYSC_PREFIX = "InfoFilterRule_";
    public static final String PARAM_DATA = "A_FilterData";
    public static final String PARAM_CTX = "A_Ctx";
    public static final String ZK_PANEL_SUFFIX = "Panel";
    private CLogger s_log = CLogger.getCLogger(ScriptedInfoDefinitionFilter.class);
    private MRule m_rule;
    private Properties m_ctx;

    public ScriptedInfoDefinitionFilter(Properties ctx, Class infoClass) {
        this(ctx, infoClass, Env.getAD_Client_ID(ctx), Env.getAD_Org_ID(ctx), Env.getAD_Role_ID(ctx));
    }

    public ScriptedInfoDefinitionFilter(Properties ctx, Class infoClass, int AD_Client_ID, int AD_Org_ID, int AD_Role_ID) {
        this.m_ctx = ctx;
        String sClassname = infoClass.getSimpleName();
        String sRuleValue = this.getRuleName(sClassname, AD_Client_ID, AD_Org_ID, AD_Role_ID);
        this.m_rule = MRule.get(ctx, sRuleValue);
        if (this.m_rule != null && !this.m_rule.getRuleType().equals("S")) {
            throw new AdempiereException("Not a scripted rule: " + this.m_rule.getValue());
        }
    }

    public String getRuleName(String sClassname, int AD_Client_ID, int AD_Org_ID, int AD_Role_ID) {
        boolean bIsZKClient = ClientHelper.isZKClient();
        String sRuleName = this.getRuleName(sClassname, AD_Client_ID, AD_Org_ID, AD_Role_ID, false);
        if (sRuleName == null && bIsZKClient) {
            sRuleName = this.getRuleName(sClassname, AD_Client_ID, AD_Org_ID, AD_Role_ID, true);
        }
        return sRuleName;
    }

    public String getRuleName(String sClassname, int AD_Client_ID, int AD_Org_ID, int AD_Role_ID, boolean bIsZKClient) {
        if (bIsZKClient && sClassname.endsWith(ZK_PANEL_SUFFIX)) {
            int endIndex = sClassname.length() - ZK_PANEL_SUFFIX.length();
            sClassname = sClassname.substring(0, endIndex);
        }
        StringBuilder sbName = new StringBuilder(SYSC_PREFIX);
        sbName.append(sClassname);
        String sNoRole = sbName.toString();
        sbName.append(SYSC_SEP).append(AD_Role_ID);
        String sWithRole = sbName.toString();
        String sRuleName = MSysConfig.getValue(sWithRole, AD_Client_ID, AD_Org_ID);
        if (sRuleName == null) {
            sRuleName = MSysConfig.getValue(sNoRole, AD_Client_ID, AD_Org_ID);
        }
        return sRuleName;
    }

    public InfoPrepareFilterData doPrepareFilter(ColumnInfo[] layout, String sFrom, String sStaticWhere, String sOrderBy) {
        ArrayList<ColumnInfo> lstLayout = new ArrayList<ColumnInfo>(Arrays.asList(layout));
        InfoPrepareFilterData data = new InfoPrepareFilterData(lstLayout, sFrom, sStaticWhere, sOrderBy);
        if (this.m_rule != null) {
            ScriptEngine engine = this.m_rule.getScriptEngine();
            MRule.setContext(engine, this.m_ctx, 0);
            this.m_rule.getScript();
            engine.put(PARAM_CTX, this.m_ctx);
            engine.put(PARAM_DATA, data);
            try {
                engine.eval(this.m_rule.getScript());
            }
            catch (Exception e) {
                this.s_log.log(Level.SEVERE, "", e);
                throw new AdempiereException(e.getMessage());
            }
        }
        return data;
    }
}

