/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.rma.model;

import com.f3p.adempiere.rma.model.F3PMRmaLine;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.MSysConfig;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MRMALine
extends org.compiere.model.MRMALine {
    private static final long serialVersionUID = 1L;
    protected static final String CHECK_ORDER_TYPE = "ITMNT_CopyLineOnlyIfMaintOrder";

    public MRMALine(Properties ctx, int M_RMALine_ID, String trxName) {
        super(ctx, M_RMALine_ID, trxName);
    }

    public MRMALine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        boolean bValorized = false;
        boolean bUnvalorized = false;
        int C_Charge_ID = this.getC_Charge_ID();
        BigDecimal bdQty = this.getQty();
        BigDecimal bdAmt = this.getAmt();
        if (this.getM_InOutLine_ID() == 0 && this.getC_Charge_ID() == 0) {
            this.set_ValueNoCheck("C_Charge_ID", -1);
            bValorized = true;
        } else if (this.getM_InOutLine_ID() != 0 && this.getC_Charge_ID() != 0) {
            this.set_ValueNoCheck("C_Charge_ID", 0);
            bUnvalorized = true;
        }
        boolean bSuccess = super.beforeSave(newRecord);
        if (bValorized || bUnvalorized) {
            this.setC_Charge_ID(C_Charge_ID);
            if (bValorized) {
                this.setAmt(bdAmt);
                this.setQty(bdQty);
                this.setLineNetAmt(this.getTotalAmt());
            } else if (bUnvalorized && !newRecord) {
                BigDecimal bdOriginalQty = Env.ZERO;
                if (this.getInvoiceLineId() != 0) {
                    MInvoiceLine invoiceLine = new MInvoiceLine(this.getCtx(), this.getInvoiceLineId(), this.get_TrxName());
                    bdOriginalQty = invoiceLine.getQtyInvoiced();
                } else {
                    MInOutLine mIOLine = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
                    if (mIOLine.getC_OrderLine_ID() != 0) {
                        MOrderLine orderLine = new MOrderLine(this.getCtx(), mIOLine.getC_OrderLine_ID(), this.get_TrxName());
                        bdOriginalQty = orderLine.getQtyDelivered();
                    }
                }
                this.setQty(bdOriginalQty);
                this.setLineNetAmt(this.getTotalAmt());
            }
        }
        return bSuccess;
    }

    private int getInvoiceLineId() {
        int invoiceLine_ID = new Query(this.getCtx(), "C_InvoiceLine", "M_InOutLine_ID=?", this.get_TrxName()).setParameters(this.getM_InOutLine_ID()).firstIdOnly();
        return invoiceLine_ID <= 0 ? 0 : invoiceLine_ID;
    }

    @Override
    public int getM_Product_ID() {
        int M_Product_ID = F3PMRmaLine.getM_Product_ID(this);
        if (M_Product_ID == 0) {
            M_Product_ID = super.getM_Product_ID();
        }
        return M_Product_ID;
    }

    @Override
    public int getM_AttributeSetInstance_ID() {
        int M_AttributeSetInstance_ID = F3PMRmaLine.getM_AttributeSetInstance_ID(this);
        if (M_AttributeSetInstance_ID == 0) {
            M_AttributeSetInstance_ID = super.getM_AttributeSetInstance_ID();
        }
        return M_AttributeSetInstance_ID;
    }

    @Override
    public boolean checkQty() {
        MInOutLine mIOLine = new MInOutLine(Env.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
        boolean bCheckOrderType = MSysConfig.getBooleanValue(CHECK_ORDER_TYPE, true, this.getAD_Client_ID(), this.getAD_Org_ID());
        if (bCheckOrderType) {
            if (!mIOLine.is_new() && mIOLine.getMovementQty().compareTo(this.getQty()) < 0) {
                return false;
            }
            BigDecimal totalQty = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(Qty) FROM M_RMALine rl JOIN M_RMA r ON (r.M_RMA_ID = rl.M_RMA_ID) WHERE M_InOutLine_ID = ? AND M_RMALine_ID != ? AND r.Processed = 'Y' AND r.DocStatus IN ('CO','CL')", this.getM_InOutLine_ID(), this.getM_RMALine_ID());
            if (totalQty == null) {
                totalQty = Env.ZERO;
            }
            totalQty = totalQty.add(this.getQty());
            if (!mIOLine.is_new() && mIOLine.getMovementQty().compareTo(totalQty) < 0) {
                return false;
            }
        }
        return true;
    }
}

