/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.riba.model;

import com.f3p.adempiere.model.AbstractBoostrappableValidator;
import com.f3p.adempiere.riba.model.F3PMBPBankAccount;
import com.f3p.adempiere.util.ModelFactory;
import com.f3p.commons.Utils;
import java.util.Properties;
import org.compiere.model.GridTable;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.SetGetModel;
import org.compiere.model.SetGetUtil;
import org.compiere.model.X_C_BP_BankAccount;
import org.compiere.model.X_C_Invoice;
import org.compiere.model.X_C_Order;
import org.compiere.model.X_M_InOut;

public class FieldsValidator
extends AbstractBoostrappableValidator {
    public static final String COLUMNNAME_M_SHIPPER_ID = "M_Shipper_ID";
    public static final String COLUMNNAME_DELIVERYVIARULE = "DeliveryViaRule";
    public static final String COLUMNNAME_BP_PORTO = "BP_Porto";
    public static final String COLUMNNAME_C_BPARTNER_ID = "C_BPartner_ID";
    public static final String COLUMNNAME_C_BP_BANKACCOUNT_ID = "C_BP_BankAccount_ID";
    public static final String COLUMNNAME_PAYMENTRULE = "PaymentRule";
    public static final String COLUMNNAME_ISSOTRX = "IsSOTrx";
    public static final String COLUMNNAME_C_ORDER_ID = "C_Order_ID";
    public static final String RIBA = "R";
    public static final int SETTED_C_BP_BANKACCOUNT_ID = 1;
    public static final int SETTED_M_SHIPPER_ID = 2;
    public static final int SETTED_DELIVERYVIARULE = 4;
    public static final int SETTED_BP_PORTO = 8;

    @Override
    public String docValidate(PO arg0, int arg1) {
        return null;
    }

    @Override
    public void initialize(ModelValidationEngine engine, MClient mClient) {
        super.initialize(engine, mClient);
        engine.addModelChange("C_BP_BankAccount", this.getValidator());
        engine.addModelChange("C_Invoice", this.getValidator());
        engine.addModelChange("C_Order", this.getValidator());
        engine.addModelChange("M_InOut", this.getValidator());
    }

    @Override
    public String login(int arg0, int arg1, int arg2) {
        return null;
    }

    @Override
    public String modelChange(PO model, int nType) throws Exception {
        if (!GridTable.isSavedFromUI(model)) {
            if (model instanceof X_C_BP_BankAccount && nType == 2) {
                MBPBankAccount bankAccount = (MBPBankAccount)model;
                F3PMBPBankAccount.setWSC_IBAN(bankAccount, F3PMBPBankAccount.get_IBAN(bankAccount));
            } else if (model instanceof X_C_Invoice && nType == 1) {
                SetGetModel mInvoice = SetGetUtil.wrap((X_C_Invoice)model);
                FieldsValidator.propagateFields(mInvoice, false, null, null);
            } else if (model instanceof X_C_Order && nType == 1) {
                SetGetModel mOrder = SetGetUtil.wrap((X_C_Order)model);
                FieldsValidator.propagateFields(mOrder, false, null, null);
            } else if (model instanceof X_M_InOut && nType == 1) {
                SetGetModel mInOut = SetGetUtil.wrap((X_M_InOut)model);
                FieldsValidator.propagateFields(mInOut, false, null, null);
            }
        }
        return null;
    }

    public static int propagateFields(SetGetModel model, boolean bCallout, Integer C_Order_ID, Integer C_BPartner_ID) {
        int iDone = 0;
        boolean bPropagate = false;
        String sFromTableName = model.get_TableName();
        if (sFromTableName.equalsIgnoreCase("C_Order")) {
            bPropagate = true;
        } else {
            boolean bIsSOTrx = SetGetUtil.get_AttrValueAsBoolean(model, COLUMNNAME_ISSOTRX);
            if (bIsSOTrx) {
                bPropagate = true;
            }
        }
        if (bPropagate) {
            MOrder mOrder = null;
            MBPartner mBPartner = null;
            SetGetModel orderModel = null;
            SetGetModel bpModel = null;
            int M_Shipper_ID = 0;
            int C_BP_BANKACCOUNT_ID = 0;
            String sDeliveryViaRule = null;
            String sBP_Porto = null;
            String sPaymentRule = null;
            if (bCallout) {
                if (C_Order_ID != null && C_Order_ID > 0) {
                    mOrder = ModelFactory.getOrder(model.getCtx(), C_Order_ID, model.get_TrxName());
                    if (mOrder != null) {
                        orderModel = SetGetUtil.wrap(mOrder);
                    }
                } else if (C_BPartner_ID != null && C_BPartner_ID > 0 && (mBPartner = ModelFactory.getBusinessPartner(model.getCtx(), C_BPartner_ID, model.get_TrxName())) != null) {
                    bpModel = SetGetUtil.wrap(mBPartner);
                }
            } else if (sFromTableName.equalsIgnoreCase("C_Invoice") || sFromTableName.equalsIgnoreCase("M_InOut")) {
                if (model.hasColumn(COLUMNNAME_C_ORDER_ID)) {
                    C_Order_ID = SetGetUtil.get_AttrValueAsInt(model, COLUMNNAME_C_ORDER_ID);
                    mOrder = ModelFactory.getOrder(model.getCtx(), C_Order_ID, model.get_TrxName());
                }
                if (mOrder != null) {
                    orderModel = SetGetUtil.wrap(mOrder);
                }
            }
            if (orderModel != null) {
                if (orderModel.hasColumn(COLUMNNAME_M_SHIPPER_ID)) {
                    M_Shipper_ID = SetGetUtil.get_AttrValueAsInt(orderModel, COLUMNNAME_M_SHIPPER_ID);
                }
                if (orderModel.hasColumn(COLUMNNAME_DELIVERYVIARULE)) {
                    sDeliveryViaRule = SetGetUtil.get_AttrValueAsString(orderModel, COLUMNNAME_DELIVERYVIARULE, null);
                }
                if (orderModel.hasColumn(COLUMNNAME_BP_PORTO)) {
                    sBP_Porto = SetGetUtil.get_AttrValueAsString(orderModel, COLUMNNAME_BP_PORTO, null);
                }
                if (orderModel.hasColumn(COLUMNNAME_PAYMENTRULE)) {
                    sPaymentRule = SetGetUtil.get_AttrValueAsString(orderModel, COLUMNNAME_PAYMENTRULE, null);
                }
                if (sPaymentRule != null && sPaymentRule.equalsIgnoreCase(RIBA) && orderModel.hasColumn(COLUMNNAME_C_BP_BANKACCOUNT_ID)) {
                    C_BP_BANKACCOUNT_ID = SetGetUtil.get_AttrValueAsInt(orderModel, COLUMNNAME_C_BP_BANKACCOUNT_ID);
                }
            } else if (bpModel == null && !bCallout) {
                if (model.hasColumn(COLUMNNAME_C_BPARTNER_ID)) {
                    C_BPartner_ID = SetGetUtil.get_AttrValueAsInt(model, COLUMNNAME_C_BPARTNER_ID);
                    mBPartner = ModelFactory.getBusinessPartner(model.getCtx(), C_BPartner_ID, model.get_TrxName());
                }
                if (mBPartner != null) {
                    bpModel = SetGetUtil.wrap(mBPartner);
                }
            }
            if (bpModel != null) {
                if (bpModel.hasColumn(COLUMNNAME_M_SHIPPER_ID)) {
                    M_Shipper_ID = SetGetUtil.get_AttrValueAsInt(bpModel, COLUMNNAME_M_SHIPPER_ID);
                }
                if (bpModel.hasColumn(COLUMNNAME_DELIVERYVIARULE)) {
                    sDeliveryViaRule = SetGetUtil.get_AttrValueAsString(bpModel, COLUMNNAME_DELIVERYVIARULE, null);
                }
                if (bpModel.hasColumn(COLUMNNAME_BP_PORTO)) {
                    sBP_Porto = SetGetUtil.get_AttrValueAsString(bpModel, COLUMNNAME_BP_PORTO, null);
                }
                if (bpModel.hasColumn(COLUMNNAME_PAYMENTRULE)) {
                    sPaymentRule = SetGetUtil.get_AttrValueAsString(bpModel, COLUMNNAME_PAYMENTRULE, null);
                }
                if (sPaymentRule != null && sPaymentRule.equalsIgnoreCase(RIBA) && model.hasColumn(COLUMNNAME_C_BP_BANKACCOUNT_ID)) {
                    C_BP_BANKACCOUNT_ID = FieldsValidator.getC_BP_BankAccount_ID_FromBP(model.getCtx(), C_BPartner_ID, model.get_TrxName());
                }
            }
            if (orderModel != null || bpModel != null) {
                if (sFromTableName.equalsIgnoreCase("C_Invoice")) {
                    M_Shipper_ID = 0;
                    sDeliveryViaRule = null;
                    sBP_Porto = null;
                } else if (sFromTableName.equalsIgnoreCase("M_InOut")) {
                    C_BP_BANKACCOUNT_ID = 0;
                }
                if (M_Shipper_ID > 0 && model.hasColumn(COLUMNNAME_M_SHIPPER_ID)) {
                    SetGetUtil.set_AttrValueEx(model, COLUMNNAME_M_SHIPPER_ID, M_Shipper_ID);
                    iDone = 2;
                }
                if (!Utils.isEmptyString(sDeliveryViaRule) && model.hasColumn(COLUMNNAME_DELIVERYVIARULE)) {
                    SetGetUtil.set_AttrValueEx(model, COLUMNNAME_DELIVERYVIARULE, sDeliveryViaRule);
                    iDone = 4;
                }
                if (!Utils.isEmptyString(sBP_Porto) && model.hasColumn(COLUMNNAME_BP_PORTO)) {
                    SetGetUtil.set_AttrValueEx(model, COLUMNNAME_BP_PORTO, sBP_Porto);
                    iDone = 8;
                }
                if (C_BP_BANKACCOUNT_ID > 0 && model.hasColumn(COLUMNNAME_C_BP_BANKACCOUNT_ID)) {
                    SetGetUtil.set_AttrValueEx(model, COLUMNNAME_C_BP_BANKACCOUNT_ID, C_BP_BANKACCOUNT_ID);
                    iDone = 1;
                }
            }
        }
        return iDone;
    }

    protected boolean propagate(SetGetModel model) {
        String sBP_Porto;
        int iM_Shipper_ID;
        int iC_BP_BANKACCOUNT_ID;
        boolean bPropagate = true;
        if (model.hasColumn(COLUMNNAME_C_BP_BANKACCOUNT_ID) && (iC_BP_BANKACCOUNT_ID = SetGetUtil.get_AttrValueAsInt(model, COLUMNNAME_C_BP_BANKACCOUNT_ID)) > 0) {
            bPropagate = false;
        }
        if (model.hasColumn(COLUMNNAME_M_SHIPPER_ID) && bPropagate && (iM_Shipper_ID = SetGetUtil.get_AttrValueAsInt(model, COLUMNNAME_M_SHIPPER_ID)) > 0) {
            bPropagate = false;
        }
        if (model.hasColumn(COLUMNNAME_BP_PORTO) && bPropagate && (sBP_Porto = SetGetUtil.get_AttrValueAsString(model, COLUMNNAME_BP_PORTO, null)) != null) {
            bPropagate = false;
        }
        return bPropagate;
    }

    protected static int getC_BP_BankAccount_ID_FromBP(Properties ctx, int C_BPartner_ID, String sTrx) {
        Query q = new Query(ctx, "C_BP_BankAccount", "C_BPartner_ID = ? AND WSC_SWITCH_RIBA = 'Y'", null);
        q.setOnlyActiveRecords(true).setParameters(C_BPartner_ID);
        return q.firstId();
    }
}

