/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.resource;

import com.f3p.adempiere.resource.ResourceLocator;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public class Handler
extends URLStreamHandler {
    public static final String PROTOCOL = "resource";
    public static final String PROTOCOL_PKGS_PROP = "java.protocol.handler.pkgs";

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        if (!url.getProtocol().toLowerCase().equals(PROTOCOL)) {
            throw new IOException("Invalid protocolo");
        }
        if (this.isJarURL(url)) {
            return this.getJarConnection(url);
        }
        File file = new File(ResourceLocator.getResourceTempLocation(), url.getPath());
        return file.toURI().toURL().openConnection();
    }

    public boolean isJarURL(URL url) {
        return url.getHost().equalsIgnoreCase("jar");
    }

    public URLConnection getJarConnection(URL url) throws IOException {
        URL urlResource = this.getClass().getResource(url.getPath());
        return urlResource.openConnection();
    }

    public static void registerHandler() {
        String packageName = Handler.class.getPackage().getName();
        String pkg = packageName.substring(0, packageName.lastIndexOf(46));
        String sHandlers = System.getProperty(PROTOCOL_PKGS_PROP, "");
        if (sHandlers.indexOf(pkg) == -1) {
            if (sHandlers.length() != 0) {
                sHandlers = String.valueOf(sHandlers) + "|";
            }
            sHandlers = String.valueOf(sHandlers) + pkg;
            System.setProperty(PROTOCOL_PKGS_PROP, sHandlers);
        }
    }
}

