/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.report.engine;

import com.f3p.adempiere.model.MReportDef;
import com.f3p.adempiere.model.MReportDet;
import com.f3p.adempiere.report.ReportProcess;
import java.awt.print.PrinterJob;
import java.io.File;
import java.sql.Timestamp;
import java.util.logging.Level;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.engine.export.JRPrintServiceExporterParameter;
import org.compiere.process.ProcessInfo;
import org.compiere.report.JasperUtil;
import org.compiere.report.ReportStarter;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Ini;

public class JasperEngine
extends ReportStarter {
    private static final CLogger s_log = CLogger.getCLogger(JasperEngine.class);

    public void doReport(ReportProcess rp, MReportDet mReport, MReportDef mDefinition) throws Exception {
        ReportStarter.setReportHome(Env.getAD_Client_ID(rp.getCtx()), Env.getAD_Org_ID(rp.getCtx()));
        File fReportFile = mDefinition.getReportFile();
        ProcessInfo pi = rp.getProcessInfo();
        JasperPrint jasperPrint = JasperUtil.prepareReport(rp.getCtx(), fReportFile, pi, mDefinition.isReportFromAttachment(), rp.get_TrxName());
        if (jasperPrint != null) {
            if (rp.isDirectPrint()) {
                this.doPrint(jasperPrint);
            } else {
                ReportStarter.getReportViewerProvider().openViewer(jasperPrint, pi.getTitle());
            }
        } else {
            rp.addLog(0, new Timestamp(System.currentTimeMillis()), null, "Cannot process JasperPrint Object");
            s_log.log(Level.SEVERE, "JasperEngine.doReport:Cannot process JasperPrint Object");
        }
    }

    public File createPDF(ReportProcess rp, MReportDet mReport, MReportDef mDefinition) throws Exception {
        File fReportFile = mDefinition.getReportFile();
        ProcessInfo pi = rp.getProcessInfo();
        File fPDF = mReport.getDestFile(rp.getWindowNo(), rp.getTabNo(), "pdf");
        JasperPrint jasperPrint = JasperUtil.prepareReport(rp.getCtx(), fReportFile, pi, mDefinition.isReportFromAttachment(), rp.get_TrxName());
        if (jasperPrint != null) {
            JasperExportManager.exportReportToPdfFile((JasperPrint)jasperPrint, (String)fPDF.getAbsolutePath());
            return fPDF;
        }
        rp.addLog(0, new Timestamp(System.currentTimeMillis()), null, "Cannot process JasperPrint Object");
        s_log.log(Level.SEVERE, "JasperEngine.doReport:Cannot process JasperPrint Object");
        return null;
    }

    public File createHTML(ReportProcess rp, MReportDet mReport, MReportDef mDefinition) throws Exception {
        File fReportFile = mDefinition.getReportFile();
        ProcessInfo pi = rp.getProcessInfo();
        File fHTML = mReport.getDestFile(rp.getWindowNo(), rp.getTabNo(), "html");
        JasperPrint jasperPrint = JasperUtil.prepareReport(rp.getCtx(), fReportFile, pi, mDefinition.isReportFromAttachment(), rp.get_TrxName());
        if (jasperPrint != null) {
            JasperExportManager.exportReportToHtmlFile((JasperPrint)jasperPrint, (String)fHTML.getAbsolutePath());
            return fHTML;
        }
        rp.addLog(0, new Timestamp(System.currentTimeMillis()), null, "Cannot process JasperPrint Object");
        s_log.log(Level.SEVERE, "JasperEngine.doReport:Cannot process JasperPrint Object");
        return null;
    }

    protected void doPrint(JasperPrint print) throws Exception {
        PrinterJob job = PrinterJob.getPrinterJob();
        PrintService[] services = PrintServiceLookup.lookupPrintServices(null, null);
        PrintService selectedService = null;
        String sPrinter = Ini.getProperty("Printer");
        int i = 0;
        while (i < services.length) {
            if (services[i].getName().equals(sPrinter)) {
                selectedService = services[i];
                break;
            }
            ++i;
        }
        job.setPrintService(selectedService);
        HashPrintRequestAttributeSet printRequestAttributeSet = new HashPrintRequestAttributeSet();
        JRPrintServiceExporter exporter = new JRPrintServiceExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
        exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.PRINT_SERVICE, (Object)selectedService);
        exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.PRINT_SERVICE_ATTRIBUTE_SET, (Object)selectedService.getAttributes());
        exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.PRINT_REQUEST_ATTRIBUTE_SET, (Object)printRequestAttributeSet);
        exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.DISPLAY_PAGE_DIALOG, (Object)Boolean.FALSE);
        exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.DISPLAY_PRINT_DIALOG, (Object)Boolean.FALSE);
        exporter.exportReport();
    }
}

