/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.report;

import com.f3p.adempiere.F3PBaseDialog;
import com.f3p.adempiere.model.MReportDet;
import com.f3p.adempiere.report.MessageKeys;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MMailText;
import org.compiere.model.Query;
import org.compiere.model.X_R_MailText;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class SelectReports
extends F3PBaseDialog
implements MessageKeys {
    private static final long serialVersionUID = 1L;
    private MiniTable m_table = new MiniTable();
    private MReportDet[] m_details;
    private CLabel m_lblTesto = new CLabel();
    private boolean m_bIsMailUI;
    private Properties m_ctx;
    private List<MMailText> m_lstMailTemplates = null;
    private CComboBox m_cbMailTemplates = null;
    private MMailText m_mtSelected = null;

    public SelectReports(Frame owner, MReportDet[] details, boolean bIsMailUI, Properties ctx) throws HeadlessException {
        super(owner, bIsMailUI ? "F3P_Title_SelezionaMail" : "F3P_Title_SelezionaStampe");
        this.m_ctx = ctx;
        this.m_bIsMailUI = bIsMailUI;
        this.m_details = (MReportDet[])details.clone();
        if (this.m_bIsMailUI) {
            this.m_lstMailTemplates = this.getAvailableTemplates();
        }
        this.initControls();
    }

    @Override
    protected void initControls() {
        super.initControls();
        this.setResizable(false);
        this.m_table.setMultiSelection(true);
        this.m_table.addColumn("Selected");
        this.m_table.addColumn("desc");
        this.m_table.setColumnClass(0, IDColumn.class, false);
        this.m_table.setColumnClass(1, String.class, true);
        this.m_table.setRowCount(this.m_details.length);
        int i = 0;
        while (i < this.m_details.length) {
            this.m_table.setValueAt(new IDColumn(this.m_details[i].getF3P_ReportDet_ID()), i, 0);
            this.m_table.setValueAt(this.m_details[i].getNome(), i, 1);
            ++i;
        }
        CompiereColor.setBackground(this.m_lblTesto);
        this.m_lblTesto.setText(Msg.getMsg(this.m_ctx, this.m_bIsMailUI ? "F3P_EXTR_SelectReportsToMail" : "F3P_EXTR_SelectReportsToPrint"));
        this.m_lblTesto.setPreferredSize(new Dimension(400, 30));
        this.m_lblTesto.setHorizontalAlignment(2);
        if (this.m_bIsMailUI) {
            CPanel hdrPanel = new CPanel();
            GridBagConstraints contraints = new GridBagConstraints();
            contraints.anchor = 21;
            contraints.insets = new Insets(2, 2, 2, 2);
            hdrPanel.setLayout(new GridBagLayout());
            contraints.gridx = 0;
            contraints.gridy = 0;
            contraints.gridwidth = 2;
            hdrPanel.add((Component)this.m_lblTesto, contraints);
            Object[] npMailTemplates = new KeyNamePair[this.m_lstMailTemplates.size() + 1];
            int i2 = 0;
            npMailTemplates[i2++] = new KeyNamePair(-1, "");
            for (X_R_MailText x_R_MailText : this.m_lstMailTemplates) {
                npMailTemplates[i2++] = new KeyNamePair(x_R_MailText.getR_MailText_ID(), x_R_MailText.getName());
            }
            CLabel cLabel = new CLabel(Msg.translate(this.m_ctx, "F3P_EXTR_LBL_SelectMailText"));
            this.m_cbMailTemplates = new CComboBox(npMailTemplates);
            contraints.gridwidth = 1;
            contraints.gridx = 0;
            contraints.gridy = 1;
            hdrPanel.add((Component)cLabel, contraints);
            contraints.gridx = 1;
            contraints.gridy = 1;
            contraints.weightx = 1.0;
            contraints.weighty = 1.0;
            hdrPanel.add((Component)this.m_cbMailTemplates, contraints);
            this.add((Component)hdrPanel, "North");
        } else {
            this.add((Component)this.m_lblTesto, "North");
        }
        this.add((Component)this.m_table, "Center");
        this.m_table.autoSize();
    }

    protected List<MMailText> getAvailableTemplates() {
        Query query = new Query(this.m_ctx, "R_MailText", "", null);
        return query.setApplyAccessFilter(true).setOnlyActiveRecords(true).list();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("Cancel")) {
            this.setCanceled(true);
            this.dispose();
        }
        if (event.getActionCommand().equals("Ok")) {
            KeyNamePair nkSel;
            if (this.m_cbMailTemplates != null && (nkSel = (KeyNamePair)this.m_cbMailTemplates.getSelectedItem()) != null && nkSel.getKey() > 0) {
                int iKey = nkSel.getKey();
                for (MMailText mailText : this.m_lstMailTemplates) {
                    if (mailText.getR_MailText_ID() != iKey) continue;
                    this.m_mtSelected = mailText;
                    break;
                }
            }
            this.setCanceled(false);
            this.dispose();
        }
    }

    public LinkedList<Integer> getIDs() {
        LinkedList<Integer> output = new LinkedList<Integer>();
        int i = 0;
        while (i < this.m_details.length) {
            IDColumn col = (IDColumn)this.m_table.getValueAt(i, 0);
            if (col.isSelected()) {
                output.add(col.getRecord_ID());
            }
            ++i;
        }
        return output;
    }

    public MMailText getSelectedMailText() {
        return this.m_mtSelected;
    }
}

