/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.report;

import com.f3p.adempiere.dataprovider.EnvParamProvider;
import com.f3p.adempiere.model.MReportDef;
import com.f3p.adempiere.model.MReportDet;
import com.f3p.adempiere.model.MReportInt;
import com.f3p.adempiere.report.ParamKeys;
import com.f3p.adempiere.report.engine.JasperEngine;
import com.f3p.adempiere.report.engine.OOEngine;
import com.f3p.adempiere.util.EnvHelper;
import com.f3p.adempiere.util.QueryRepo;
import com.f3p.commons.Utils;
import com.f3p.dataprovider.DataProviderConnection;
import com.f3p.dataprovider.DataProviderException;
import com.f3p.dataprovider.ParamProvider;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MProcess;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ReportProcess
extends SvrProcess
implements ParamKeys {
    private static CLogger s_log = CLogger.getCLogger(ReportProcess.class);
    protected MReportDet[] m_rdetail = null;
    protected MReportInt m_rint = null;
    private int m_WindowNo = -1;
    private int m_TabNo = -1;
    private int m_iDefReportDetailID = -1;
    private EnvParamProvider m_pprovider = null;
    private boolean m_bIsDirectPrint;
    private String m_sTagFilter = null;
    protected String m_sReportKey = null;
    protected boolean m_bGeneratedEnv = false;
    protected boolean m_bFirstOnly = true;
    protected String m_sTrx = null;
    protected SvrProcess m_parentProcess = null;

    public MReportInt getReportInt() {
        return this.getReportInt(this.getProcessInfo().getAD_Process_ID());
    }

    public MReportInt getReportInt(int AD_Process_ID) {
        if (this.m_rint == null) {
            this.m_rint = MReportInt.getFromProcess(AD_Process_ID, this.get_TrxName());
        }
        return this.m_rint;
    }

    protected int getStdParams() {
        if (this.m_WindowNo > 0) {
            return this.m_iDefReportDetailID;
        }
        this.m_iDefReportDetailID = -1;
        if (this.m_pprovider == null) {
            this.m_pprovider = new ProcessParamProvider();
        }
        try {
            String sWindowNo = this.m_pprovider.getParam("F3P_Param_WindowNo", null).toString();
            this.m_WindowNo = sWindowNo.length() == 0 ? 0 : Integer.parseInt(sWindowNo);
            if (this.m_WindowNo == 0) {
                this.m_TabNo = 0;
                this.m_WindowNo = Env.createWindowNo(null);
                this.m_bGeneratedEnv = true;
            } else {
                String sTabNo = this.m_pprovider.getParam("F3P_Param_TabNo", null).toString();
                this.m_TabNo = sTabNo.length() == 0 ? 0 : Integer.parseInt(sTabNo);
            }
            String sReportDetail = (String)this.m_pprovider.getParam("F3P_Param_ReportDetail", null);
            if (sReportDetail != null && sReportDetail.length() > 0) {
                this.m_iDefReportDetailID = Integer.parseInt(sReportDetail.toString());
            }
        }
        catch (DataProviderException e) {
            s_log.log(Level.SEVERE, "ReportProcess.prepare", e);
        }
        this.m_pprovider.setWindowAndTab(this.m_WindowNo, this.m_TabNo);
        return this.m_iDefReportDetailID;
    }

    public int getWindowNo() {
        return this.m_WindowNo;
    }

    public int getTabNo() {
        return this.m_TabNo;
    }

    public void setWindowAndTab(int iWindowNo, int iTabNo) {
        this.m_WindowNo = iWindowNo;
        this.m_TabNo = iTabNo;
    }

    @Override
    public void prepare() {
        this.prepareReport(this.getCtx(), this.getProcessInfo().getAD_Process_ID());
    }

    public void prepareFromTab(int AD_Tab_ID, int Record_ID, String sTrx) {
        int AD_Table_ID;
        int AD_Process_ID;
        block7: {
            String sSQL = "SELECT AD_Table_ID,AD_Process_ID from AD_Tab where AD_Tab_ID = ?";
            AD_Process_ID = -1;
            AD_Table_ID = -1;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sSQL, null);
                    pstmt.setInt(1, AD_Tab_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        AD_Process_ID = rs.getInt("AD_Process_ID");
                        AD_Table_ID = rs.getInt("AD_Table_ID");
                    }
                    rs.close();
                    pstmt.close();
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, "ReportProcess.prepareFromTab", e);
                    DB.close(rs, pstmt);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
        }
        if (AD_Process_ID > 0) {
            ProcessInfo pi = new ProcessInfo("", AD_Process_ID, AD_Table_ID, Record_ID);
            pi.setAD_PInstance_ID(-1);
            this.changeProcessInfo(pi, Env.getCtx());
            this.prepare();
        }
    }

    public void prepareReport(Properties ctx, int AD_Process_ID) {
        int iReportDetailID = -1;
        this.m_rint = this.getReportInt();
        iReportDetailID = this.getStdParams();
        if (this.m_rint != null) {
            this.m_rdetail = null;
            if (iReportDetailID > 0) {
                this.m_rdetail = new MReportDet[1];
                this.m_rdetail[0] = new MReportDet(ctx, iReportDetailID, null);
            } else {
                this.m_rdetail = this.m_rint.getDetails("R", this.m_WindowNo, this.m_TabNo, this.m_sTagFilter, this.m_bFirstOnly, this.isGeneratedEnv());
            }
        }
        MProcess mp = MProcess.get(ctx, AD_Process_ID);
        String sIsMultiPrint = null;
        try {
            sIsMultiPrint = (String)this.m_pprovider.getParam("F3P_Param_ForceDirectPrint", null);
        }
        catch (DataProviderException e) {
            s_log.log(Level.SEVERE, "", e);
        }
        if (sIsMultiPrint != null) {
            if (sIsMultiPrint.equals("Y")) {
                this.m_bIsDirectPrint = true;
            }
        } else {
            this.m_bIsDirectPrint = mp.isDirectPrint();
        }
    }

    public void getReportDetails() {
    }

    @Override
    protected String doIt() throws Exception {
        String sOut = null;
        try {
            sOut = this.doPrint();
        }
        finally {
            if (this.m_bGeneratedEnv) {
                Env.clearWinContext(this.m_WindowNo);
            }
        }
        return sOut;
    }

    public String doPrint() throws SQLException {
        String sRet = "";
        if (this.m_rdetail != null) {
            MReportDet[] mReportDetArray = this.m_rdetail;
            int n = this.m_rdetail.length;
            int n2 = 0;
            while (n2 < n) {
                MReportDet rdet = mReportDetArray[n2];
                MReportDef def = rdet.getDefinition();
                if (def != null) {
                    try {
                        if (def.getMotore().equals("O")) {
                            OOEngine ooe = new OOEngine();
                            ooe.doReport(this, rdet, def);
                        } else if (def.getMotore().equals("J")) {
                            JasperEngine je = new JasperEngine();
                            je.doReport(this, rdet, def);
                        }
                    }
                    catch (Exception e) {
                        s_log.log(Level.SEVERE, "ReportProcess.doIt", e);
                        sRet = e.getLocalizedMessage();
                    }
                }
                ++n2;
            }
        } else {
            sRet = "ReportProcesNoReport";
        }
        return sRet;
    }

    public ParamProvider getParamProvider() {
        if (this.m_pprovider == null) {
            this.getStdParams();
        }
        return this.m_pprovider;
    }

    public int getDetailsCount() {
        if (this.m_rdetail != null) {
            return this.m_rdetail.length;
        }
        return 0;
    }

    public boolean isDirectPrint() {
        return this.m_bIsDirectPrint;
    }

    public void setDirectPrint(boolean bDirect) {
        this.m_bIsDirectPrint = bDirect;
    }

    public boolean isGeneratedEnv() {
        return this.m_bGeneratedEnv;
    }

    public String getTagFilter() {
        return this.m_sTagFilter;
    }

    public void setTagFilter(String tagFilter) {
        this.m_sTagFilter = tagFilter;
    }

    public void setReportKeyName(String sName) {
        this.m_sReportKey = sName;
    }

    public String getReportKeyName() {
        return this.m_sReportKey;
    }

    public void pushEnvRawSql(String sSQL, boolean bAddUser) {
        CPreparedStatement pstmt = DB.prepareStatement(sSQL, this.get_TrxName());
        ResultSet rs = null;
        try {
            pstmt.setInt(1, this.getRecord_ID());
            if (bAddUser) {
                pstmt.setInt(2, Env.getAD_User_ID(this.getCtx()));
            }
            rs = pstmt.executeQuery();
            EnvHelper.pushEnv(rs, this.getWindowNo(), this.getTabNo(), Env.getCtx());
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, "MailOfferta.pushEnv", e);
        }
    }

    public void pushEnv(String sQueryName, boolean bAddUser) {
        this.pushEnvRawSql(QueryRepo.getQuery(sQueryName), bAddUser);
    }

    public void setFirstOnly(boolean bFirst) {
        this.m_bFirstOnly = bFirst;
    }

    public boolean isFirstOnly() {
        return this.m_bFirstOnly;
    }

    public static boolean hasReportProcess(Properties ctx, int AD_Tab_ID, String sTrx) {
        MProcess process;
        boolean bRet = false;
        int AD_Process_ID = DB.getSQLValue(sTrx, "SELECT AD_Process_ID from AD_Tab where AD_Tab_ID = ?", AD_Tab_ID);
        if (AD_Process_ID > 0 && (process = MProcess.get(ctx, AD_Process_ID)) != null && !Utils.isEmptyString(process.getClassname())) {
            try {
                Class<?> clazz = Class.forName(process.getClassname());
                if (ReportProcess.class.isAssignableFrom(clazz)) {
                    bRet = true;
                }
            }
            catch (ClassNotFoundException e) {
                s_log.warning(e.getLocalizedMessage());
                bRet = false;
            }
        }
        return bRet;
    }

    public void setParentProcess(SvrProcess process) {
        this.m_parentProcess = process;
    }

    @Override
    public void addLog(String msg) {
        if (this.m_parentProcess != null) {
            this.m_parentProcess.addLog(msg);
        } else {
            super.addLog(msg);
        }
    }

    @Override
    public void addLog(int id, Timestamp date, BigDecimal number, String msg) {
        if (this.m_parentProcess != null) {
            this.m_parentProcess.addLog(id, date, number, msg);
        } else {
            super.addLog(id, date, number, msg);
        }
    }

    class ProcessParamProvider
    extends EnvParamProvider {
        ProcessParamProvider() {
        }

        @Override
        public Object getParam(String sName, DataProviderConnection dpc) throws DataProviderException {
            Object sRet = null;
            if (sName.equals(ReportProcess.this.getReportKeyName())) {
                return ReportProcess.this.getRecord_ID();
            }
            if (ReportProcess.this.getProcessInfo() != null) {
                ProcessInfoParameter[] params = ReportProcess.this.getParameter();
                int i = 0;
                while (i < params.length) {
                    ProcessInfoParameter param = params[i];
                    if (param.getParameterName().equals(sName)) {
                        sRet = param.getParameter().toString();
                        break;
                    }
                    ++i;
                }
            }
            if (sRet != null) {
                return sRet;
            }
            sRet = super.getParam(sName, dpc);
            if (sRet == null) {
                return super.getParam(sName.toUpperCase(), dpc);
            }
            return sRet;
        }
    }
}

