/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.report;

import com.f3p.adempiere.model.MReportDef;
import com.f3p.adempiere.model.MReportDet;
import com.f3p.adempiere.model.MReportInt;
import com.f3p.adempiere.model.X_F3P_ReportDef;
import com.f3p.adempiere.util.FieldHelper;
import com.f3p.adempiere.util.IDResolver;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JFileChooser;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.Adempiere;
import org.compiere.apps.ADialog;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.ConfirmPanel;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VEditorFactory;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MAttachment;
import org.compiere.swing.CButton;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class NewReportDetailDialog
extends CDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static CLogger s_log = CLogger.getCLogger(NewReportDetailDialog.class);
    private CPanel m_panelControls = null;
    private CPanel m_panelChecks = null;
    private ConfirmPanel m_confirmPanel = null;
    private CLabel m_lblNome = null;
    private CLabel m_lblCampo = null;
    private CLabel m_lblValore = null;
    private CLabel m_lblFile = null;
    private CLabel m_lblTag = null;
    private CLabel m_lblDefinition = null;
    private CTextField m_txtNome = null;
    private CTextField m_txtFile = null;
    private CCheckBox m_ckReport = null;
    private CCheckBox m_ckAllegato = null;
    private VLookup m_vReportDef = null;
    private VEditor m_vValore = null;
    private ALayoutConstraint m_alContraint = null;
    private CComboBox m_cbCampo = null;
    private CComboBox m_cbTag = null;
    private CButton m_btnChooseFile = null;
    private GridTab m_tab;
    private GridField[] m_fields;
    private MReportInt m_reportInt;

    public NewReportDetailDialog(GridTab tab, MReportInt rint) {
        this.m_tab = tab;
        this.m_fields = this.m_tab.getFields();
        this.m_reportInt = rint;
        this.initControls();
        this.initData();
    }

    protected void initControls() {
        Container panelContent = this.getContentPane();
        this.m_confirmPanel = new ConfirmPanel(true);
        panelContent.add((Component)this.m_confirmPanel, "South");
        this.m_confirmPanel.addActionListener(this);
        this.m_panelControls = new CPanel();
        this.m_panelControls.setLayout(new ALayout());
        this.m_panelControls.setPreferredSize(new Dimension(400, 180));
        panelContent.add((Component)this.m_panelControls, "Center");
        this.m_panelChecks = new CPanel();
        this.m_panelChecks.setLayout(new FlowLayout(0));
        Properties ctx = Env.getCtx();
        this.m_lblNome = new CLabel(Msg.translate(ctx, "Name"));
        this.m_lblCampo = new CLabel(Msg.translate(ctx, "ColumnName"));
        this.m_lblValore = new CLabel(Msg.translate(ctx, "ColumnValue"));
        this.m_lblFile = new CLabel(Msg.getMsg(ctx, "F3P_Lbl_File"));
        this.m_lblTag = new CLabel(Msg.getMsg(ctx, "F3P_Lbl_Tag"));
        this.m_lblDefinition = new CLabel(Msg.getMsg(ctx, "F3P_Lbl_Definition"));
        this.m_txtFile = new CTextField(20);
        this.m_txtFile.setBackground(AdempierePLAF.getFieldBackground_Mandatory());
        this.m_txtNome = new CTextField(20);
        this.m_txtNome.setBackground(AdempierePLAF.getFieldBackground_Mandatory());
        int idReportDefCol = IDResolver.getAD_Column_ID("F3P_ReportDet", "F3P_ReportDef_ID");
        this.m_vReportDef = FieldHelper.getTableLookup(0, idReportDefCol, "F3P_ReportDef_ID");
        this.m_cbCampo = new CComboBox();
        this.m_cbCampo.addActionListener(this);
        this.m_btnChooseFile = new CButton("...");
        this.m_cbTag = new CComboBox();
        this.m_cbTag.setEditable(true);
        this.m_ckReport = new CCheckBox(Msg.getMsg(ctx, "F3P_Lbl_Report"));
        this.m_ckAllegato = new CCheckBox(Msg.getMsg(ctx, "F3P_Lbl_Allegato"));
        this.m_panelChecks.add(this.m_ckReport);
        this.m_panelChecks.add(this.m_ckAllegato);
        this.m_ckReport.setSelected(true);
        int iRow = 0;
        this.m_panelControls.add((Component)this.m_lblNome, new ALayoutConstraint(iRow++, 0));
        this.m_panelControls.add((Component)this.m_txtNome, null);
        this.m_panelControls.add((Component)this.m_lblCampo, new ALayoutConstraint(iRow++, 0));
        this.m_panelControls.add((Component)this.m_cbCampo, null);
        this.m_panelControls.add((Component)this.m_lblValore, new ALayoutConstraint(iRow, 0));
        this.m_alContraint = new ALayoutConstraint(iRow++, 1);
        this.m_panelControls.add((Component)this.m_lblTag, new ALayoutConstraint(iRow++, 0));
        this.m_panelControls.add((Component)this.m_cbTag, null);
        this.m_panelControls.add((Component)this.m_lblDefinition, new ALayoutConstraint(iRow++, 0));
        this.m_panelControls.add((Component)this.m_vReportDef, null);
        this.m_panelControls.add((Component)this.m_lblFile, new ALayoutConstraint(iRow++, 0));
        this.m_panelControls.add((Component)this.m_txtFile, null);
        this.m_panelControls.add((Component)this.m_btnChooseFile, null);
        this.m_panelControls.add((Component)this.m_panelChecks, new ALayoutConstraint(iRow++, 1));
        this.m_btnChooseFile.addActionListener(this);
        this.setTitle(Msg.getMsg(ctx, "F3P_Title_NewReportDetailDialog"));
    }

    protected void initData() {
        KeyNamePair keyField = null;
        int i = 0;
        while (i < this.m_fields.length) {
            GridField field = this.m_fields[i];
            if (field.isDisplayed(true) || field.isKey()) {
                KeyNamePair knp = new KeyNamePair(i, this.m_fields[i].getHeader());
                this.m_cbCampo.addItem(knp);
                if (field.isKey()) {
                    keyField = knp;
                }
            }
            ++i;
        }
        try {
            CPreparedStatement pstmt = DB.prepareStatement("SELECT DISTINCT TAG FROM F3P_ReportDet WHERE F3P_ReportInt_ID = ?", null);
            pstmt.setInt(1, this.m_reportInt.getF3P_ReportInt_ID());
            ResultSet rs = pstmt.executeQuery();
            HashSet<String> setTags = new HashSet<String>();
            while (rs.next()) {
                String sTag = rs.getString("TAG");
                Collection<String> cTags = MReportInt.splitTag(sTag);
                for (String tag : cTags) {
                    setTags.add(tag);
                }
            }
            rs.close();
            pstmt.close();
            for (String sTag : setTags) {
                this.m_cbTag.addItem(sTag);
            }
            this.m_cbTag.setSelectedItem(null);
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, "NewReportDetailDialog.initData", e);
        }
        this.m_cbCampo.setSelectedItem(keyField);
    }

    protected boolean createReportDetail() {
        int F3P_ReportDef_ID;
        KeyNamePair knp = (KeyNamePair)this.m_cbCampo.getSelectedItem();
        Object obVal = this.m_vValore.getValue();
        String sValore = obVal != null ? obVal.toString() : "";
        String sNome = this.m_txtNome.getText();
        String sFile = this.m_txtFile.getText();
        String sField = this.m_fields[knp.getKey()].getColumnName();
        String sTag = (String)this.m_cbTag.getSelectedItem();
        File fAllegato = null;
        Number nReportDef = (Number)this.m_vReportDef.getValue();
        int n = F3P_ReportDef_ID = nReportDef != null ? nReportDef.intValue() : -1;
        if (this.m_vValore instanceof VCheckBox) {
            Boolean bVal = (Boolean)obVal;
            sValore = bVal != false ? "Y" : "N";
        }
        if (sValore == null || sValore.length() == 0) {
            ADialog.error(0, this, "F3P_Error_Value");
            return false;
        }
        if (sNome == null || sNome.length() == 0) {
            ADialog.error(0, this, "F3P_Error_Name");
            return false;
        }
        if (F3P_ReportDef_ID < 0) {
            if (sFile == null || sNome.length() == 0) {
                ADialog.error(0, this, "F3P_Error_File");
                return false;
            }
            fAllegato = new File(sFile);
            if (!fAllegato.exists()) {
                ADialog.error(0, this, "F3P_Error_File");
                return false;
            }
        }
        boolean bRes = true;
        String sTrx = Trx.createTrxName();
        try {
            try {
                if (this.m_ckReport.isSelected() && (F3P_ReportDef_ID = this.createReportDetail(sTrx, "R", sNome, sField, sValore, this.m_vValore.getDisplay(), sTag, fAllegato, F3P_ReportDef_ID)) < 0) {
                    bRes = false;
                }
                if (bRes && this.m_ckAllegato.isSelected()) {
                    bRes = this.createReportDetail(sTrx, "A", sNome, sField, sValore, this.m_vValore.getDisplay(), sTag, fAllegato, F3P_ReportDef_ID) > 0;
                }
            }
            catch (Exception e) {
                bRes = false;
                s_log.log(Level.SEVERE, "NewReportDetailDialog.createReportDetail", e);
                try {
                    if (bRes) {
                        DB.commit(true, sTrx);
                    } else {
                        DB.rollback(true, sTrx);
                    }
                }
                catch (SQLException ex) {
                    s_log.log(Level.INFO, "NewReportDetailDialog.createReportDetail", ex);
                }
            }
        }
        finally {
            try {
                if (bRes) {
                    DB.commit(true, sTrx);
                } else {
                    DB.rollback(true, sTrx);
                }
            }
            catch (SQLException ex) {
                s_log.log(Level.INFO, "NewReportDetailDialog.createReportDetail", ex);
            }
        }
        return bRes;
    }

    protected MReportDef createReportDefinition(String sTrx, File fAllegato) {
        MReportDef newReportDef = new MReportDef(Env.getCtx(), 0, sTrx);
        String sLowFile = fAllegato.getName().toLowerCase();
        newReportDef.setNome(sLowFile);
        if (sLowFile.endsWith(".odt")) {
            newReportDef.setMotore("O");
        } else if (sLowFile.endsWith(".jasper")) {
            newReportDef.setMotore("J");
        } else {
            ADialog.error(0, this, "F3P_Error_FileNonRiconosciuto");
            return null;
        }
        if (!newReportDef.save(sTrx)) {
            ADialog.error(0, this, "F3P_Error_Save");
            return null;
        }
        MAttachment attachment = newReportDef.getAttachment();
        if (attachment == null && !(attachment = new MAttachment(Env.getCtx(), X_F3P_ReportDef.Table_ID, newReportDef.get_ID(), sTrx)).save()) {
            ADialog.error(0, this, "F3P_Error_Save_Attachment");
            return null;
        }
        if (!attachment.addEntry(fAllegato)) {
            ADialog.error(0, this, "F3P_Error_Save_Attachment");
            return null;
        }
        attachment.setTextMsg(fAllegato.getName());
        if (attachment.save()) {
            return newReportDef;
        }
        return null;
    }

    protected int createReportDetail(String sTrx, String sType, String sNome, String sField, String sValore, String sLabel, String sTag, File fAllegato, int F3P_ReportDef_ID) {
        int iNextSeqNo = DB.getSQLValue(sTrx, "SELECT (NVL(MAX(SeqNo),0) + 10) FROM F3P_ReportDet WHERE F3P_ReportInt_ID = " + this.m_reportInt.get_ID());
        MReportDet newReportDet = new MReportDet(Env.getCtx(), 0, sTrx);
        newReportDet.setF3P_ReportInt_ID(this.m_reportInt.get_ID());
        newReportDet.setNome(sNome);
        newReportDet.setColumnName(sField);
        newReportDet.setColumnValue(sValore);
        newReportDet.setValueLabel(sLabel);
        newReportDet.setTag(sTag);
        newReportDet.setTipo(sType);
        newReportDet.setSeqNo(iNextSeqNo);
        if (F3P_ReportDef_ID > 0) {
            MReportDef mDef = new MReportDef(Env.getCtx(), F3P_ReportDef_ID, sTrx);
            newReportDet.setF3P_ReportDef_ID(mDef.getF3P_ReportDef_ID());
            if (sType.equals("A")) {
                newReportDet.setAllegato(mDef.getNome());
            }
        } else {
            MReportDef newReportDef = this.createReportDefinition(sTrx, fAllegato);
            if (newReportDef == null) {
                ADialog.error(0, this, "F3P_Error_Save");
                return -1;
            }
            F3P_ReportDef_ID = newReportDef.getF3P_ReportDef_ID();
            newReportDet.setF3P_ReportDef_ID(newReportDef.getF3P_ReportDef_ID());
            if (sType.equals("A")) {
                newReportDet.setAllegato(fAllegato.getName());
            }
        }
        if (!newReportDet.save(sTrx)) {
            ADialog.error(0, this, "F3P_Error_Save");
            return -1;
        }
        return F3P_ReportDef_ID;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals("Ok")) {
            if (this.createReportDetail()) {
                this.dispose();
            }
        } else if (cmd.equals("Cancel")) {
            this.dispose();
        } else if (event.getSource() == this.m_btnChooseFile) {
            JFileChooser fileChooser = new JFileChooser(Adempiere.getAdempiereHome());
            if (fileChooser.showOpenDialog(this) == 0) {
                this.m_txtFile.setValue(fileChooser.getSelectedFile().getAbsoluteFile());
            }
        } else if (event.getSource() == this.m_cbCampo) {
            if (this.m_vValore != null) {
                this.m_panelControls.remove((Component)((Object)this.m_vValore));
            }
            KeyNamePair knp = (KeyNamePair)this.m_cbCampo.getSelectedItem();
            this.m_vValore = VEditorFactory.getEditor(this.m_fields[knp.getKey()], false);
            this.m_vValore.setReadWrite(false);
            this.m_vValore.setValue(this.m_fields[knp.getKey()].getValue());
            this.m_panelControls.add((Component)((Object)this.m_vValore), this.m_alContraint);
            this.pack();
        }
    }
}

