/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.report;

import com.f3p.adempiere.file.FileBuilder;
import com.f3p.adempiere.mail.OutboundMailClient;
import com.f3p.adempiere.mail.OutboundMailClientEngine;
import com.f3p.adempiere.model.MReportDet;
import com.f3p.adempiere.model.MReportInt;
import com.f3p.adempiere.report.MessageKeys;
import com.f3p.adempiere.report.NewReportDetailDialog;
import com.f3p.adempiere.report.ParamKeys;
import com.f3p.adempiere.report.ReportProcess;
import com.f3p.adempiere.report.SelectReports;
import com.f3p.adempiere.util.ProcessHelper;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.model.GridTab;
import org.compiere.model.MProcess;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.ASyncProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class AReportsForWindow
implements ActionListener,
ParamKeys,
MessageKeys {
    private JPopupMenu m_popup = new JPopupMenu("ReporstForWindowMenu");
    private GridTab m_tab;
    private Properties m_ctx;
    private ReportProcess m_report;
    private MReportDet[] m_details;
    private String m_sAddNew;
    private String m_sZoom;
    private JComponent m_invoker;
    private ProcessInfo m_processInfo;
    private ASyncProcess m_asyncProcess;
    private MReportInt m_reportInt;
    private String m_sSelectReportsMail;
    private String m_sSelectReports;

    public AReportsForWindow(JComponent invoker, GridTab tab, ProcessInfo pi, ASyncProcess ap) {
        this.m_tab = tab;
        this.m_ctx = Env.getCtx();
        this.m_invoker = invoker;
        this.m_processInfo = pi;
        this.m_asyncProcess = ap;
        this.m_sAddNew = Msg.getMsg(this.m_ctx, "F3P_NewReport");
        this.m_sZoom = Msg.getMsg(this.m_ctx, "F3P_OpenReportInt");
        this.m_sSelectReports = Msg.getMsg(this.m_ctx, "F3P_Title_SelezionaStampe");
        this.m_sSelectReportsMail = Msg.getMsg(this.m_ctx, "F3P_Title_SelezionaMail");
    }

    public boolean loadReports() {
        Object oreport;
        int AD_Process_ID;
        block5: {
            AD_Process_ID = this.m_tab.getAD_Process_ID();
            if (AD_Process_ID <= 0) {
                return false;
            }
            MProcess process = MProcess.get(this.m_ctx, AD_Process_ID);
            try {
                oreport = Class.forName(process.getClassname()).newInstance();
                if (oreport instanceof ReportProcess) break block5;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        this.m_report = (ReportProcess)oreport;
        this.m_report.changeProcessInfo(this.m_processInfo, this.m_ctx);
        this.m_reportInt = this.m_report.getReportInt(AD_Process_ID);
        this.m_details = this.m_reportInt.getDetails("R", this.m_tab.getWindowNo(), this.m_tab.getTabNo(), null, false);
        ImageIcon iconReport = Env.getImageIcon("Print16.gif");
        ImageIcon iconMail = Env.getImageIcon("SendMail16.gif");
        int i = 0;
        while (i < this.m_details.length) {
            JMenuItem mi = this.m_popup.add(this.m_details[i].getNome());
            mi.addActionListener(this);
            mi.setIcon(iconReport);
            ++i;
        }
        this.m_popup.addSeparator();
        JMenuItem sel = this.m_popup.add(this.m_sSelectReports);
        sel.addActionListener(this);
        sel.setIcon(iconReport);
        JMenuItem selMail = this.m_popup.add(this.m_sSelectReportsMail);
        selMail.addActionListener(this);
        selMail.setIcon(iconMail);
        JMenuItem aNew = this.m_popup.add(this.m_sAddNew);
        aNew.addActionListener(this);
        aNew.setIcon(Env.getImageIcon("New16.gif"));
        JMenuItem aZoom = this.m_popup.add(this.m_sZoom);
        aZoom.addActionListener(this);
        aZoom.setIcon(Env.getImageIcon("Zoom16.gif"));
        return true;
    }

    public void show() {
        if (this.m_invoker.isShowing()) {
            this.m_popup.show(this.m_invoker, 0, this.m_invoker.getHeight());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        block28: {
            sAction = event.getActionCommand();
            if (sAction.equals(this.m_sAddNew)) {
                nrDialog = new NewReportDetailDialog(this.m_tab, this.m_reportInt);
                AEnv.showCenterScreen(nrDialog);
            } else if (sAction.equals(this.m_sZoom)) {
                AEnv.zoom(this.m_reportInt.get_Table_ID(), this.m_reportInt.get_ID());
            } else if (sAction.equals(this.m_sSelectReports)) {
                parent = Env.getWindow(this.m_tab.getWindowNo());
                sel = new SelectReports((Frame)parent, this.m_details, false, this.m_ctx);
                sel.setModal(true);
                AEnv.showCenterScreen(sel);
                if (!sel.isCanceled()) {
                    out = sel.getIDs();
                    var7_12 = out.iterator();
                    while (var7_12.hasNext()) {
                        ID = (Integer)var7_12.next();
                        this.printReport(ID, true);
                    }
                }
            } else if (sAction.equals(this.m_sSelectReportsMail)) {
                parent = Env.getWindow(this.m_tab.getWindowNo());
                sel = new SelectReports((Frame)parent, this.m_details, true, this.m_ctx);
                sel.setModal(true);
                AEnv.showCenterScreen(sel);
                if (!sel.isCanceled()) {
                    block27: {
                        block29: {
                            fAttachments = null;
                            try {
                                try {
                                    lSelectedIDS = sel.getIDs();
                                    mSelMailText = sel.getSelectedMailText();
                                    bIsHtml = false;
                                    fAttachments = this.convertToPDF(lSelectedIDS);
                                    from = MUser.get(Env.getCtx(), Env.getAD_User_ID(Env.getCtx()));
                                    to = "";
                                    message = null;
                                    sSubject = null;
                                    if (mSelMailText == null) {
                                        message = "";
                                        sSubject = "";
                                    } else {
                                        sTableName = this.m_tab.getTableName();
                                        qPO = new Query(this.m_ctx, sTableName, String.valueOf(sTableName) + "_ID = " + this.m_tab.getKeyID(this.m_tab.getCurrentRow()), null);
                                        mSelMailText.setPO((PO)qPO.first(), true);
                                        sSubject = mSelMailText.getMailHeader();
                                        message = mSelMailText.getMailText(true);
                                        bIsHtml = mSelMailText.isHtml();
                                    }
                                    OutboundMailClientEngine.get().sendMail(parent, Msg.getMsg(Env.getCtx(), "SendMail"), from, to, sSubject, message, bIsHtml, fAttachments, this.m_tab.getWindowNo(), this.m_tab.getTabNo(), OutboundMailClient.ClientType.Desktop);
                                    break block27;
                                }
                                catch (Exception e) {
                                    ADialog.error(this.m_tab.getWindowNo(), Env.getWindow(this.m_tab.getWindowNo()), e.getLocalizedMessage());
                                    if (fAttachments == null) break block28;
                                    var19_24 = fAttachments;
                                    var18_27 = fAttachments.length;
                                    var17_30 = 0;
                                    ** while (var17_30 < var18_27)
                                }
                            }
                            catch (Throwable var15_36) {
                                if (fAttachments == null) break block29;
                                var19_25 = fAttachments;
                                var18_28 = fAttachments.length;
                                var17_31 = 0;
                                ** while (var17_31 < var18_28)
                            }
lbl-1000:
                            // 1 sources

                            {
                                fAtt = var19_24[var17_30];
                                if (!fAtt.delete()) {
                                    fAtt.deleteOnExit();
                                }
                                ++var17_30;
                                continue;
lbl63:
                                // 1 sources

                                break block28;
                            }
lbl-1000:
                            // 1 sources

                            {
                                fAtt = var19_25[var17_31];
                                if (!fAtt.delete()) {
                                    fAtt.deleteOnExit();
                                }
                                ++var17_31;
                                continue;
                            }
                        }
                        throw var15_36;
                    }
                    if (fAttachments != null) {
                        var19_26 = fAttachments;
                        var18_29 = fAttachments.length;
                        var17_32 = 0;
                        while (var17_32 < var18_29) {
                            fAtt = var19_26[var17_32];
                            if (!fAtt.delete()) {
                                fAtt.deleteOnExit();
                            }
                            ++var17_32;
                        }
                    }
                }
            } else {
                mrt = null;
                i = 0;
                while (i < this.m_details.length) {
                    if (this.m_details[i].getNome().equals(sAction)) {
                        mrt = this.m_details[i];
                        break;
                    }
                    ++i;
                }
                if (mrt != null) {
                    this.printReport(mrt.getF3P_ReportDet_ID(), false);
                }
            }
        }
    }

    public void printReport(int mrtID, boolean stampaMultipla) {
        Hashtable<String, Object> params = new Hashtable<String, Object>(4, 1.0f);
        params.put("F3P_Param_WindowNo", this.m_tab.getWindowNo());
        params.put("F3P_Param_TabNo", this.m_tab.getTabNo());
        params.put("F3P_Param_ReportDetail", mrtID);
        if (stampaMultipla) {
            params.put("F3P_Param_ForceDirectPrint", "Y");
        } else {
            params.put("F3P_Param_ForceDirectPrint", "N");
        }
        ProcessInfo procInf = new ProcessInfo(this.m_processInfo.getTitle(), this.m_processInfo.getAD_Process_ID(), this.m_processInfo.getTable_ID(), this.m_processInfo.getRecord_ID());
        ProcessHelper.startProcess(this.m_asyncProcess, procInf, null, this.m_tab.getWindowNo(), params);
    }

    public File[] convertToPDF(Collection<Integer> cIDs) throws Exception {
        this.m_asyncProcess.lockUI(this.m_processInfo);
        ArrayList<File> lstFiles = new ArrayList<File>();
        String sTrx = Trx.createTrxName();
        this.m_report.setTrx(Trx.get(sTrx, false));
        try {
            FileBuilder fileBuilder = new FileBuilder(this.m_report, this.m_processInfo);
            this.m_report.setWindowAndTab(this.m_tab.getWindowNo(), this.m_tab.getTabNo());
            MReportDet[] mReportDetArray = this.m_details;
            int n = this.m_details.length;
            int n2 = 0;
            while (n2 < n) {
                File fAtt;
                MReportDet mRPD = mReportDetArray[n2];
                if (cIDs.contains(mRPD.getF3P_ReportDet_ID()) && (fAtt = fileBuilder.getAsPDF(mRPD, this.m_ctx, this.m_tab.getWindowNo(), this.m_tab.getTabNo())) != null) {
                    lstFiles.add(fAtt);
                }
                ++n2;
            }
        }
        finally {
            this.m_asyncProcess.unlockUI(this.m_processInfo);
        }
        this.m_report.setTrx(null);
        return lstFiles.toArray(new File[lstFiles.size()]);
    }
}

