/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.process;

import com.f3p.adempiere.file.FileBuilder;
import com.f3p.adempiere.mail.MailBuilder;
import com.f3p.adempiere.model.MReportDet;
import com.f3p.adempiere.model.MReportInt;
import com.f3p.adempiere.report.ReportProcess;
import com.f3p.adempiere.report.ReportProcessLoader;
import com.f3p.adempiere.util.ModelFactory;
import com.f3p.commons.Utils;
import java.io.File;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Level;
import net.htmlparser.jericho.Renderer;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MMailText;
import org.compiere.model.MRequest;
import org.compiere.model.MRequestType;
import org.compiere.model.MRule;
import org.compiere.model.MUser;
import org.compiere.model.MUserRoles;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class NotifyAndCreateRequest
extends SvrProcess {
    public static final String COL_BPLOC = "C_BPartner_Location_ID";
    public static final String COL_MAIL = "EMAIL";
    public static final String CTX_PREFIX = "#";
    public static final String MSG_MAILSSENT = "F3P_MAILSSENT";
    public static final String MSG_MAILSERRORS = "F3P_MAILSERRORS";
    public static final String MSG_NEWREQUESTS = "F3P_NEWREQUESTS";
    protected String m_sQuery = null;
    protected int m_iSalesRepID = -1;
    protected int m_iAD_Role_ID = -1;
    protected int m_iR_MailText_ID = -1;
    protected int m_iAD_Process_ID = -1;
    protected boolean m_bCreateRequest = false;
    protected MRequestType m_mRequestType = null;

    @Override
    protected String doIt() throws Exception {
        int iWinNo = Env.createWindowNo(null);
        Properties rsCtx = new Properties(this.getCtx());
        String sSQL = Env.parseContext(this.getCtx(), iWinNo, this.m_sQuery, false, false);
        boolean bHasUserID = false;
        boolean bHasBPartner = false;
        boolean bHasOrder = false;
        boolean bHasBPLocation = false;
        int iCountMail = 0;
        int iCountRequests = 0;
        int iFailedMail = 0;
        if (Utils.isEmptyString(sSQL)) {
            return "Query not resolved";
        }
        CPreparedStatement pstmt = DB.prepareStatement(sSQL, this.get_TrxName());
        ResultSet rs = null;
        ArrayList<String> lstColumnNames = new ArrayList<String>();
        ReportProcess mProcess = null;
        MReportDet[] mReportDets = null;
        FileBuilder fileBuilder = null;
        if (this.m_iAD_Process_ID > 0) {
            ProcessInfo pi = new ProcessInfo(this.getName(), this.m_iAD_Process_ID, 0, 0);
            pi.setAD_User_ID(Env.getAD_User_ID(this.getCtx()));
            pi.setAD_Client_ID(Env.getAD_Client_ID(this.getCtx()));
            pi.setPrintPreview(false);
            ReportProcessLoader loader = new ReportProcessLoader(pi, iWinNo, 0, rsCtx);
            if (loader.loadReports() && (mProcess = loader.getReport()) != null) {
                mProcess.setTrx(Trx.get(this.get_TrxName(), false));
                MReportInt mReportInt = mProcess.getReportInt();
                mReportDets = mReportInt.getDetails("A", iWinNo, 0, null, false);
                fileBuilder = new FileBuilder(mProcess);
            }
        }
        String sBCC = this.getBCC();
        try {
            rs = pstmt.executeQuery();
            ResultSetMetaData rsMeta = rs.getMetaData();
            int iCols = rsMeta.getColumnCount();
            int i = 0;
            while (i < iCols) {
                String sColName = rsMeta.getColumnName(i + 1).toUpperCase();
                lstColumnNames.add(sColName);
                if (sColName.equals("C_BPARTNER_ID")) {
                    bHasBPartner = true;
                } else if (sColName.equals("AD_USER_ID")) {
                    bHasUserID = true;
                } else if (sColName.equals("C_BPARTNER_LOCATION_ID")) {
                    bHasBPLocation = true;
                } else if (sColName.equals("C_ORDER_ID")) {
                    bHasOrder = true;
                }
                ++i;
            }
            MMailText mMailText = new MMailText(rsCtx, this.m_iR_MailText_ID, this.get_TrxName());
            while (rs.next()) {
                String sMail = rs.getString(COL_MAIL);
                int C_BPartner_ID = -1;
                int AD_User_ID = -1;
                if (bHasUserID) {
                    AD_User_ID = rs.getInt("AD_User_ID");
                    mMailText.setUser(AD_User_ID);
                }
                if (bHasBPartner) {
                    C_BPartner_ID = rs.getInt("C_BPARTNER_ID");
                    mMailText.setBPartner(C_BPartner_ID);
                }
                HashMap<String, Object> mapParams = new HashMap<String, Object>();
                for (String sColName : lstColumnNames) {
                    Object oVal = rs.getObject(sColName);
                    if (oVal == null) continue;
                    Env.setContext(rsCtx, iWinNo, sColName, oVal.toString());
                    mapParams.put(sColName, oVal);
                }
                String sMailText = mMailText.getMailText();
                String sMailSubject = mMailText.getMailHeader();
                if (sMailText.indexOf("@") > 0) {
                    sMailText = Env.parseContext(rsCtx, iWinNo, sMailText, false, true);
                }
                if (sMailSubject.indexOf("@") > 0) {
                    sMailSubject = Env.parseContext(rsCtx, iWinNo, sMailSubject, false, true);
                }
                if (!Utils.isEmptyString(sMail)) {
                    MailBuilder mailBuilder = new MailBuilder(rsCtx, this.get_TrxName());
                    mailBuilder.setTo(sMail);
                    if (sBCC != null) {
                        mailBuilder.setBCc(sBCC);
                    }
                    mailBuilder.setContent(sMailText, mMailText.isHtml());
                    mailBuilder.setSubject(sMailSubject);
                    ArrayList<File> lstAttachments = new ArrayList<File>();
                    if (mReportDets != null) {
                        MReportDet[] mReportDetArray = mReportDets;
                        int n = mReportDets.length;
                        int n2 = 0;
                        while (n2 < n) {
                            MReportDet att = mReportDetArray[n2];
                            File fAtt = fileBuilder.getAsPDF(att, rsCtx, mapParams, iWinNo, 0);
                            if (fAtt != null) {
                                mailBuilder.addAttachment(fAtt);
                                lstAttachments.add(fAtt);
                            }
                            ++n2;
                        }
                    }
                    if (!mailBuilder.sendMail()) {
                        ++iFailedMail;
                        this.addLog(String.valueOf(Msg.getMsg(this.getCtx(), "F3P_Mail_Error")) + " " + sMail);
                    } else {
                        ++iCountMail;
                    }
                    for (File fAtt : lstAttachments) {
                        if (fAtt.delete()) continue;
                        fAtt.deleteOnExit();
                    }
                    Env.clearWinContext(iWinNo);
                }
                if (!this.m_bCreateRequest) continue;
                int C_BPartnerLocation_ID = -1;
                int C_Order_ID = -1;
                if (bHasBPLocation) {
                    C_BPartnerLocation_ID = rs.getInt(COL_BPLOC);
                }
                if (bHasOrder) {
                    C_Order_ID = rs.getInt("C_Order_ID");
                }
                if (mMailText.isHtml()) {
                    Source htmlSource = new Source((CharSequence)sMailText);
                    Segment htmlSeg = new Segment(htmlSource, 0, sMailText.length());
                    Renderer htmlRend = new Renderer(htmlSeg);
                    sMailText = htmlRend.toString();
                }
                this.createRequest(C_BPartner_ID, C_BPartnerLocation_ID, AD_User_ID, C_Order_ID, sMailSubject, sMailText);
                ++iCountRequests;
            }
        }
        finally {
            DB.close(rs, pstmt);
        }
        String sMsgSent = Msg.getMsg(this.getCtx(), MSG_MAILSSENT);
        this.addLog(MessageFormat.format(sMsgSent, iCountMail));
        String sMsgFailed = Msg.getMsg(this.getCtx(), MSG_MAILSERRORS);
        this.addLog(MessageFormat.format(sMsgFailed, iFailedMail));
        if (this.m_bCreateRequest) {
            String sMsgRequests = Msg.getMsg(this.getCtx(), MSG_NEWREQUESTS);
            this.addLog(MessageFormat.format(sMsgRequests, iCountRequests));
        }
        return "@Ok@";
    }

    protected String getBCC() {
        HashSet<String> setBCC = new HashSet<String>();
        if (!this.m_bCreateRequest) {
            if (this.m_iSalesRepID > 0) {
                this.addEMail(setBCC, this.m_iSalesRepID);
            }
            if (this.m_iAD_Role_ID > 0) {
                MUserRoles[] userRoles;
                MUserRoles[] mUserRolesArray = userRoles = MUserRoles.getOfRole(this.getCtx(), this.m_iAD_Role_ID);
                int n = userRoles.length;
                int n2 = 0;
                while (n2 < n) {
                    MUserRoles userRole = mUserRolesArray[n2];
                    this.addEMail(setBCC, userRole.getAD_User_ID());
                    ++n2;
                }
            }
        }
        if (setBCC.size() > 0) {
            StringBuilder sbBCC = new StringBuilder();
            for (String sMail : setBCC) {
                sbBCC.append(sMail).append(";");
            }
            sbBCC.setLength(sbBCC.length() - 1);
            return sbBCC.toString();
        }
        return null;
    }

    protected void addEMail(Collection<String> cCol, int AD_User_ID) {
        MUser mUser = MUser.get(this.getCtx(), AD_User_ID);
        String sMail = null;
        if (mUser != null) {
            sMail = mUser.getEMail();
        }
        if (!Utils.isEmptyString(sMail)) {
            cCol.add(sMail);
        }
    }

    protected void createRequest(int C_BPartner_ID, int C_BPartnerLocation_ID, int AD_User_ID, int C_Order_ID, String sSubject, String sSummary) {
        MRequest mRequest = (MRequest)ModelFactory.createModel(this.getCtx(), "R_Request", this.get_TrxName());
        int R_Status_ID = this.m_mRequestType.getDefaultR_Status_ID();
        mRequest.setR_RequestType_ID(this.m_mRequestType.getR_RequestType_ID());
        mRequest.setR_Status_ID(R_Status_ID);
        mRequest.setConfidentialType(this.m_mRequestType.getConfidentialType());
        mRequest.setConfidentialTypeEntry(this.m_mRequestType.getConfidentialType());
        mRequest.setSummary(String.valueOf(sSubject) + "\n\n" + sSummary);
        mRequest.setSalesRep_ID(this.m_iSalesRepID);
        mRequest.setAD_Role_ID(this.m_iAD_Role_ID);
        mRequest.setC_BPartner_ID(C_BPartner_ID);
        if (C_Order_ID > 0) {
            mRequest.setC_Order_ID(C_Order_ID);
        }
        if (mRequest.get_ColumnIndex(COL_BPLOC) > 0 && C_BPartnerLocation_ID > 0) {
            mRequest.set_CustomColumn(COL_BPLOC, C_BPartnerLocation_ID);
        }
        if (AD_User_ID > 0) {
            mRequest.setAD_User_ID(AD_User_ID);
        }
        mRequest.saveEx();
    }

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Rule_ID")) {
                    int AD_Rule_ID = para[i].getParameterAsInt();
                    MRule mRule = MRule.get(this.getCtx(), AD_Rule_ID);
                    this.m_sQuery = mRule.getScript();
                } else if (name.equals("SalesRep_ID")) {
                    this.m_iSalesRepID = para[i].getParameterAsInt();
                } else if (name.equals("AD_Role_ID")) {
                    this.m_iAD_Role_ID = para[i].getParameterAsInt();
                } else if (name.equals("R_MailText_ID")) {
                    this.m_iR_MailText_ID = para[i].getParameterAsInt();
                } else if (name.equals("AD_Process_ID")) {
                    this.m_iAD_Process_ID = para[i].getParameterAsInt();
                } else if (name.equals("IsCreateRequest")) {
                    this.m_bCreateRequest = para[i].getParameterAsBoolean();
                } else if (name.equals("R_RequestType_ID")) {
                    int R_RequestType_ID = para[i].getParameterAsInt();
                    this.m_mRequestType = MRequestType.get(this.getCtx(), R_RequestType_ID);
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        if (this.m_bCreateRequest && this.m_mRequestType == null) {
            throw new AdempiereException("CreateRequest flagged, but no request type specified");
        }
    }
}

