/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.process;

import com.f3p.adempiere.util.QueryRepo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrder;
import org.compiere.model.MRole;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_Order;
import org.compiere.model.X_C_OrderLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MergePurchaseOrders
extends SvrProcess {
    private static final String BASE_QUERY_NAME = "com/f3p/adempiere/process/get_orders_to_merge";
    private static final String ORDER_BY = " ORDER BY C_BPartner_ID,C_BPartner_Location_ID,AD_User_ID,Bill_BPartner_ID,Bill_Location_ID,Bill_User_ID,SalesRep_ID,M_PriceList_ID,PaymentRule,C_PaymentTerm_ID,DocumentNo";
    private static int FIRST_ORDER_LINE = 10;
    private static int DELTA_ORDER_LINE = 10;
    protected int m_iOrdersC_DocType_ID = -1;
    protected int m_iGeneratedC_DocType_ID = -1;
    protected int m_iC_BPartner_ID = -1;
    protected Timestamp m_tsDateFrom = null;
    protected Timestamp m_tsDateTo = null;

    @Override
    protected String doIt() throws Exception {
        StringBuilder sSqlBuilder = new StringBuilder(QueryRepo.getQuery(BASE_QUERY_NAME, this.getClass().getClassLoader()));
        LinkedList<Comparable<Integer>> lstParams = new LinkedList<Comparable<Integer>>();
        lstParams.add(Integer.valueOf(this.m_iOrdersC_DocType_ID));
        if (this.m_iC_BPartner_ID > 0) {
            sSqlBuilder.append(" AND C_Order.C_BPartner_ID = ?");
            lstParams.add(Integer.valueOf(this.m_iC_BPartner_ID));
        }
        if (this.m_tsDateFrom != null) {
            sSqlBuilder.append(" AND C_Order.DateOrdered >= ? ");
            lstParams.add(this.m_tsDateFrom);
        }
        if (this.m_tsDateTo != null) {
            sSqlBuilder.append(" AND C_Order.DateOrdered <= ? ");
            lstParams.add(this.m_tsDateTo);
        }
        sSqlBuilder.append(ORDER_BY);
        String sSQL = MRole.getDefault().addAccessSQL(sSqlBuilder.toString(), "C_Order", true, false);
        CPreparedStatement pstmt = DB.prepareStatement(sSQL, this.get_TrxName());
        ResultSet rs = null;
        int iParamIdx = 1;
        for (Object e : lstParams) {
            pstmt.setObject(iParamIdx++, e);
        }
        try {
            rs = pstmt.executeQuery();
            this.processOrders(rs);
        }
        finally {
            DB.close(rs, pstmt);
        }
        return "Ok";
    }

    protected void processOrders(ResultSet rs) throws SQLException {
        X_C_Order mNewOrder = null;
        int iLineNo = FIRST_ORDER_LINE;
        while (rs.next()) {
            MOrder mOldOrder = new MOrder(this.getCtx(), rs, this.get_TrxName());
            if (mNewOrder == null || mOldOrder.getC_BPartner_ID() != mNewOrder.getC_BPartner_ID() || mOldOrder.getC_BPartner_Location_ID() != mNewOrder.getC_BPartner_Location_ID() || mOldOrder.getAD_User_ID() != mNewOrder.getAD_User_ID() || mOldOrder.getBill_BPartner_ID() != mNewOrder.getBill_BPartner_ID() || mOldOrder.getBill_Location_ID() != mNewOrder.getBill_Location_ID() || mOldOrder.getBill_User_ID() != mNewOrder.getBill_User_ID() || mOldOrder.getSalesRep_ID() != mNewOrder.getSalesRep_ID() || mOldOrder.getM_PriceList_ID() != mNewOrder.getM_PriceList_ID() || !mOldOrder.getPaymentRule().equals(mNewOrder.getPaymentRule()) || mOldOrder.getC_PaymentTerm_ID() != mNewOrder.getC_PaymentTerm_ID()) {
                iLineNo = FIRST_ORDER_LINE;
                mNewOrder = new MOrder(this.getCtx(), 0, this.get_TrxName());
                PO.copyValues(mOldOrder, mNewOrder);
                mNewOrder.setC_DocTypeTarget_ID(this.m_iGeneratedC_DocType_ID);
                mNewOrder.setIsSOTrx(false);
                mNewOrder.setDocumentNo(null);
                mNewOrder.setPOReference(null);
                mNewOrder.saveEx();
                this.addLog(mNewOrder.getC_Order_ID(), mNewOrder.getDateOrdered(), null, mNewOrder.getDocumentNo());
            }
            iLineNo = this.moveOrderLines(mNewOrder.getC_Order_ID(), mOldOrder.getC_Order_ID(), iLineNo);
            this.unlinkOrders(mOldOrder);
            mOldOrder.delete(false);
        }
    }

    protected void unlinkOrders(MOrder mOrder) {
        if (mOrder.getLink_Order_ID() > 0) {
            mOrder.setLink_Order_ID(0);
            mOrder.saveEx();
        }
        Query qLinked = new Query(mOrder.getCtx(), "C_Order", "Link_Order_ID= ?", mOrder.get_TrxName());
        List lstOrders = qLinked.setParameters(mOrder.getC_Order_ID()).list();
        for (MOrder mLinkOrder : lstOrders) {
            mLinkOrder.setLink_Order_ID(0);
            mLinkOrder.saveEx();
        }
    }

    protected int moveOrderLines(int C_NewOrder_ID, int C_Order_ID, int iLineNo) {
        Query qOrderLines = new Query(this.getCtx(), "C_OrderLine", "C_Order_ID = ?", this.get_TrxName());
        qOrderLines.setOrderBy("Line").setParameters(C_Order_ID);
        List lstLines = qOrderLines.list();
        for (X_C_OrderLine mLine : lstLines) {
            mLine.setC_Order_ID(C_NewOrder_ID);
            mLine.setLine(iLineNo);
            mLine.saveEx();
            iLineNo += DELTA_ORDER_LINE;
        }
        return iLineNo;
    }

    @Override
    protected void prepare() {
        ProcessInfoParameter[] params;
        ProcessInfoParameter[] processInfoParameterArray = params = this.getParameter();
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter param = processInfoParameterArray[n2];
            if (param.getParameterName().equals("OrdersC_DocType_ID")) {
                this.m_iOrdersC_DocType_ID = param.getParameterAsInt();
            } else if (param.getParameterName().equals("GeneratedC_DocType_ID")) {
                this.m_iGeneratedC_DocType_ID = param.getParameterAsInt();
            } else if (param.getParameterName().equals("C_BPartner_ID")) {
                this.m_iC_BPartner_ID = param.getParameterAsInt();
            } else if (param.getParameterName().equals("DateRange")) {
                this.m_tsDateFrom = (Timestamp)param.getParameter();
                this.m_tsDateTo = (Timestamp)param.getParameter_To();
            }
            ++n2;
        }
        if (this.m_iGeneratedC_DocType_ID < 0 || this.m_iOrdersC_DocType_ID < 0) {
            throw new AdempiereException("@ParameterMissing@");
        }
    }
}

