/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.process;

import com.f3p.adempiere.model.X_I_WF_Node;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.compiere.model.MRefList;
import org.compiere.model.Query;
import org.compiere.process.SvrProcess;
import org.compiere.util.Msg;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWorkflow;

public class ImportWorkflow
extends SvrProcess {
    private int m_AD_Reference_ID_PublishStatus = 0;
    private int m_AD_Reference_ID_WorkflowType = 0;
    private int m_AD_Reference_ID_ProcessType = 0;
    private List<String> m_lstEntityType = new LinkedList<String>();
    private List<String> m_lstPublishStatus = new LinkedList<String>();
    private List<String> m_lstWorkflowType = new LinkedList<String>();
    private List<String> m_lstProcessType = new LinkedList<String>();
    private List<String> m_lstFirstNode = new LinkedList<String>();
    private HashMap<String, List<String>> m_hmValueNode = new HashMap();
    private static final String PUBLISH_STATUS = "_PublishStatus";
    private static final String WORKFLOW_TYPE = "AD_Workflow Type";
    private static final String PROCESS_TYPE = "PP_Process Type";
    private static final String AD_ERROR_TRANSCODE_MESSAGE = "F3P_Error_Transcode";
    private static final String AD_ERROR_INVALID_VALUE = "F3P_Error_Invalid_Value";
    private static final String AD_ERROR_IMPORT_FAILED = "F3P_Error_Import_Workflow";
    private static final String AD_ERROR_NO_START_NODE_SELECTED = "F3P_Error_No_Start_Node_Selected";
    private static final String AD_ERROR_MORE_START_NODE_SELECTED = "F3P_Error_More_Then_One_Start_Node";
    private static final String AD_ERROR_INVALID_PREVIOUS_STEP = "F3P_Error_Invalid_Previous_Step";
    private static final String AD_ERROR_MANDATORY_FIELD = "F3P_Error_Mandatory_Field";

    @Override
    protected void prepare() {
        this.m_AD_Reference_ID_PublishStatus = this.getADReferenceID(PUBLISH_STATUS);
        this.m_AD_Reference_ID_WorkflowType = this.getADReferenceID(WORKFLOW_TYPE);
        this.m_AD_Reference_ID_ProcessType = this.getADReferenceID(PROCESS_TYPE);
    }

    @Override
    protected String doIt() throws Exception {
        String sMsgError = null;
        boolean bError = false;
        Query q = new Query(this.getCtx(), "I_WF_Node", "I_IsImported='N'", this.get_TrxName());
        q.setOnlyActiveRecords(true).setApplyAccessFilter(true).setOrderBy("Name ASC, IsStartNode DESC, Value_Node ASC");
        List lstWorkflow = q.list();
        X_I_WF_Node mIWFFirst = null;
        for (X_I_WF_Node mIWFNode : lstWorkflow) {
            if (mIWFFirst == null) {
                mIWFFirst = mIWFNode;
            } else {
                String sNameFirst = mIWFFirst.getName();
                String sNodeName = mIWFNode.getName();
                if (sNameFirst != null && sNodeName != null && !sNameFirst.equals(sNodeName) && !this.m_lstFirstNode.contains(sNameFirst)) {
                    String sErrMsg = mIWFFirst.getI_ErrorMsg();
                    sErrMsg = sErrMsg != null ? String.valueOf(sErrMsg) + "\n" + Msg.getMsg(this.getCtx(), AD_ERROR_NO_START_NODE_SELECTED) : Msg.getMsg(this.getCtx(), AD_ERROR_NO_START_NODE_SELECTED);
                    mIWFFirst.setI_ErrorMsg(sErrMsg);
                    mIWFFirst.saveEx();
                }
            }
            boolean bErr = !this.check(mIWFNode);
            boolean bl = bError = bError || bErr;
        }
        if (this.m_lstFirstNode.size() == 0 && mIWFFirst != null) {
            String sErrMsg = mIWFFirst.getI_ErrorMsg();
            sErrMsg = sErrMsg != null ? String.valueOf(sErrMsg) + "\n" + Msg.getMsg(this.getCtx(), AD_ERROR_NO_START_NODE_SELECTED) : Msg.getMsg(this.getCtx(), AD_ERROR_NO_START_NODE_SELECTED);
            mIWFFirst.setI_ErrorMsg(sErrMsg);
            mIWFFirst.saveEx();
        }
        if (!bError) {
            for (X_I_WF_Node mIWFNode : lstWorkflow) {
                int iWorkflowID = this.getADWorkflowID(mIWFNode.getName());
                MWorkflow mWorkflow = null;
                mWorkflow = iWorkflowID > 0 ? this.updateWorkflow(iWorkflowID, mIWFNode) : this.createWorkflow(mIWFNode);
                int iWorkflowNodeID = this.getADWFNodeID(mWorkflow.get_ID(), mIWFNode.getValue_Node());
                if (iWorkflowNodeID > 0) {
                    this.updateWFNode(iWorkflowNodeID, mWorkflow, mIWFNode);
                } else {
                    iWorkflowNodeID = this.createWFNode(mWorkflow, mIWFNode);
                }
                mIWFNode.setProcessed(true);
                mIWFNode.setProcessing(false);
                mIWFNode.setI_IsImported(true);
                mIWFNode.saveEx();
            }
        } else {
            sMsgError = Msg.getMsg(this.getCtx(), AD_ERROR_IMPORT_FAILED);
        }
        return sMsgError;
    }

    protected MWorkflow createWorkflow(X_I_WF_Node mIWFNode) {
        MWorkflow mWorkflow = new MWorkflow(this.getCtx(), 0, this.get_TrxName());
        return this.updateWorkflow(mWorkflow, mIWFNode);
    }

    protected MWorkflow updateWorkflow(int iAD_Workflow_ID, X_I_WF_Node mIWFNode) {
        MWorkflow mWorkflow = new MWorkflow(this.getCtx(), iAD_Workflow_ID, this.get_TrxName());
        return this.updateWorkflow(mWorkflow, mIWFNode);
    }

    protected MWorkflow updateWorkflow(MWorkflow mWorkflow, X_I_WF_Node mIWFNode) {
        int AD_ORG_ID = mIWFNode.getAD_Org_ID();
        mWorkflow.setAD_Org_ID(AD_ORG_ID);
        mWorkflow.setName(mIWFNode.getName());
        mWorkflow.setDescription(mIWFNode.getDescription());
        mWorkflow.setHelp(mIWFNode.getHelp());
        if (AD_ORG_ID != 0) {
            mWorkflow.setAccessLevel("1");
        } else {
            mWorkflow.setAccessLevel("7");
        }
        mWorkflow.setEntityType(mIWFNode.getEntityType());
        mWorkflow.setDurationUnit(mIWFNode.getDurationUnit());
        mWorkflow.setAuthor(mIWFNode.getAuthor());
        mWorkflow.setVersion(mIWFNode.getVersion());
        mWorkflow.setValidFrom(mIWFNode.getValidFrom());
        mWorkflow.setValidTo(mIWFNode.getValidTo());
        mWorkflow.setPriority(mIWFNode.getPriority());
        mWorkflow.setLimit(mIWFNode.getLimit());
        mWorkflow.setDuration(mIWFNode.getDuration());
        mWorkflow.setCost(mIWFNode.getCost());
        mWorkflow.setWorkingTime(mIWFNode.getWorkingTime());
        mWorkflow.setWaitingTime(mIWFNode.getWaitingTime());
        mWorkflow.setPublishStatus(mIWFNode.getPublishStatus());
        mWorkflow.setValue(mIWFNode.getValue());
        mWorkflow.setIsDefault(mIWFNode.isDefault());
        mWorkflow.setWorkflowType(mIWFNode.getWorkflowType());
        mWorkflow.setS_Resource_ID(mIWFNode.getS_Resource_ID());
        mWorkflow.setSetupTime(mIWFNode.getSetupTime());
        mWorkflow.setMovingTime(mIWFNode.getMovingTime());
        mWorkflow.setProcessType(mIWFNode.getProcessType());
        String sDocumentNo = mIWFNode.getDocumentNo();
        if (sDocumentNo != null && sDocumentNo.length() != 0) {
            mWorkflow.setDocumentNo(sDocumentNo);
        }
        mWorkflow.setQtyBatchSize(mIWFNode.getQtyBatchSize());
        mWorkflow.setQueuingTime(mIWFNode.getQueuingTime());
        mWorkflow.setYield(mIWFNode.getYield());
        mWorkflow.setUnitsCycles(mIWFNode.getUnitsCycles());
        mWorkflow.setOverlapUnits(mIWFNode.getOverlapUnits());
        mWorkflow.saveEx();
        mIWFNode.setAD_Workflow_ID(mWorkflow.get_ID());
        mIWFNode.saveEx();
        return mWorkflow;
    }

    protected int createWFNode(MWorkflow mWorkflow, X_I_WF_Node mIWFNode) {
        MWFNode mWFNode = new MWFNode(this.getCtx(), 0, this.get_TrxName());
        this.updateWFNode(mWFNode, mWorkflow, mIWFNode);
        return mWFNode.get_ID();
    }

    protected void updateWFNode(int iAD_WFNode_ID, MWorkflow mWorkflow, X_I_WF_Node mIWFNode) {
        MWFNode mWFNode = new MWFNode(this.getCtx(), iAD_WFNode_ID, this.get_TrxName());
        this.updateWFNode(mWFNode, mWorkflow, mIWFNode);
    }

    protected void updateWFNode(MWFNode mWFNode, MWorkflow mWorkflow, X_I_WF_Node mIWFNode) {
        int iWFNodeID;
        mWFNode.setAD_Org_ID(mIWFNode.getAD_Org_ID());
        mWFNode.setName(mIWFNode.getName_Node());
        mWFNode.setDescription(mIWFNode.getDescription_Node());
        mWFNode.setHelp(mIWFNode.getHelp_Node());
        mWFNode.setAD_Workflow_ID(mWorkflow.get_ID());
        mWFNode.setAction("D");
        mWFNode.setEntityType(mIWFNode.getEntityType());
        mWFNode.setLimit(mIWFNode.getLimit_Node());
        mWFNode.setPriority(mIWFNode.getPriority_Node());
        mWFNode.setDuration(mIWFNode.getDuration_Node());
        mWFNode.setCost(mIWFNode.getCost_Node());
        mWFNode.setWorkingTime(mIWFNode.getWorkingTime_Node());
        mWFNode.setWaitingTime(mIWFNode.getWaitingTime_Node());
        mWFNode.setJoinElement(mIWFNode.getJoinElement());
        mWFNode.setSplitElement(mIWFNode.getSplitElement());
        mWFNode.setWaitTime(mIWFNode.getWaitTime());
        mWFNode.setDocAction("CO");
        mWFNode.setValue(mIWFNode.getValue_Node());
        mWFNode.setDynPriorityChange(BigDecimal.ZERO);
        mWFNode.setValidFrom(mIWFNode.getValidFrom_Node());
        mWFNode.setValidTo(mIWFNode.getValidTo_Node());
        mWFNode.setIsMilestone(mIWFNode.isMilestone());
        mWFNode.setIsSubcontracting(mIWFNode.isSubcontracting());
        mWFNode.setUnitsCycles(mIWFNode.getUnitsCycles_Node());
        mWFNode.setMovingTime(mIWFNode.getMovingTime_Node());
        mWFNode.setOverlapUnits(mIWFNode.getOverlapUnits_Node());
        mWFNode.setC_BPartner_ID(mIWFNode.getC_BPartner_ID());
        mWFNode.setQueuingTime(mIWFNode.getQueuingTime_Node());
        mWFNode.setS_Resource_ID(mIWFNode.getS_Resource_Node_ID());
        mWFNode.setSetupTime(mIWFNode.getSetupTime_Node());
        mWFNode.setYield(mIWFNode.getYield_Node());
        mWFNode.saveEx();
        int AD_WFNode_ID = mWFNode.get_ID();
        if (mIWFNode.isStartNode()) {
            mWorkflow.setAD_WF_Node_ID(AD_WFNode_ID);
            mWorkflow.saveEx();
            List<MWFNodeNext> lstNodeNext = this.getADWFNodeNextList(AD_WFNode_ID);
            if (lstNodeNext != null && lstNodeNext.size() != 0) {
                for (MWFNodeNext node : lstNodeNext) {
                    node.deleteEx(true, this.get_TrxName());
                }
            }
        }
        if ((iWFNodeID = this.getADWFNodeID(mWorkflow.get_ID(), mIWFNode.getPreviousStep())) > 0) {
            List<MWFNodeNext> lstNodeNext = this.getADWFNodeNextList(AD_WFNode_ID);
            if (lstNodeNext == null || lstNodeNext.size() == 0) {
                MWFNodeNext mWFNodeNext = new MWFNodeNext(this.getCtx(), 0, this.get_TrxName());
                mWFNodeNext.setAD_WF_Node_ID(iWFNodeID);
                mWFNodeNext.setAD_WF_Next_ID(AD_WFNode_ID);
                mWFNodeNext.setSeqNo(10);
                mWFNodeNext.setEntityType(mIWFNode.getEntityType());
                mWFNodeNext.setIsStdUserWorkflow(false);
                mWFNodeNext.saveEx();
            } else {
                int iSize = lstNodeNext.size();
                if (iSize > 1) {
                    int i = 1;
                    while (i < iSize) {
                        MWFNodeNext node = lstNodeNext.get(i);
                        node.deleteEx(true, this.get_TrxName());
                        ++i;
                    }
                }
                MWFNodeNext node = lstNodeNext.get(0);
                node.setAD_WF_Node_ID(iWFNodeID);
                node.saveEx();
            }
        }
        mWFNode.saveEx();
        mIWFNode.setAD_WF_Node_ID(AD_WFNode_ID);
        mIWFNode.saveEx();
    }

    protected boolean check(X_I_WF_Node mIWFNode) {
        String sNodeName;
        String sValueNode;
        String sMsg;
        String sValue;
        String sWFName;
        String sMsg2;
        Object[] args;
        String sProcessType;
        String sWorkflowType;
        String sPublishStatus;
        String sEntityType;
        String sResourceValueNode;
        String sBPartnerValue;
        boolean bError = false;
        StringBuffer sbMsgError = new StringBuffer();
        String sResourceValue = mIWFNode.getResourceValue();
        if (sResourceValue != null && sResourceValue.length() != 0) {
            int iS_Resource_ID = this.getSResourceID(sResourceValue);
            if (iS_Resource_ID > 0) {
                mIWFNode.setS_Resource_ID(iS_Resource_ID);
                mIWFNode.saveEx();
            } else {
                Object[] args2 = new Object[]{Msg.getElement(this.getCtx(), "S_Resource_ID")};
                String sMsg3 = Msg.getMsg(this.getCtx(), AD_ERROR_TRANSCODE_MESSAGE, args2);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg3);
                bError = true;
            }
        }
        if ((sBPartnerValue = mIWFNode.getBPartner_Value()) != null && sBPartnerValue.length() != 0) {
            int iC_BPartner_ID = this.getCBPartnerID(sBPartnerValue);
            if (iC_BPartner_ID > 0) {
                mIWFNode.setC_BPartner_ID(iC_BPartner_ID);
                mIWFNode.saveEx();
            } else {
                Object[] args3 = new Object[]{Msg.getElement(this.getCtx(), "C_BPartner_ID")};
                String sMsg4 = Msg.getMsg(this.getCtx(), AD_ERROR_TRANSCODE_MESSAGE, args3);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg4);
                bError = true;
            }
        }
        if ((sResourceValueNode = mIWFNode.getResourceValue_Node()) != null && sResourceValueNode.length() != 0) {
            int iS_Resource_ID = this.getSResourceID(sResourceValueNode);
            if (iS_Resource_ID > 0) {
                mIWFNode.setS_Resource_Node_ID(iS_Resource_ID);
                mIWFNode.saveEx();
            } else {
                Object[] args4 = new Object[]{Msg.getElement(this.getCtx(), "S_Resource_Node_ID")};
                String sMsg5 = Msg.getMsg(this.getCtx(), AD_ERROR_TRANSCODE_MESSAGE, args4);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg5);
                bError = true;
            }
        }
        if (!this.m_lstEntityType.contains(sEntityType = mIWFNode.getEntityType())) {
            boolean bCheck = this.checkEntityType(sEntityType);
            if (bCheck) {
                this.m_lstEntityType.add(sEntityType);
            } else {
                Object[] args5 = new Object[]{"EntityType", sEntityType};
                String sMsg6 = Msg.getMsg(this.getCtx(), AD_ERROR_INVALID_VALUE, args5);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg6);
                bError = true;
            }
        }
        if (!this.m_lstPublishStatus.contains(sPublishStatus = mIWFNode.getPublishStatus())) {
            boolean bCheck = this.checkRefValue(this.m_AD_Reference_ID_PublishStatus, sPublishStatus);
            if (bCheck) {
                this.m_lstPublishStatus.add(sPublishStatus);
            } else {
                Object[] args6 = new Object[]{"PublishStatus", sPublishStatus};
                String sMsg7 = Msg.getMsg(this.getCtx(), AD_ERROR_INVALID_VALUE, args6);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg7);
                bError = true;
            }
        }
        if (!this.m_lstWorkflowType.contains(sWorkflowType = mIWFNode.getWorkflowType())) {
            boolean bCheck = this.checkRefValue(this.m_AD_Reference_ID_WorkflowType, sWorkflowType);
            if (bCheck) {
                this.m_lstWorkflowType.add(sWorkflowType);
            } else {
                Object[] args7 = new Object[]{"WorkflowType", sWorkflowType};
                String sMsg8 = Msg.getMsg(this.getCtx(), AD_ERROR_INVALID_VALUE, args7);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg8);
                bError = true;
            }
        }
        if (!this.m_lstProcessType.contains(sProcessType = mIWFNode.getProcessType())) {
            boolean bCheck = this.checkRefValue(this.m_AD_Reference_ID_ProcessType, sProcessType);
            if (bCheck) {
                this.m_lstProcessType.add(sProcessType);
            } else {
                args = new Object[]{"ProcessType", sProcessType};
                sMsg2 = Msg.getMsg(this.getCtx(), AD_ERROR_INVALID_VALUE, args);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg2);
                bError = true;
            }
        }
        if ((sWFName = mIWFNode.getName()) != null && sWFName.length() != 0) {
            sValue = mIWFNode.getValue_Node();
            List<Object> lstValues = null;
            lstValues = this.m_hmValueNode.containsKey(sWFName) ? this.m_hmValueNode.get(sWFName) : new LinkedList<String>();
            lstValues.add(sValue);
            this.m_hmValueNode.put(sWFName, lstValues);
            String sPreviousStep = mIWFNode.getPreviousStep();
            if (mIWFNode.isStartNode()) {
                String sMsg9;
                if (this.m_lstFirstNode.contains(sWFName)) {
                    sMsg9 = Msg.getMsg(this.getCtx(), AD_ERROR_MORE_START_NODE_SELECTED);
                    if (sbMsgError.length() != 0) {
                        sbMsgError.append("\n");
                    }
                    sbMsgError.append(sMsg9);
                    bError = true;
                } else {
                    this.m_lstFirstNode.add(sWFName);
                }
                if (sPreviousStep != null && sPreviousStep.length() != 0) {
                    sMsg9 = Msg.getMsg(this.getCtx(), AD_ERROR_INVALID_PREVIOUS_STEP);
                    if (sbMsgError.length() != 0) {
                        sbMsgError.append("\n");
                    }
                    sbMsgError.append(sMsg9);
                    bError = true;
                }
            } else {
                boolean bErr = false;
                if (sPreviousStep == null || sPreviousStep.length() == 0) {
                    bErr = true;
                } else if (!lstValues.contains(sPreviousStep)) {
                    bErr = true;
                }
                if (bErr) {
                    sMsg = Msg.getMsg(this.getCtx(), AD_ERROR_INVALID_PREVIOUS_STEP);
                    if (sbMsgError.length() != 0) {
                        sbMsgError.append("\n");
                    }
                    sbMsgError.append(sMsg);
                    bError = true;
                }
            }
        } else {
            args = new Object[]{Msg.getElement(this.getCtx(), "Name")};
            sMsg2 = Msg.getMsg(this.getCtx(), AD_ERROR_MANDATORY_FIELD, args);
            if (sbMsgError.length() != 0) {
                sbMsgError.append("\n");
            }
            sbMsgError.append(sMsg2);
            bError = true;
        }
        if ((sValue = mIWFNode.getValue()) == null || sValue.length() == 0) {
            Object[] args8 = new Object[]{Msg.getElement(this.getCtx(), "Value")};
            String sMsg10 = Msg.getMsg(this.getCtx(), AD_ERROR_MANDATORY_FIELD, args8);
            if (sbMsgError.length() != 0) {
                sbMsgError.append("\n");
            }
            sbMsgError.append(sMsg10);
            bError = true;
        }
        if ((sValueNode = mIWFNode.getValue_Node()) == null || sValueNode.length() == 0) {
            Object[] args9 = new Object[]{Msg.getElement(this.getCtx(), "Value_Node")};
            String sMsg11 = Msg.getMsg(this.getCtx(), AD_ERROR_MANDATORY_FIELD, args9);
            if (sbMsgError.length() != 0) {
                sbMsgError.append("\n");
            }
            sbMsgError.append(sMsg11);
            bError = true;
        }
        if ((sNodeName = mIWFNode.getName_Node()) == null || sNodeName.length() == 0) {
            Object[] args10 = new Object[]{Msg.getElement(this.getCtx(), "Name_Node")};
            sMsg = Msg.getMsg(this.getCtx(), AD_ERROR_MANDATORY_FIELD, args10);
            if (sbMsgError.length() != 0) {
                sbMsgError.append("\n");
            }
            sbMsgError.append(sMsg);
            bError = true;
        }
        mIWFNode.setI_ErrorMsg(sbMsgError.toString());
        mIWFNode.saveEx();
        return !bError;
    }

    protected int getSResourceID(String sResourceValue) {
        int S_Resource_ID = 0;
        Query qRef = new Query(this.getCtx(), "S_Resource", "Value = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sResourceValue);
        S_Resource_ID = qRef.firstId();
        return S_Resource_ID;
    }

    protected int getCBPartnerID(String sBPartnerValue) {
        int C_BPartner_ID = 0;
        Query qRef = new Query(this.getCtx(), "C_BPartner", "Value = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sBPartnerValue);
        C_BPartner_ID = qRef.firstId();
        return C_BPartner_ID;
    }

    protected int getADWorkflowID(String sName) {
        int AD_Workflow_ID = 0;
        Query qRef = new Query(this.getCtx(), "AD_Workflow", "Name = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sName);
        AD_Workflow_ID = qRef.firstId();
        return AD_Workflow_ID;
    }

    protected int getADWFNodeID(int AD_Workflow_ID, String sValue) {
        int AD_WF_Node_ID = 0;
        Query qRef = new Query(this.getCtx(), "AD_WF_Node", "AD_Workflow_ID = ? AND Value = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(AD_Workflow_ID, sValue);
        AD_WF_Node_ID = qRef.firstId();
        return AD_WF_Node_ID;
    }

    protected List<MWFNodeNext> getADWFNodeNextList(int AD_WF_Node_ID) {
        List<MWFNodeNext> lstNodes = null;
        Query qRef = new Query(this.getCtx(), "AD_WF_NodeNext", "AD_WF_Next_ID = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(AD_WF_Node_ID);
        lstNodes = qRef.list();
        return lstNodes;
    }

    protected int getADReferenceID(String sName) {
        int AD_Reference_ID = 0;
        Query qRef = new Query(this.getCtx(), "AD_Reference", "Name = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sName);
        AD_Reference_ID = qRef.firstId();
        return AD_Reference_ID;
    }

    protected boolean checkRefValue(int AD_Reference_ID, String sValue) {
        boolean bError = false;
        MRefList refList = MRefList.get(this.getCtx(), AD_Reference_ID, sValue, this.get_TrxName());
        if (refList == null) {
            bError = true;
        }
        return !bError;
    }

    protected boolean checkEntityType(String sEntityType) {
        boolean bError = false;
        Query qRef = new Query(this.getCtx(), "AD_EntityType", "EntityType = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sEntityType);
        bError = qRef.count() == 0;
        return !bError;
    }
}

