/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.process;

import com.f3p.adempiere.model.X_I_Product_BomLine;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import org.compiere.model.MProduct;
import org.compiere.model.MRefList;
import org.compiere.model.Query;
import org.compiere.process.SvrProcess;
import org.compiere.util.Msg;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;

public class ImportProductBOM
extends SvrProcess {
    private int m_AD_Reference_ID_BOM_Type = 0;
    private int m_AD_Reference_ID_BOM_Use = 0;
    private int m_AD_Reference_ID_ComponentType = 0;
    private int m_AD_Reference_ID_IssueMethod = 0;
    private List<String> m_lstBOMType = new LinkedList<String>();
    private List<String> m_lstBOMUse = new LinkedList<String>();
    private List<String> m_lstComponentType = new LinkedList<String>();
    private List<String> m_lstIssueMethod = new LinkedList<String>();
    private static final String M_BOM_TYPE = "M_BOM Type";
    private static final String M_BOM_USE = "M_BOM Use";
    private static final String PP_COMPONENT_TYPE = "PP_ComponentType";
    private static final String PP_ISSUE_METHOD = "PP_Product_BOM IssueMethod";
    private static final String AD_ERROR_TRANSCODE_MESSAGE = "F3P_Error_Transcode";
    private static final String AD_ERROR_INVALID_VALUE = "F3P_Error_Invalid_Value";
    private static final String AD_ERROR_IMPORT_FAILED = "F3P_Error_Import_ProductBOM";
    private static final String AD_ERROR_MANDATORY_FIELD = "F3P_Error_Mandatory_Field";

    @Override
    protected void prepare() {
        this.m_AD_Reference_ID_BOM_Type = this.getADReferenceID(M_BOM_TYPE);
        this.m_AD_Reference_ID_BOM_Use = this.getADReferenceID(M_BOM_USE);
        this.m_AD_Reference_ID_ComponentType = this.getADReferenceID(PP_COMPONENT_TYPE);
        this.m_AD_Reference_ID_IssueMethod = this.getADReferenceID(PP_ISSUE_METHOD);
    }

    @Override
    protected String doIt() throws Exception {
        String sMsgError = null;
        boolean bError = false;
        Query q = new Query(this.getCtx(), "I_Product_BomLine", "I_IsImported='N'", this.get_TrxName());
        q.setOnlyActiveRecords(true).setApplyAccessFilter(true).setOrderBy("Value ASC, Line ASC");
        List lstProductBOMLine = q.list();
        for (X_I_Product_BomLine mIProductBOMLine : lstProductBOMLine) {
            boolean bErr = !this.check(mIProductBOMLine);
            boolean bl = bError = bError || bErr;
        }
        if (!bError) {
            for (X_I_Product_BomLine mIProductBOMLine : lstProductBOMLine) {
                int productBOMID = this.getPPProductBOMID(mIProductBOMLine.getValue());
                if (productBOMID > 0) {
                    this.updateProductBOM(productBOMID, mIProductBOMLine);
                } else {
                    productBOMID = this.createProductBOM(mIProductBOMLine);
                }
                int productBOMLineID = this.getPPProductBOMLineID(productBOMID, mIProductBOMLine.getLine());
                if (productBOMLineID > 0) {
                    this.updateProductBOMLine(productBOMLineID, mIProductBOMLine);
                } else {
                    productBOMLineID = this.createProductBOMLine(mIProductBOMLine);
                }
                mIProductBOMLine.setProcessed(true);
                mIProductBOMLine.setProcessing(false);
                mIProductBOMLine.setI_IsImported(true);
                mIProductBOMLine.saveEx();
            }
        } else {
            sMsgError = Msg.getMsg(this.getCtx(), AD_ERROR_IMPORT_FAILED);
        }
        return sMsgError;
    }

    protected int createProductBOM(X_I_Product_BomLine mIProductBOMLine) {
        MPPProductBOM productBOM = new MPPProductBOM(this.getCtx(), 0, this.get_TrxName());
        this.updateProductBOM(productBOM, mIProductBOMLine);
        return productBOM.get_ID();
    }

    protected void updateProductBOM(int iProductBOMID, X_I_Product_BomLine mIProductBOMLine) {
        MPPProductBOM productBOM = new MPPProductBOM(this.getCtx(), iProductBOMID, this.get_TrxName());
        this.updateProductBOM(productBOM, mIProductBOMLine);
    }

    protected void updateProductBOM(MPPProductBOM productBOM, X_I_Product_BomLine mIProductBOMLine) {
        productBOM.setValue(mIProductBOMLine.getValue());
        productBOM.setName(mIProductBOMLine.getName());
        String sDocumentNo = mIProductBOMLine.getDocumentNo();
        if (sDocumentNo != null && sDocumentNo.length() != 0) {
            productBOM.setDocumentNo(sDocumentNo);
        }
        productBOM.setRevision(mIProductBOMLine.getRevision());
        productBOM.setDescription(mIProductBOMLine.getDescription());
        productBOM.setHelp(mIProductBOMLine.getHelp());
        productBOM.setM_ChangeNotice_ID(mIProductBOMLine.getM_ChangeNotice_ID());
        productBOM.setM_Product_ID(mIProductBOMLine.getM_Product_ID());
        productBOM.setValidFrom(mIProductBOMLine.getValidFrom());
        productBOM.setValidTo(mIProductBOMLine.getValidTo());
        productBOM.setM_AttributeSetInstance_ID(mIProductBOMLine.getM_AttributeSetInstance_ID());
        productBOM.setAD_Org_ID(mIProductBOMLine.getAD_Org_ID());
        productBOM.setBOMType(mIProductBOMLine.getBOMType());
        productBOM.setBOMUse(mIProductBOMLine.getBOMUse());
        productBOM.setC_UOM_ID(mIProductBOMLine.getC_UOM_ID());
        productBOM.saveEx();
        mIProductBOMLine.setPP_Product_BOM_ID(productBOM.get_ID());
        mIProductBOMLine.saveEx();
    }

    protected int createProductBOMLine(X_I_Product_BomLine mIProductBOMLine) {
        MPPProductBOMLine pp_productBOMLine = new MPPProductBOMLine(this.getCtx(), 0, this.get_TrxName());
        this.updateProductBOMLine(pp_productBOMLine, mIProductBOMLine);
        return pp_productBOMLine.get_ID();
    }

    protected void updateProductBOMLine(int iProductBOMLineID, X_I_Product_BomLine mIProductBOMLine) {
        MPPProductBOMLine pp_productBOMLine = new MPPProductBOMLine(this.getCtx(), iProductBOMLineID, this.get_TrxName());
        this.updateProductBOMLine(pp_productBOMLine, mIProductBOMLine);
    }

    protected void updateProductBOMLine(MPPProductBOMLine pp_productBOMLine, X_I_Product_BomLine mIProductBOMLine) {
        pp_productBOMLine.setFeature(mIProductBOMLine.getFeature());
        pp_productBOMLine.setAD_Org_ID(mIProductBOMLine.getAD_Org_ID());
        pp_productBOMLine.setAssay(mIProductBOMLine.getAssay());
        pp_productBOMLine.setBackflushGroup(mIProductBOMLine.getBackflushGroup());
        pp_productBOMLine.setC_UOM_ID(mIProductBOMLine.getC_UOM_Line_ID());
        pp_productBOMLine.setComponentType(mIProductBOMLine.getComponentType());
        pp_productBOMLine.setDescription(mIProductBOMLine.getDescription_Line());
        pp_productBOMLine.setHelp(mIProductBOMLine.getHelp_Line());
        pp_productBOMLine.setIsCritical(mIProductBOMLine.isCritical());
        pp_productBOMLine.setIsQtyPercentage(mIProductBOMLine.isQtyPercentage());
        pp_productBOMLine.setIssueMethod(mIProductBOMLine.getIssueMethod());
        pp_productBOMLine.setLeadTimeOffset(mIProductBOMLine.getLeadTimeOffset());
        pp_productBOMLine.setLine(mIProductBOMLine.getLine());
        pp_productBOMLine.setM_AttributeSetInstance_ID(mIProductBOMLine.getM_AttrSetInst_Line_ID());
        pp_productBOMLine.setM_ChangeNotice_ID(mIProductBOMLine.getM_ChangeNotice_Line_ID());
        pp_productBOMLine.setM_Product_ID(mIProductBOMLine.getM_Product_Line_ID());
        pp_productBOMLine.setPP_Product_BOM_ID(mIProductBOMLine.getPP_Product_BOM_ID());
        pp_productBOMLine.setQtyBOM(mIProductBOMLine.getQtyBOM());
        pp_productBOMLine.setQtyBatch(mIProductBOMLine.getQtyBatch());
        pp_productBOMLine.setScrap(mIProductBOMLine.getScrap());
        pp_productBOMLine.setValidFrom(mIProductBOMLine.getValidFrom_Line());
        pp_productBOMLine.setValidTo(mIProductBOMLine.getValidTo_Line());
        pp_productBOMLine.setCostAllocationPerc(mIProductBOMLine.getCostAllocationPerc());
        pp_productBOMLine.saveEx();
        mIProductBOMLine.setPP_Product_BOMLine_ID(pp_productBOMLine.get_ID());
        mIProductBOMLine.saveEx();
    }

    protected boolean check(X_I_Product_BomLine mIProductBOMLine) {
        String sIssueMethod;
        String sComponentType;
        String sBOMUse;
        String sMsg;
        Object[] args;
        String sMsg2;
        Object[] args2;
        Timestamp validFromLine;
        Timestamp validFrom;
        boolean bError = false;
        StringBuffer sbMsgError = new StringBuffer();
        String sName = mIProductBOMLine.getName();
        if (sName == null || sName.length() == 0) {
            Object[] args3 = new Object[]{Msg.getElement(this.getCtx(), "Name")};
            String sMsg3 = Msg.getMsg(this.getCtx(), AD_ERROR_MANDATORY_FIELD, args3);
            if (sbMsgError.length() != 0) {
                sbMsgError.append("\n");
            }
            sbMsgError.append(sMsg3);
            bError = true;
        }
        if ((validFrom = mIProductBOMLine.getValidFrom()) == null) {
            Object[] args4 = new Object[]{Msg.getElement(this.getCtx(), "ValidFrom")};
            String sMsg4 = Msg.getMsg(this.getCtx(), AD_ERROR_MANDATORY_FIELD, args4);
            if (sbMsgError.length() != 0) {
                sbMsgError.append("\n");
            }
            sbMsgError.append(sMsg4);
            bError = true;
        }
        if ((validFromLine = mIProductBOMLine.getValidFrom_Line()) == null) {
            Object[] args5 = new Object[]{Msg.getElement(this.getCtx(), "VALIDFROM_LINE")};
            String sMsg5 = Msg.getMsg(this.getCtx(), AD_ERROR_MANDATORY_FIELD, args5);
            if (sbMsgError.length() != 0) {
                sbMsgError.append("\n");
            }
            sbMsgError.append(sMsg5);
            bError = true;
        }
        String sChangeNoticeName = mIProductBOMLine.getMChangeNotice_Name();
        int iM_ChangeNotice_ID = 0;
        if (sChangeNoticeName != null && sChangeNoticeName.length() != 0) {
            iM_ChangeNotice_ID = this.getMChangeNoticeID(sChangeNoticeName);
            if (iM_ChangeNotice_ID > 0) {
                mIProductBOMLine.setM_ChangeNotice_ID(iM_ChangeNotice_ID);
                mIProductBOMLine.saveEx();
            } else {
                Object[] args6 = new Object[]{Msg.getElement(this.getCtx(), "M_ChangeNotice_ID")};
                String sMsg6 = Msg.getMsg(this.getCtx(), AD_ERROR_TRANSCODE_MESSAGE, args6);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg6);
                bError = true;
            }
        }
        String sValue = mIProductBOMLine.getValue();
        int iM_Product_ID = 0;
        if (sValue != null && sValue.length() != 0) {
            iM_Product_ID = this.getMProductID(sValue);
            if (iM_Product_ID > 0) {
                mIProductBOMLine.setM_Product_ID(iM_Product_ID);
                mIProductBOMLine.saveEx();
            }
        } else {
            args2 = new Object[]{Msg.getElement(this.getCtx(), "Value")};
            sMsg2 = Msg.getMsg(this.getCtx(), AD_ERROR_MANDATORY_FIELD, args2);
            if (sbMsgError.length() != 0) {
                sbMsgError.append("\n");
            }
            sbMsgError.append(sMsg2);
            bError = true;
        }
        if (iM_Product_ID <= 0) {
            args2 = new Object[]{Msg.getElement(this.getCtx(), "M_Product_ID")};
            sMsg2 = Msg.getMsg(this.getCtx(), AD_ERROR_TRANSCODE_MESSAGE, args2);
            if (sbMsgError.length() != 0) {
                sbMsgError.append("\n");
            }
            sbMsgError.append(sMsg2);
            bError = true;
        }
        String sX12DE355 = mIProductBOMLine.getX12DE355();
        int iC_UOM_ID = 0;
        if (sX12DE355 != null && sX12DE355.length() != 0) {
            iC_UOM_ID = this.getCUOMID(sX12DE355);
        } else {
            MProduct product = MProduct.get(this.getCtx(), iM_Product_ID);
            if (product != null) {
                iC_UOM_ID = product.getC_UOM_ID();
            }
        }
        if (iC_UOM_ID > 0) {
            mIProductBOMLine.setC_UOM_ID(iC_UOM_ID);
            mIProductBOMLine.saveEx();
        } else {
            Object[] args7 = new Object[]{Msg.getElement(this.getCtx(), "C_UOM_ID")};
            String sMsg7 = Msg.getMsg(this.getCtx(), AD_ERROR_TRANSCODE_MESSAGE, args7);
            if (sbMsgError.length() != 0) {
                sbMsgError.append("\n");
            }
            sbMsgError.append(sMsg7);
            bError = true;
        }
        String sChangeNoticeNameLine = mIProductBOMLine.getMChangeNotice_Line_Name();
        int iM_ChangeNotice_Line_ID = 0;
        if (sChangeNoticeNameLine != null && sChangeNoticeNameLine.length() != 0) {
            iM_ChangeNotice_Line_ID = this.getMChangeNoticeID(sChangeNoticeNameLine);
            if (iM_ChangeNotice_Line_ID > 0) {
                mIProductBOMLine.setM_ChangeNotice_Line_ID(iM_ChangeNotice_Line_ID);
                mIProductBOMLine.saveEx();
            } else {
                Object[] args8 = new Object[]{Msg.getElement(this.getCtx(), "M_CHANGENOTICE_LINE_ID")};
                String sMsg8 = Msg.getMsg(this.getCtx(), AD_ERROR_TRANSCODE_MESSAGE, args8);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg8);
                bError = true;
            }
        }
        String sValueLine = mIProductBOMLine.getValue_Line();
        int iM_Product_Line_ID = 0;
        if (sValueLine != null && sValueLine.length() != 0) {
            iM_Product_Line_ID = this.getMProductID(sValueLine);
            if (iM_Product_Line_ID > 0) {
                mIProductBOMLine.setM_Product_Line_ID(iM_Product_Line_ID);
                mIProductBOMLine.saveEx();
            } else {
                args = new Object[]{Msg.getElement(this.getCtx(), "M_PRODUCT_LINE_ID")};
                Msg.getElement(this.getCtx(), "M_PRODUCT_LINE_ID");
                sMsg = Msg.getMsg(this.getCtx(), AD_ERROR_TRANSCODE_MESSAGE, args);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg);
                bError = true;
            }
        } else {
            args = new Object[]{Msg.getElement(this.getCtx(), "VALUE_LINE")};
            sMsg = Msg.getMsg(this.getCtx(), AD_ERROR_MANDATORY_FIELD, args);
            if (sbMsgError.length() != 0) {
                sbMsgError.append("\n");
            }
            sbMsgError.append(sMsg);
            bError = true;
        }
        String sX12DE355_Line = mIProductBOMLine.getX12DE355_Line();
        int iC_UOM_Line_ID = 0;
        if (sX12DE355_Line != null && sX12DE355_Line.length() != 0) {
            iC_UOM_Line_ID = this.getCUOMID(sX12DE355_Line);
        } else {
            MProduct product = MProduct.get(this.getCtx(), iM_Product_Line_ID);
            if (product != null) {
                iC_UOM_Line_ID = product.getC_UOM_ID();
            }
        }
        if (iC_UOM_Line_ID > 0) {
            mIProductBOMLine.setC_UOM_Line_ID(iC_UOM_Line_ID);
            mIProductBOMLine.saveEx();
        } else {
            Object[] args9 = new Object[]{Msg.getElement(this.getCtx(), "C_UOM_LINE_ID")};
            String sMsg9 = Msg.getMsg(this.getCtx(), AD_ERROR_TRANSCODE_MESSAGE, args9);
            if (sbMsgError.length() != 0) {
                sbMsgError.append("\n");
            }
            sbMsgError.append(sMsg9);
            bError = true;
        }
        String sBOMType = mIProductBOMLine.getBOMType();
        if (!this.m_lstBOMType.contains(sBOMType)) {
            boolean bCheck = this.checkRefValue(this.m_AD_Reference_ID_BOM_Type, sBOMType);
            if (bCheck) {
                this.m_lstBOMType.add(sBOMType);
            } else {
                Object[] args10 = new Object[]{"BOMType", sBOMType};
                String sMsg10 = Msg.getMsg(this.getCtx(), AD_ERROR_INVALID_VALUE, args10);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg10);
                bError = true;
            }
        }
        if (!this.m_lstBOMUse.contains(sBOMUse = mIProductBOMLine.getBOMUse())) {
            boolean bCheck = this.checkRefValue(this.m_AD_Reference_ID_BOM_Use, sBOMUse);
            if (bCheck) {
                this.m_lstBOMUse.add(sBOMUse);
            } else {
                Object[] args11 = new Object[]{"BOMUse", sBOMUse};
                String sMsg11 = Msg.getMsg(this.getCtx(), AD_ERROR_INVALID_VALUE, args11);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg11);
                bError = true;
            }
        }
        if (!this.m_lstComponentType.contains(sComponentType = mIProductBOMLine.getComponentType())) {
            boolean bCheck = this.checkRefValue(this.m_AD_Reference_ID_ComponentType, sComponentType);
            if (bCheck) {
                this.m_lstComponentType.add(sComponentType);
            } else {
                Object[] args12 = new Object[]{"ComponentType", sComponentType};
                String sMsg12 = Msg.getMsg(this.getCtx(), AD_ERROR_INVALID_VALUE, args12);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg12);
                bError = true;
            }
        }
        if (!this.m_lstIssueMethod.contains(sIssueMethod = mIProductBOMLine.getIssueMethod())) {
            boolean bCheck = this.checkRefValue(this.m_AD_Reference_ID_IssueMethod, sIssueMethod);
            if (bCheck) {
                this.m_lstIssueMethod.add(sIssueMethod);
            } else {
                Object[] args13 = new Object[]{"IssueMethod", sIssueMethod};
                String sMsg13 = Msg.getMsg(this.getCtx(), AD_ERROR_INVALID_VALUE, args13);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg13);
                bError = true;
            }
        }
        mIProductBOMLine.setI_ErrorMsg(sbMsgError.toString());
        mIProductBOMLine.saveEx();
        return !bError;
    }

    protected int getMChangeNoticeID(String sChangeNoticeName) {
        int M_ChangeNotice_ID = 0;
        Query query = new Query(this.getCtx(), "M_ChangeNotice", "Name = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sChangeNoticeName);
        M_ChangeNotice_ID = query.firstId();
        return M_ChangeNotice_ID;
    }

    protected int getMProductID(String sProductValue) {
        int M_Product_ID = 0;
        Query query = new Query(this.getCtx(), "M_Product", "Value = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sProductValue);
        M_Product_ID = query.firstId();
        return M_Product_ID;
    }

    protected int getCUOMID(String sX12DE355) {
        int C_UOM_ID = 0;
        Query query = new Query(this.getCtx(), "C_UOM", "X12DE355 = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sX12DE355);
        C_UOM_ID = query.firstId();
        return C_UOM_ID;
    }

    protected int getPPProductBOMID(String sValue) {
        int PP_ProductBOM_ID = 0;
        Query query = new Query(this.getCtx(), "PP_Product_BOM", "Value = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sValue);
        PP_ProductBOM_ID = query.firstId();
        return PP_ProductBOM_ID;
    }

    protected int getPPProductBOMLineID(int PP_Product_BOM_ID, int iLine) {
        int PP_ProductBOMLine_ID = 0;
        Query query = new Query(this.getCtx(), "PP_Product_BOMLine", "PP_Product_BOM_ID = ? AND Line = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(PP_Product_BOM_ID, iLine);
        PP_ProductBOMLine_ID = query.firstId();
        return PP_ProductBOMLine_ID;
    }

    protected int getADReferenceID(String sName) {
        int AD_Reference_ID = 0;
        Query qRef = new Query(this.getCtx(), "AD_Reference", "Name = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sName);
        AD_Reference_ID = qRef.firstId();
        return AD_Reference_ID;
    }

    protected boolean checkRefValue(int AD_Reference_ID, String sValue) {
        boolean bError = false;
        MRefList refList = MRefList.get(this.getCtx(), AD_Reference_ID, sValue, this.get_TrxName());
        if (refList == null) {
            bError = true;
        }
        return !bError;
    }
}

