/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.process;

import com.f3p.adempiere.model.X_I_ForecastLine;
import java.sql.Timestamp;
import java.util.List;
import org.compiere.model.MForecast;
import org.compiere.model.MForecastLine;
import org.compiere.model.Query;
import org.compiere.process.SvrProcess;
import org.compiere.util.Msg;

public class ImportForecast
extends SvrProcess {
    private static final String AD_ERROR_TRANSCODE_MESSAGE = "F3P_Error_Transcode";
    private static final String AD_ERROR_IMPORT_FAILED = "F3P_Error_Import_Forecast";
    private static final String AD_ERROR_FORECAST_ALREADY_EXISTS = "F3P_Error_Forecast_Already_Exists";
    private static final String AD_ERROR_MANDATORY_FIELD = "F3P_Error_Mandatory_Field";

    @Override
    protected String doIt() throws Exception {
        String sMsgError = null;
        boolean bError = false;
        Query q = new Query(this.getCtx(), "I_ForecastLine", "I_IsImported='N'", this.get_TrxName());
        q.setOnlyActiveRecords(true).setApplyAccessFilter(true).setOrderBy("Name ASC, ProductValue ASC, DatePromised ASC");
        List lstForecasts = q.list();
        for (X_I_ForecastLine mIForecastLine : lstForecasts) {
            boolean bErr = !this.check(mIForecastLine);
            boolean bl = bError = bError || bErr;
        }
        if (!bError) {
            String sName = null;
            int iM_Forecast_ID = 0;
            for (X_I_ForecastLine mIForecastLine : lstForecasts) {
                if (sName == null) {
                    sName = mIForecastLine.getName();
                    iM_Forecast_ID = this.createForecast(mIForecastLine);
                } else if (!sName.equals(mIForecastLine.getName())) {
                    sName = mIForecastLine.getName();
                    iM_Forecast_ID = this.createForecast(mIForecastLine);
                }
                this.createForecastLine(mIForecastLine, iM_Forecast_ID);
                mIForecastLine.setProcessed(true);
                mIForecastLine.setProcessing(false);
                mIForecastLine.setI_IsImported(true);
                mIForecastLine.saveEx();
            }
        } else {
            sMsgError = Msg.getMsg(this.getCtx(), AD_ERROR_IMPORT_FAILED);
        }
        return sMsgError;
    }

    protected int createForecast(X_I_ForecastLine mIForecastLine) {
        MForecast mForecast = new MForecast(this.getCtx(), 0, this.get_TrxName());
        mForecast.setName(mIForecastLine.getName());
        mForecast.setDescription(mIForecastLine.getDescription());
        mForecast.setHelp(mIForecastLine.getHelp());
        mForecast.setC_Calendar_ID(mIForecastLine.getC_Calendar_ID());
        mForecast.setC_Year_ID(mIForecastLine.getC_Year_ID());
        mForecast.setM_PriceList_ID(mIForecastLine.getM_PriceList_ID());
        mForecast.setProcessing(false);
        mForecast.saveEx();
        mIForecastLine.setM_Forecast_ID(mForecast.get_ID());
        mIForecastLine.saveEx();
        return mForecast.get_ID();
    }

    protected int createForecastLine(X_I_ForecastLine mIForecastLine, int iM_Forecast_ID) {
        int iC_BP_Group_ID;
        MForecastLine mForecastLine = new MForecastLine(this.getCtx(), 0, this.get_TrxName());
        mForecastLine.setM_Forecast_ID(iM_Forecast_ID);
        mForecastLine.setC_Period_ID(mIForecastLine.getC_Period_ID());
        mForecastLine.setQty(mIForecastLine.getQty());
        mForecastLine.setQtyCalculated(mIForecastLine.getQty());
        mForecastLine.setM_Product_ID(mIForecastLine.getM_Product_ID());
        mForecastLine.setM_Warehouse_ID(mIForecastLine.getM_Warehouse_ID());
        mForecastLine.setDatePromised(mIForecastLine.getDatePromised());
        mForecastLine.setSalesRep_ID(mIForecastLine.getSalesRep_ID());
        int iC_BPartner_ID = mIForecastLine.getC_BPartner_ID();
        if (iC_BPartner_ID > 0) {
            mForecastLine.set_ValueOfColumn("C_BPARTNER_ID", (Object)iC_BPartner_ID);
        }
        if ((iC_BP_Group_ID = mIForecastLine.getC_BP_Group_ID()) > 0) {
            mForecastLine.set_ValueOfColumn("C_BP_GROUP_ID", (Object)iC_BP_Group_ID);
        }
        mForecastLine.saveEx();
        mIForecastLine.setM_Forecast_ID(iM_Forecast_ID);
        mIForecastLine.setM_ForecastLine_ID(mForecastLine.get_ID());
        mIForecastLine.saveEx();
        return mForecastLine.get_ID();
    }

    protected boolean check(X_I_ForecastLine mIForecastLine) {
        String sName;
        String sMsg;
        Object[] args;
        String sBPGroupValue;
        String sBPartnerValue;
        String sMsg2;
        Object[] args2;
        String sMsg3;
        Object[] args3;
        String sProductValue;
        String sMsg4;
        Object[] args4;
        String sPriceListName;
        String sMsg5;
        Object[] args5;
        String sMsg6;
        Object[] args6;
        boolean bError = false;
        StringBuffer sbMsgError = new StringBuffer();
        String sCalName = mIForecastLine.getCalName();
        int iC_Calendar_ID = 0;
        if (sCalName != null && sCalName.length() != 0) {
            iC_Calendar_ID = this.getCCalendarID(sCalName);
            if (iC_Calendar_ID > 0) {
                mIForecastLine.setC_Calendar_ID(iC_Calendar_ID);
                mIForecastLine.saveEx();
            } else {
                args6 = new Object[]{Msg.getElement(this.getCtx(), "C_Calendar_ID")};
                sMsg6 = Msg.getMsg(this.getCtx(), AD_ERROR_TRANSCODE_MESSAGE, args6);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg6);
                bError = true;
            }
        } else {
            args6 = new Object[]{Msg.getElement(this.getCtx(), "CalName")};
            sMsg6 = Msg.getMsg(this.getCtx(), AD_ERROR_MANDATORY_FIELD, args6);
            if (sbMsgError.length() != 0) {
                sbMsgError.append("\n");
            }
            sbMsgError.append(sMsg6);
            bError = true;
        }
        String sFiscalYear = mIForecastLine.getFiscalYear();
        int iC_Year_ID = 0;
        if (sFiscalYear != null && sFiscalYear.length() != 0) {
            if (iC_Calendar_ID > 0 && (iC_Year_ID = this.getCYearID(sFiscalYear, iC_Calendar_ID)) > 0) {
                mIForecastLine.setC_Year_ID(iC_Year_ID);
                mIForecastLine.saveEx();
            }
        } else {
            args5 = new Object[]{Msg.getElement(this.getCtx(), "FiscalYear")};
            sMsg5 = Msg.getMsg(this.getCtx(), AD_ERROR_MANDATORY_FIELD, args5);
            if (sbMsgError.length() != 0) {
                sbMsgError.append("\n");
            }
            sbMsgError.append(sMsg5);
            bError = true;
        }
        if (iC_Year_ID <= 0) {
            args5 = new Object[]{Msg.getElement(this.getCtx(), "C_Year_ID")};
            sMsg5 = Msg.getMsg(this.getCtx(), AD_ERROR_TRANSCODE_MESSAGE, args5);
            if (sbMsgError.length() != 0) {
                sbMsgError.append("\n");
            }
            sbMsgError.append(sMsg5);
            bError = true;
        }
        if ((sPriceListName = mIForecastLine.getPrList_Name()) != null && sPriceListName.length() != 0) {
            int iM_PriceList_ID = this.getMPriceListID(sPriceListName);
            if (iM_PriceList_ID > 0) {
                mIForecastLine.setM_PriceList_ID(iM_PriceList_ID);
                mIForecastLine.saveEx();
            } else {
                args4 = new Object[]{Msg.getElement(this.getCtx(), "M_PriceList_ID")};
                sMsg4 = Msg.getMsg(this.getCtx(), AD_ERROR_TRANSCODE_MESSAGE, args4);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg4);
                bError = true;
            }
        }
        if ((sProductValue = mIForecastLine.getProductValue()) != null && sProductValue.length() != 0) {
            int iM_Product_ID = this.getMProductID(sProductValue);
            if (iM_Product_ID > 0) {
                mIForecastLine.setM_Product_ID(iM_Product_ID);
                mIForecastLine.saveEx();
            } else {
                args3 = new Object[]{Msg.getElement(this.getCtx(), "M_Product_ID")};
                sMsg3 = Msg.getMsg(this.getCtx(), AD_ERROR_TRANSCODE_MESSAGE, args3);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg3);
                bError = true;
            }
        } else {
            args4 = new Object[]{Msg.getElement(this.getCtx(), "ProductValue")};
            sMsg4 = Msg.getMsg(this.getCtx(), AD_ERROR_MANDATORY_FIELD, args4);
            if (sbMsgError.length() != 0) {
                sbMsgError.append("\n");
            }
            sbMsgError.append(sMsg4);
            bError = true;
        }
        String sWarehouseValue = mIForecastLine.getWarehouseValue();
        if (sWarehouseValue != null && sWarehouseValue.length() != 0) {
            int iM_Warehouse_ID = this.getMWareHouseID(sWarehouseValue);
            if (iM_Warehouse_ID > 0) {
                mIForecastLine.setM_Warehouse_ID(iM_Warehouse_ID);
                mIForecastLine.saveEx();
            } else {
                Object[] args7 = new Object[]{Msg.getElement(this.getCtx(), "M_Warehouse_ID")};
                String sMsg7 = Msg.getMsg(this.getCtx(), AD_ERROR_TRANSCODE_MESSAGE, args7);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg7);
                bError = true;
            }
        } else {
            args3 = new Object[]{Msg.getElement(this.getCtx(), "WarehouseValue")};
            sMsg3 = Msg.getMsg(this.getCtx(), AD_ERROR_MANDATORY_FIELD, args3);
            if (sbMsgError.length() != 0) {
                sbMsgError.append("\n");
            }
            sbMsgError.append(sMsg3);
            bError = true;
        }
        String sSalesRepName = mIForecastLine.getSalesRepName();
        if (sSalesRepName != null && sSalesRepName.length() != 0) {
            int iAD_User_ID = this.getADUserID(sSalesRepName);
            if (iAD_User_ID > 0) {
                mIForecastLine.setSalesRep_ID(iAD_User_ID);
                mIForecastLine.saveEx();
            } else {
                Object[] args8 = new Object[]{Msg.getElement(this.getCtx(), "SalesRep_ID")};
                String sMsg8 = Msg.getMsg(this.getCtx(), AD_ERROR_TRANSCODE_MESSAGE, args8);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg8);
                bError = true;
            }
        }
        Timestamp datePromised = mIForecastLine.getDatePromised();
        int iC_Period_ID = 0;
        if (datePromised != null) {
            iC_Period_ID = this.getCPeriodID(iC_Year_ID, datePromised);
            if (iC_Period_ID > 0) {
                mIForecastLine.setC_Period_ID(iC_Period_ID);
                mIForecastLine.saveEx();
            }
        } else {
            args2 = new Object[]{Msg.getElement(this.getCtx(), "DatePromised")};
            sMsg2 = Msg.getMsg(this.getCtx(), AD_ERROR_MANDATORY_FIELD, args2);
            if (sbMsgError.length() != 0) {
                sbMsgError.append("\n");
            }
            sbMsgError.append(sMsg2);
            bError = true;
        }
        if (iC_Period_ID <= 0) {
            args2 = new Object[]{Msg.getElement(this.getCtx(), "C_Period_ID")};
            sMsg2 = Msg.getMsg(this.getCtx(), AD_ERROR_TRANSCODE_MESSAGE, args2);
            if (sbMsgError.length() != 0) {
                sbMsgError.append("\n");
            }
            sbMsgError.append(sMsg2);
            bError = true;
        }
        if ((sBPartnerValue = mIForecastLine.getBPartner_Value()) != null && sBPartnerValue.length() != 0) {
            int iC_BPartner_ID = this.getCBPartnerID(sBPartnerValue);
            if (iC_BPartner_ID > 0) {
                mIForecastLine.setC_BPartner_ID(iC_BPartner_ID);
                mIForecastLine.saveEx();
            } else {
                Object[] args9 = new Object[]{Msg.getElement(this.getCtx(), "C_BPartner_ID")};
                String sMsg9 = Msg.getMsg(this.getCtx(), AD_ERROR_TRANSCODE_MESSAGE, args9);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg9);
                bError = true;
            }
        }
        if ((sBPGroupValue = mIForecastLine.getGroupValue()) != null && sBPGroupValue.length() != 0) {
            int iC_BPGroup_ID = this.getCBPGroupID(sBPGroupValue);
            if (iC_BPGroup_ID > 0) {
                mIForecastLine.setC_BP_Group_ID(iC_BPGroup_ID);
                mIForecastLine.saveEx();
            } else {
                args = new Object[]{Msg.getElement(this.getCtx(), "C_BP_Group_ID")};
                sMsg = Msg.getMsg(this.getCtx(), AD_ERROR_TRANSCODE_MESSAGE, args);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg);
                bError = true;
            }
        }
        if ((sName = mIForecastLine.getName()) != null && sName.length() != 0) {
            int iM_Forecast_ID = this.getMForecastID(sName);
            if (iM_Forecast_ID > 0) {
                sMsg = Msg.getMsg(this.getCtx(), AD_ERROR_FORECAST_ALREADY_EXISTS);
                if (sbMsgError.length() != 0) {
                    sbMsgError.append("\n");
                }
                sbMsgError.append(sMsg);
                bError = true;
            }
        } else {
            args = new Object[]{Msg.getElement(this.getCtx(), "Name")};
            sMsg = Msg.getMsg(this.getCtx(), AD_ERROR_MANDATORY_FIELD, args);
            if (sbMsgError.length() != 0) {
                sbMsgError.append("\n");
            }
            sbMsgError.append(sMsg);
            bError = true;
        }
        mIForecastLine.setI_ErrorMsg(sbMsgError.toString());
        mIForecastLine.saveEx();
        return !bError;
    }

    protected int getCCalendarID(String sCalName) {
        int C_Calendar_ID = 0;
        Query qRef = new Query(this.getCtx(), "C_Calendar", "Name = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sCalName);
        C_Calendar_ID = qRef.firstId();
        return C_Calendar_ID;
    }

    protected int getCYearID(String sFiscalYear, int C_Calendar_ID) {
        int C_Year_ID = 0;
        Query qRef = new Query(this.getCtx(), "C_Year", "C_Calendar_ID = ? AND FiscalYear = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(C_Calendar_ID, sFiscalYear);
        C_Year_ID = qRef.firstId();
        return C_Year_ID;
    }

    protected int getMPriceListID(String sPriceListName) {
        int M_PriceList_ID = 0;
        Query qRef = new Query(this.getCtx(), "M_PriceList", "Name = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sPriceListName);
        M_PriceList_ID = qRef.firstId();
        return M_PriceList_ID;
    }

    protected int getMProductID(String sProductValue) {
        int M_Product_ID = 0;
        Query qRef = new Query(this.getCtx(), "M_Product", "Value = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sProductValue);
        M_Product_ID = qRef.firstId();
        return M_Product_ID;
    }

    protected int getMWareHouseID(String sWareHouseValue) {
        int M_WareHouse_ID = 0;
        Query qRef = new Query(this.getCtx(), "M_Warehouse", "Value = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sWareHouseValue);
        M_WareHouse_ID = qRef.firstId();
        return M_WareHouse_ID;
    }

    protected int getADUserID(String sName) {
        int AD_USER_ID = 0;
        Query qRef = new Query(this.getCtx(), "AD_User", "Name = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sName);
        AD_USER_ID = qRef.firstId();
        return AD_USER_ID;
    }

    protected int getCPeriodID(int iC_Year_ID, Timestamp datePromised) {
        int C_PERIOD_ID = 0;
        Query qRef = new Query(this.getCtx(), "C_Period", "C_YEAR_ID = ? AND trunc(?) BETWEEN StartDate AND EndDate", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(iC_Year_ID, datePromised);
        C_PERIOD_ID = qRef.firstId();
        return C_PERIOD_ID;
    }

    protected int getCBPartnerID(String sBPartnerValue) {
        int C_BPartner_ID = 0;
        Query qRef = new Query(this.getCtx(), "C_BPartner", "Value = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sBPartnerValue);
        C_BPartner_ID = qRef.firstId();
        return C_BPartner_ID;
    }

    protected int getCBPGroupID(String sBPGroupValue) {
        int C_BP_Group_ID = 0;
        Query qRef = new Query(this.getCtx(), "C_BP_Group", "Value = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sBPGroupValue);
        C_BP_Group_ID = qRef.firstId();
        return C_BP_Group_ID;
    }

    protected int getMForecastID(String sName) {
        int M_Forecast_ID = 0;
        Query qRef = new Query(this.getCtx(), "M_Forecast", "Name = ?", this.get_TrxName()).setApplyAccessFilter(true).setOnlyActiveRecords(true).setParameters(sName);
        M_Forecast_ID = qRef.firstId();
        return M_Forecast_ID;
    }

    @Override
    protected void prepare() {
    }
}

