/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.process;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.compiere.Adempiere;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class CustomerInstallationDetails
extends SvrProcess {
    protected static final String SQL_2PACK = "SELECT a.Name,a.PK_Version  from ad_package_imp a where a.updated = (SELECT MAX(b.Updated) FROM ad_package_imp B Where b.name=a.name)  order by Created ";

    @Override
    protected String doIt() throws Exception {
        StringBuilder sbResult = new StringBuilder("<br>");
        this.buildHTMLLine(sbResult, "2Pack:");
        sbResult.append("<br>");
        this.read2PackList(sbResult);
        sbResult.append("<br>");
        this.buildHTMLLine(sbResult, "Packages:");
        sbResult.append("<br>");
        this.readPackage(sbResult, "packages");
        sbResult.append("<br>");
        this.buildHTMLLine(sbResult, "Packages ZK Web UI:");
        sbResult.append("<br>");
        this.readPackage(sbResult, "zkpackages");
        return sbResult.toString();
    }

    protected void read2PackList(StringBuilder sb2PackList) throws SQLException {
        CPreparedStatement pstmt = DB.prepareStatement(SQL_2PACK, this.get_TrxName());
        ResultSet rs = null;
        try {
            rs = pstmt.executeQuery();
            while (rs.next()) {
                this.buildHTMLLine(sb2PackList, rs.getString("Name"), rs.getString("PK_Version"));
            }
        }
        finally {
            DB.close(rs, pstmt);
        }
    }

    protected void readPackage(StringBuilder sbDirList, String sDir) {
        File fRoot = new File(Adempiere.getAdempiereHome(), sDir);
        if (fRoot.exists() && fRoot.isDirectory()) {
            ArrayList<File> lstFiles = new ArrayList<File>();
            lstFiles.addAll(Arrays.asList(fRoot.listFiles()));
            Collections.sort(lstFiles);
            for (File fDir : lstFiles) {
                this.buildHTMLLine(sbDirList, fDir.getName());
            }
        } else {
            sbDirList.append(String.valueOf(fRoot.toString()) + " inexhistant or not a directory");
        }
    }

    protected void buildHTMLLine(StringBuilder sbAccum, String ... strings) {
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String sVal = stringArray[n2];
            sbAccum.append(sVal).append("&nbsp;");
            ++n2;
        }
        sbAccum.append(" ** ");
    }

    @Override
    protected void prepare() {
    }
}

