/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.adempiere.exceptions.AdempiereException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.compiere.impexp.ImpFormat;
import org.compiere.model.MSysConfig;
import org.compiere.process.ImportConversionRate;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class ConversionRateImportBancaItalia
extends ImportConversionRate {
    public static final String URL_MSG = "F3P_EXCHANGERATEIMPORTURL";
    public static final String SYSC_IMPFORMAT_NAME = "F3P_CONVERSIONRATEIMPORT_IMPFORMAT";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy");
    private static final String SQL_DEL_OLDRECORDS = "DELETE FROM I_CONVERSION_RATE WHERE AD_Client_ID = ?";
    protected String m_sCsvURL = null;
    protected String m_sDateFrom = null;
    protected String m_sDateTo = null;
    protected ImpFormat m_impFormat = null;
    protected int m_iAD_Client_ID = -1;
    protected boolean m_bDeleteOldRecords = false;

    @Override
    protected String doIt() throws Exception {
        if (this.m_bDeleteOldRecords && this.m_iAD_Client_ID > 0) {
            DB.executeUpdate(SQL_DEL_OLDRECORDS, this.m_iAD_Client_ID, this.get_TrxName());
        }
        DefaultHttpClient httpClient = new DefaultHttpClient();
        String sCsv = null;
        try {
            HttpGet get = new HttpGet(this.m_sCsvURL);
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            sCsv = (String)httpClient.execute((HttpUriRequest)get, (ResponseHandler)responseHandler);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        int iLines = -1;
        if (sCsv != null) {
            StringReader stringReader = new StringReader(sCsv);
            BufferedReader reader = new BufferedReader(stringReader);
            iLines = this.processCSV(reader);
            reader.close();
            stringReader.close();
        }
        if (iLines > 0) {
            return super.doIt();
        }
        return "";
    }

    @Override
    protected void prepare() {
        super.prepare();
        int AD_Org_ID = 0;
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Client_ID")) {
                    this.m_iAD_Client_ID = para[i].getParameterAsInt();
                } else if (name.equals("AD_Org_ID")) {
                    AD_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("DeleteOldImported")) {
                    this.m_bDeleteOldRecords = para[i].getParameterAsBoolean();
                }
            }
            ++i;
        }
        String sImpFormatName = MSysConfig.getValue(SYSC_IMPFORMAT_NAME, this.m_iAD_Client_ID, AD_Org_ID);
        this.m_impFormat = ImpFormat.load(sImpFormatName);
        if (this.m_impFormat == null) {
            throw new AdempiereException("ImpFormat '" + sImpFormatName + "' @Invalid@");
        }
        String sUrlMsg = Msg.getMsg(Env.getCtx(), URL_MSG);
        Calendar calToday = TimeUtil.getToday();
        Date dtToday = calToday.getTime();
        this.m_sCsvURL = MessageFormat.format(sUrlMsg, dtToday);
        this.m_sDateFrom = DATE_FORMAT.format(dtToday);
        if (calToday.get(7) == 6) {
            Timestamp tsToday = new Timestamp(calToday.getTimeInMillis());
            this.m_sDateTo = DATE_FORMAT.format(TimeUtil.addDays(tsToday, 2));
        }
    }

    protected int processCSV(BufferedReader reader) throws IOException {
        boolean bHdrLineFound = false;
        int iLines = 0;
        String sDelim = null;
        String sLine = null;
        if (this.m_impFormat.getFormatType().equals("C")) {
            sDelim = ",";
        } else if (this.m_impFormat.getFormatType().equals("T")) {
            sDelim = "\t";
        } else if (this.m_impFormat.getFormatType().equals("U")) {
            sDelim = this.m_impFormat.getSeparatorChar();
        }
        StringBuilder sbPrefix = new StringBuilder(this.m_sDateFrom);
        sbPrefix.append(sDelim).append(this.m_sDateTo).append(sDelim);
        String sDatePrefix = sbPrefix.toString();
        while ((sLine = reader.readLine()) != null) {
            if (sLine.indexOf(sDelim) < 0) continue;
            if (bHdrLineFound) {
                sLine = String.valueOf(sDatePrefix) + sLine;
                if (!this.m_impFormat.updateDB(this.getCtx(), sLine, this.get_TrxName())) continue;
                ++iLines;
                continue;
            }
            bHdrLineFound = true;
        }
        return iLines;
    }
}

