/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.process;

import com.f3p.adempiere.mail.MailProcess;
import com.f3p.adempiere.report.ReportProcess;
import com.f3p.adempiere.util.IDResolver;
import com.f3p.adempiere.util.ProcessHelper;
import com.f3p.commons.JDBCUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Properties;
import org.compiere.model.MInvoice;
import org.compiere.model.MRole;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class CompleteSalesInvoicesProcess
extends MailProcess {
    public static final String WINDOWNAME = "Invoice (Customer)";
    public static final String TABNAME = "Invoice";
    public static final String MSG_ALREADY_RUNNING = "F3P_Process_Already_Run";
    public static final String MSG_GENERIC_OK = "F3P_Generic_Ok";
    public static final String MSG_GENERIC_ERROR = "F3P_Generic_Error";
    public static final String MSG_MAIL_ERROR = "F3P_Mail_Error";
    public static final String MSG_PRINT_ERROR = "F3P_Print_Error";
    public static final String SQL_MAIL = "SELECT C_Invoice.DOCUMENTNO AS Num_Fattura, C_Invoice.DATEINVOICED, C_Bpartner.NAME Ragione_Sociale, C_Bpartner_Location.NAME Indirizzo_BP, ubp.NAME Nome_Contatto, uint.NAME Utente_Int, uint.EMAIL Email_Utente_Int, uint.PHONE Tel_Utente_Int, uint.PHONE2 Tel2_Utente_Int, uint.FAX Fax_Utente_Int, C_Job.NAME Posizione_Utente_Int FROM C_Invoice, C_Bpartner, C_Bpartner_Location, AD_User ubp, AD_User uint, C_Job WHERE C_Invoice.C_INVOICE_ID = ? and C_Bpartner.C_BPARTNER_ID = C_Invoice.C_BPARTNER_ID and C_Bpartner_Location.C_BPARTNER_LOCATION_ID = C_Invoice.C_BPARTNER_LOCATION_ID and ubp.AD_USER_ID(+) = C_Invoice.AD_USER_ID and uint.AD_USER_ID = ? and C_Job.C_JOB_ID(+) = uint.C_JOB_ID";
    private static final String PARAM_BPartner = "C_BPartner_ID";
    private static final String PARAM_Invoice = "C_Invoice_ID";
    private static final String PARAM_Data = "Data";
    private static final String PARAM_DocumentNo = "DocumentNo";
    private static final String PARAM_InvioMail = "InvioMail";
    private static final String PARAM_Stampa = "Stampa";
    private static final String PARAM_DocType = "C_DocType_ID";
    private static final String PARAM_MAIL_TEMPLATE = "R_MailText_ID";
    private static final String TAG_STAMPA = "elaborazione";
    private int C_BPartner_ID = -1;
    private int C_Invoice_ID = -1;
    private int C_DocType_ID = -1;
    private Timestamp m_tsDataDa = null;
    private Timestamp m_tsDataA = null;
    private String m_sNumeroDocDa = null;
    private String m_sNumeroDocA = null;
    private boolean m_bInvioMail = false;
    private MailProcess m_processMail = null;
    private ReportProcess m_processPrint = null;
    private Properties m_ctx = null;
    private int m_R_MailText_ID = -1;
    private LinkedList<InvoiceElement> m_lstInvoice = new LinkedList();

    public CompleteSalesInvoicesProcess() {
        this.setAutoSend(true);
        this.setReportKeyName(PARAM_Invoice);
        this.setFirstOnly(false);
        this.setTagFilter(TAG_STAMPA);
    }

    @Override
    protected String doIt() throws Exception {
        if (ProcessHelper.isProcessInstanceRunning(this.getProcessInfo(), this.m_ctx, this.get_TrxName(), true)) {
            return Msg.getMsg(Env.getCtx(), MSG_ALREADY_RUNNING);
        }
        QueryInfo qInfo = this.prepareQuery();
        CPreparedStatement pstmt = DB.prepareStatement(qInfo.sQuery, this.get_TrxName());
        ResultSet rs = null;
        int i = 1;
        for (Object o : qInfo.alParams) {
            pstmt.setObject(i++, o);
        }
        rs = pstmt.executeQuery();
        boolean bCompletedError = false;
        while (rs.next()) {
            String sNumFattura = rs.getString("DOCUMENTNO");
            MInvoice invoice = null;
            try {
                invoice = new MInvoice(this.getCtx(), rs, this.get_TrxName());
                int nCopie = rs.getInt("DOCUMENTCOPIES");
                if (rs.wasNull()) {
                    nCopie = 3;
                }
                if (!invoice.getDocStatus().equals("CO")) {
                    String status = invoice.completeIt();
                    invoice.setDocStatus(status);
                    invoice.saveEx();
                }
                this.m_lstInvoice.add(new InvoiceElement(invoice, nCopie));
            }
            catch (Exception e) {
                this.addLog(String.valueOf(Msg.getMsg(this.m_ctx, MSG_GENERIC_ERROR)) + " docNo: " + sNumFattura);
                bCompletedError = true;
            }
        }
        JDBCUtils.closeResults(pstmt, rs);
        if (!bCompletedError) {
            for (InvoiceElement invoiceElem : this.m_lstInvoice) {
                MInvoice invoice = invoiceElem.getInvoice();
                int nCopie = invoiceElem.getCopie();
                boolean bMailSuccess = false;
                boolean bPrintSuccess = false;
                try {
                    String sPrintRet;
                    if (this.m_bInvioMail && invoice.isSendEMail() && invoice.getAD_User_ID() > 0) {
                        --nCopie;
                        Env.clearWinContext(this.m_processMail.getWindowNo());
                        this.m_processMail.getProcessInfo().setRecord_ID(invoice.getC_Invoice_ID());
                        this.m_processMail.pushEnvRawSql(SQL_MAIL, true);
                        if (this.m_processMail.sendMail(invoice.getC_BPartner_ID(), invoice.getAD_User_ID(), this.m_R_MailText_ID)) {
                            bMailSuccess = true;
                        }
                    }
                    if ((sPrintRet = this.doPrint(invoice.getC_Invoice_ID(), nCopie)) == null) continue;
                    this.addLog(String.valueOf(Msg.getMsg(this.m_ctx, MSG_PRINT_ERROR)) + " " + invoice.getDocumentNo() + ": " + sPrintRet);
                }
                catch (Exception e) {
                    if (!bMailSuccess && this.m_bInvioMail && invoice.isSendEMail() && invoice.getAD_User_ID() > 0) {
                        this.addLog(String.valueOf(Msg.getMsg(this.m_ctx, MSG_MAIL_ERROR)) + " " + invoice.getDocumentNo() + ": " + e.getMessage());
                    }
                    if (bPrintSuccess || this.m_processPrint == null) continue;
                    this.addLog(String.valueOf(Msg.getMsg(this.m_ctx, MSG_PRINT_ERROR)) + " " + invoice.getDocumentNo() + ": " + e.getMessage());
                }
            }
        } else {
            return "@Error@";
        }
        return "";
    }

    protected String doPrint(int C_Invoice_ID, int nCopie) throws SQLException {
        StringBuffer sbRetPrint = new StringBuffer();
        if (this.m_processPrint != null) {
            Env.clearWinContext(this.m_processPrint.getWindowNo());
            this.m_processPrint.getProcessInfo().setRecord_ID(C_Invoice_ID);
            this.m_processPrint.pushEnvRawSql("SELECT * FROM C_Invoice WHERE C_Invoice_ID = ?", false);
            while (nCopie-- > 0) {
                String sRepRet = this.m_processPrint.doPrint();
                if (sRepRet == null || sRepRet.length() <= 0) continue;
                sbRetPrint.append(sRepRet).append('\n');
            }
        }
        if (sbRetPrint.length() == 0) {
            return null;
        }
        return sbRetPrint.toString();
    }

    protected QueryInfo prepareQuery() {
        QueryInfo qInfo = new QueryInfo();
        StringBuffer sBaseSQL = new StringBuffer("SELECT C_Invoice.*,C_BPartner.DOCUMENTCOPIES,C_BPartner.SALESREP_ID FROM C_Invoice,C_BPartner  WHERE C_Invoice.C_BPartner_ID = C_BPartner.C_BPartner_ID  AND C_Invoice.IsActive = 'Y' AND C_Invoice.DocStatus NOT IN ('IN','VO','RE') ");
        if (this.C_Invoice_ID > 0) {
            sBaseSQL.append(" AND C_Invoice.C_Invoice_ID = ?");
            qInfo.alParams.add(this.C_Invoice_ID);
        } else {
            if (this.m_tsDataDa != null) {
                sBaseSQL.append(" AND C_Invoice.DateInvoiced >= ?");
                qInfo.alParams.add(this.m_tsDataDa);
            }
            if (this.m_tsDataA != null) {
                sBaseSQL.append(" AND C_Invoice.DateInvoiced <= ?");
                qInfo.alParams.add(this.m_tsDataA);
            }
            if (this.C_BPartner_ID > 0) {
                sBaseSQL.append(" AND C_BPartner.C_BPartner_ID = ?");
                qInfo.alParams.add(this.C_BPartner_ID);
            }
            if (this.C_DocType_ID > 0) {
                sBaseSQL.append(" AND C_Invoice.C_DocTypeTarget_ID = ?");
                qInfo.alParams.add(this.C_DocType_ID);
            }
            if (this.m_sNumeroDocDa != null) {
                sBaseSQL.append(" AND C_Invoice.DocumentNo >= ?");
                qInfo.alParams.add(this.m_sNumeroDocDa);
            }
            if (this.m_sNumeroDocA != null) {
                sBaseSQL.append(" AND C_Invoice.DocumentNo <= ?");
                qInfo.alParams.add(this.m_sNumeroDocA);
            }
        }
        qInfo.sQuery = MRole.getDefault().addAccessSQL(sBaseSQL.toString(), "C_Invoice", true, false);
        return qInfo;
    }

    @Override
    public void prepare() {
        ProcessInfoParameter[] pParam = this.getParameter();
        int nTabId = IDResolver.getAD_Tab_ID(WINDOWNAME, TABNAME);
        this.m_ctx = this.getCtx();
        ProcessInfoParameter[] processInfoParameterArray = pParam;
        int n = pParam.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter param = processInfoParameterArray[n2];
            if (param.getParameterName().equals(PARAM_BPartner)) {
                this.C_BPartner_ID = param.getParameterAsInt();
            } else if (param.getParameterName().equals(PARAM_Invoice)) {
                this.C_Invoice_ID = param.getParameterAsInt();
            } else if (param.getParameterName().equals(PARAM_Data)) {
                this.m_tsDataDa = (Timestamp)param.getParameter();
                this.m_tsDataA = (Timestamp)param.getParameter_To();
                if (this.m_tsDataA == null) {
                    this.m_tsDataA = this.m_tsDataDa;
                }
            } else if (param.getParameterName().equals(PARAM_DocumentNo)) {
                this.m_sNumeroDocDa = (String)param.getParameter();
                this.m_sNumeroDocA = (String)param.getParameter_To();
                if (this.m_sNumeroDocA == null) {
                    this.m_sNumeroDocA = this.m_sNumeroDocDa;
                }
            } else if (param.getParameterName().equals(PARAM_InvioMail)) {
                this.m_bInvioMail = param.getParameter().equals("Y");
                if (this.m_bInvioMail) {
                    this.m_processMail = new MailProcess();
                    this.m_processMail.setParentProcess(this);
                    this.m_processMail.setTagFilter(TAG_STAMPA);
                    this.m_processMail.setFirstOnly(false);
                    this.m_processMail.prepareFromTab(nTabId, 0, this.get_TrxName());
                    this.m_processMail.setReportKeyName(PARAM_Invoice);
                    this.m_processMail.getProcessInfo().setAD_PInstance_ID(this.getAD_PInstance_ID());
                    this.m_processMail.setTrx(Trx.get(this.get_TrxName(), false));
                }
            } else if (param.getParameterName().equals(PARAM_DocType)) {
                this.C_DocType_ID = param.getParameterAsInt();
            } else if (param.getParameterName().equals(PARAM_MAIL_TEMPLATE)) {
                this.m_R_MailText_ID = param.getParameterAsInt();
            } else if (param.getParameterName().equals(PARAM_Stampa) && param.getParameter().equals("Y") && ReportProcess.hasReportProcess(this.getCtx(), nTabId, this.get_TrxName())) {
                this.m_processPrint = new ReportProcess();
                this.m_processPrint.setParentProcess(this);
                this.m_processPrint.setTagFilter(TAG_STAMPA);
                this.m_processPrint.prepareFromTab(nTabId, 0, this.get_TrxName());
                this.m_processPrint.setReportKeyName(PARAM_Invoice);
                this.m_processPrint.setFirstOnly(false);
                this.m_processPrint.setTrx(Trx.get(this.get_TrxName(), false));
                this.m_processPrint.setDirectPrint(true);
            }
            ++n2;
        }
        super.prepare();
    }

    private class InvoiceElement {
        private MInvoice m_invoice;
        private int m_nCopie;

        public InvoiceElement(MInvoice invoice, int copie) {
            this.m_invoice = invoice;
            this.m_nCopie = copie;
        }

        public MInvoice getInvoice() {
            return this.m_invoice;
        }

        public int getCopie() {
            return this.m_nCopie;
        }
    }

    private class QueryInfo {
        String sQuery = null;
        ArrayList<Object> alParams = new ArrayList();

        private QueryInfo() {
        }
    }
}

