/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.primanota.form;

import com.f3p.adempiere.primanota.form.Allocation;
import com.f3p.adempiere.util.EnvHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.RowFilter;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.APanel;
import org.compiere.apps.AWindow;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VString;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.compiere.util.Util;

public class VAllocation
extends Allocation
implements FormPanel,
ActionListener,
TableModelListener,
VetoableChangeListener {
    private CPanel panel = new CPanel();
    private APanel m_windowPanel = null;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel parameterPanel = new CPanel();
    private CPanel allocationPanel = new CPanel();
    private GridBagLayout parameterLayout = new GridBagLayout();
    private JLabel bpartnerLabel = new JLabel();
    private VLookup bpartnerSearch = null;
    private MiniTable invoiceTable = new MiniTable();
    private CPanel invoicePanel = new CPanel();
    private JLabel invoiceLabel = new JLabel();
    private BorderLayout invoiceLayout = new BorderLayout();
    private JLabel invoiceInfo = new JLabel();
    private JScrollPane invoiceScrollPane = new JScrollPane();
    private GridBagLayout allocationLayout = new GridBagLayout();
    private JLabel differenceLabel = new JLabel();
    private CTextField differenceField = new CTextField();
    private JButton allocateButton = new JButton();
    private JLabel currencyLabel = new JLabel();
    private VLookup currencyPick = null;
    private JCheckBox multiCurrency = new JCheckBox();
    private JLabel allocCurrencyLabel = new JLabel();
    private StatusBar statusBar = new StatusBar();
    private JLabel dateLabel = new JLabel();
    private VDate dateField = new VDate();
    private JLabel organizationLabel = new JLabel();
    private VLookup organizationPick = null;
    private JLabel filterBPartnerLabel = new CLabel(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
    private JLabel filterLabel = new CLabel(String.valueOf(Msg.translate(Env.getCtx(), "filter.by")) + ":");
    private JLabel filterDocNoLabel = new CLabel(Msg.translate(Env.getCtx(), "DocumentNo"));
    private VLookup filterBPartnerSearch = null;
    private VString filterDocNo = null;
    private TableRowSorter<DefaultTableModel> filterRowSorter = null;

    @Override
    public void init(int WindowNo, FormFrame frame) {
        AWindow focusAWindow = EnvHelper.getFocusAWindow();
        if (focusAWindow != null) {
            this.m_windowPanel = focusAWindow.getAPanel();
        }
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        Env.setContext(Env.getCtx(), this.m_WindowNo, "IsSOTrx", "Y");
        try {
            this.dynInit();
            this.jbInit();
            this.calculate();
            frame.getContentPane().add((Component)this.mainPanel, "Center");
            frame.getContentPane().add((Component)this.statusBar, "South");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground(this.panel);
        this.mainPanel.setLayout(this.mainLayout);
        this.parameterPanel.setLayout(this.parameterLayout);
        this.allocationPanel.setLayout(this.allocationLayout);
        this.bpartnerLabel.setText(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        this.invoiceLabel.setRequestFocusEnabled(false);
        this.invoiceLabel.setText(" " + Msg.translate(Env.getCtx(), "C_Invoice_ID"));
        this.invoicePanel.setLayout(this.invoiceLayout);
        this.invoiceInfo.setHorizontalAlignment(4);
        this.invoiceInfo.setHorizontalTextPosition(4);
        this.invoiceInfo.setText(".");
        this.differenceLabel.setText(Msg.getMsg(Env.getCtx(), "Difference"));
        this.differenceField.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.differenceField.setEditable(false);
        this.differenceField.setText("0");
        this.differenceField.setColumns(8);
        this.differenceField.setHorizontalAlignment(4);
        this.allocateButton.setText(Msg.getMsg(Env.getCtx(), "Process"));
        this.allocateButton.addActionListener(this);
        this.currencyLabel.setText(Msg.translate(Env.getCtx(), "C_Currency_ID"));
        this.multiCurrency.setText(Msg.getMsg(Env.getCtx(), "MultiCurrency"));
        this.multiCurrency.addActionListener(this);
        this.allocCurrencyLabel.setText(".");
        this.invoiceScrollPane.setPreferredSize(new Dimension(600, 400));
        this.mainPanel.add((Component)this.parameterPanel, "North");
        this.organizationLabel.setText(Msg.translate(Env.getCtx(), "AD_Org_ID"));
        this.parameterPanel.add((Component)this.organizationLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.organizationPick, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.bpartnerLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.bpartnerSearch, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateField, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.currencyLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.currencyPick, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.multiCurrency, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.filterLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.filterBPartnerLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.filterBPartnerSearch, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.filterDocNoLabel, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.filterDocNo, new GridBagConstraints(4, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.allocationPanel, "South");
        this.allocationPanel.add((Component)this.differenceLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.allocationPanel.add((Component)this.differenceField, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.allocationPanel.add((Component)this.allocateButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.allocationPanel.add((Component)this.allocCurrencyLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.invoicePanel.add((Component)this.invoiceLabel, "North");
        this.invoicePanel.add((Component)this.invoiceInfo, "South");
        this.invoicePanel.add((Component)this.invoiceScrollPane, "Center");
        this.invoiceScrollPane.getViewport().add((Component)this.invoiceTable, null);
        this.mainPanel.add((Component)this.invoicePanel, "Center");
        this.mainPanel.setPreferredSize(new Dimension(1050, 600));
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    public void dynInit() throws Exception {
        int PNG_JournalLine_ID = this.m_frame.getProcessInfo().getRecord_ID();
        this.dynInit(PNG_JournalLine_ID);
        this.m_C_Currency_ID = this.m_mPNGJournalLine.getParent().getC_Currency_ID();
        int AD_Column_ID = 3505;
        MLookup lookupCur = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, AD_Column_ID, 19);
        this.currencyPick = new VLookup("C_Currency_ID", true, false, true, lookupCur);
        this.currencyPick.setValue(new Integer(this.m_C_Currency_ID));
        this.currencyPick.addVetoableChangeListener(this);
        this.currencyPick.setReadWrite(false);
        AD_Column_ID = 839;
        MLookup lookupOrg = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, AD_Column_ID, 19);
        this.organizationPick = new VLookup("AD_Org_ID", true, false, true, lookupOrg);
        this.organizationPick.setValue(Env.getAD_Org_ID(Env.getCtx()));
        this.organizationPick.addVetoableChangeListener(this);
        AD_Column_ID = 3499;
        MLookup lookupBP = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, AD_Column_ID, 30);
        this.bpartnerSearch = new VLookup("C_BPartner_ID", false, false, true, lookupBP);
        this.bpartnerSearch.addVetoableChangeListener(this);
        this.statusBar.setStatusLine("");
        this.statusBar.setStatusDB("");
        this.dateField.setValue(this.m_mPNGJournalLine.getDateAcct());
        this.dateField.addVetoableChangeListener(this);
        this.filterBPartnerSearch = new VLookup("C_BPartner_ID", false, false, true, lookupBP);
        this.filterBPartnerSearch.addVetoableChangeListener(this);
        this.filterDocNo = new VString("filter_DocumentNo", false, false, true, 30, 30, "", null);
        this.filterDocNo.addVetoableChangeListener(this);
        if (this.m_mPNGJournalLine.isInvEntryDr()) {
            if (this.m_mPNGJournalLine.getC_BPartnerDr_ID() > 0) {
                this.m_C_BPartner_ID = this.m_mPNGJournalLine.getC_BPartnerDr_ID();
                this.bpartnerSearch.setValue(this.m_C_BPartner_ID);
                this.bpartnerSearch.setReadWrite(false);
                this.loadBPartner();
            }
            this.Account_ID = this.m_mPNGJournalLine.getAccountDr_ID();
        } else {
            if (this.m_mPNGJournalLine.getC_BPartnerCr_ID() > 0) {
                this.m_C_BPartner_ID = this.m_mPNGJournalLine.getC_BPartnerCr_ID();
                this.bpartnerSearch.setValue(this.m_C_BPartner_ID);
                this.bpartnerSearch.setReadWrite(false);
                this.loadBPartner();
            }
            this.Account_ID = this.m_mPNGJournalLine.getAccountCr_ID();
        }
        this.calculate();
        this.loadBPartner();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.config("");
        if (e.getSource().equals(this.multiCurrency)) {
            this.loadBPartner();
        } else if (e.getSource().equals(this.allocateButton)) {
            this.allocateButton.setEnabled(false);
            this.saveData();
            this.dispose();
            if (this.m_windowPanel != null) {
                this.m_windowPanel.getCurrentTab().dataRefresh();
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        boolean isInvoice;
        int col;
        boolean isUpdate;
        boolean bl = isUpdate = e.getType() == 0;
        if (!isUpdate) {
            this.calculate();
            return;
        }
        int row = e.getFirstRow();
        String msg = this.writeOff(row, col = e.getColumn(), isInvoice = e.getSource().equals(this.invoiceTable.getModel()), null, this.invoiceTable.getModel(), this.invoiceTable, false);
        if (msg != null && msg.length() > 0) {
            ADialog.warn(this.m_WindowNo, this.panel, "AllocationWriteOffWarn");
        }
        this.calculate();
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        log.config(String.valueOf(name) + "=" + value);
        if (name.equals("AD_Org_ID")) {
            this.m_AD_Org_ID = (Integer)value;
            this.loadBPartner();
        } else if (e.getSource() == this.filterBPartnerSearch) {
            this.filterBPartnerSearch.setValue(value);
            this.filterRowSorter.setRowFilter(this.getRowFilter((Integer)value));
        } else if (name.equals("filter_DocumentNo")) {
            this.filterRowSorter.setRowFilter(this.getRowFilter((Integer)this.filterBPartnerSearch.getValue()));
        } else if (name.equals("C_BPartner_ID")) {
            this.bpartnerSearch.setValue(value);
            this.m_C_BPartner_ID = value != null ? (Integer)value : -1;
            this.filterBPartnerSearch.setValue(null);
            this.loadBPartner();
        } else if (name.equals("C_Currency_ID")) {
            this.m_C_Currency_ID = (Integer)value;
            this.loadBPartner();
        } else if (name.equals("Date") && this.multiCurrency.isSelected()) {
            this.loadBPartner();
        }
    }

    public void loadBPartner() {
        this.checkBPartner();
        Vector<Vector<Object>> data = this.getInvoiceData(this.multiCurrency.isSelected(), this.dateField.getValue(), this.invoiceTable);
        Vector<String> columnNames = this.getInvoiceColumnNames(this.multiCurrency.isSelected());
        this.invoiceTable.getModel().removeTableModelListener(this);
        DefaultTableModel model = new DefaultTableModel(data, columnNames);
        this.filterRowSorter = new TableRowSorter<DefaultTableModel>(model);
        this.filterRowSorter.setRowFilter(this.getRowFilter((Integer)this.filterBPartnerSearch.getValue()));
        this.invoiceTable.setRowSorter(this.filterRowSorter);
        model.addTableModelListener(this);
        this.invoiceTable.setModel(model);
        this.setInvoiceColumnClass(this.invoiceTable, this.multiCurrency.isSelected());
        this.calculate(this.multiCurrency.isSelected());
        this.calculate();
    }

    public void calculate() {
        this.allocDate = null;
        this.invoiceInfo.setText(this.calculateInvoice(this.invoiceTable.getModel(), this.multiCurrency.isSelected()));
        this.allocCurrencyLabel.setText(this.currencyPick.getDisplay());
        this.totalDiff = this.totalPay.subtract(this.totalInv);
        this.differenceField.setText(this.format.format(this.totalDiff));
        if (this.totalDiff.compareTo(new BigDecimal(0.0)) == 0 || this.totalPay.signum() == 0) {
            this.allocateButton.setEnabled(true);
        } else {
            this.allocateButton.setEnabled(false);
        }
    }

    public void saveData() {
        try {
            Trx.run(new TrxRunnable(){

                @Override
                public void run(String trxName) {
                    VAllocation.this.saveData(VAllocation.this.m_WindowNo, null, null, VAllocation.this.invoiceTable, trxName);
                }
            });
        }
        catch (Exception e) {
            ADialog.error(this.m_WindowNo, this.panel, "Error", e.getLocalizedMessage());
            return;
        }
    }

    public InvoiceRowFilter getRowFilter(Integer intC_BPartner_ID) {
        int C_BPartner_ID = -1;
        if (intC_BPartner_ID != null) {
            C_BPartner_ID = intC_BPartner_ID;
        }
        String sDocNo = (String)this.filterDocNo.getValue();
        return new InvoiceRowFilter(C_BPartner_ID, sDocNo);
    }

    protected class InvoiceRowFilter
    extends RowFilter<DefaultTableModel, Integer> {
        protected int C_BPartner_ID;
        protected String sDocumentNo;

        protected InvoiceRowFilter(int C_BPartner_ID, String sDocNo) {
            this.C_BPartner_ID = C_BPartner_ID;
            this.sDocumentNo = sDocNo;
            if (this.sDocumentNo != null) {
                this.sDocumentNo = this.sDocumentNo.toLowerCase();
            }
        }

        @Override
        public boolean include(RowFilter.Entry<? extends DefaultTableModel, ? extends Integer> entry) {
            KeyNamePair ppBP;
            if (VAllocation.this.m_C_BPartner_ID <= 0 && this.C_BPartner_ID > 0 && (ppBP = (KeyNamePair)entry.getValue(VAllocation.this.i_bpartner)).getKey() != this.C_BPartner_ID) {
                return false;
            }
            if (!Util.isEmpty(this.sDocumentNo, true)) {
                KeyNamePair knpDocNo = (KeyNamePair)entry.getValue(VAllocation.this.i_documentno);
                String sDocNo = knpDocNo.getName();
                if (sDocNo != null) {
                    boolean bInc = sDocNo.toLowerCase().contains(this.sDocumentNo);
                    if (bInc) {
                        System.err.println("Included: " + sDocNo);
                    } else {
                        System.err.println("Excluded: " + sDocNo);
                    }
                    return bInc;
                }
                return false;
            }
            return true;
        }
    }
}

