/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.primanota.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.table.TableModel;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MConversionRate;
import org.compiere.model.MInvoice;
import org.compiere.model.MPNGJournalLine;
import org.compiere.model.MPNGJrLineInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.MRole;
import org.compiere.model.SetGetUtil;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;

public class Allocation {
    public DecimalFormat format = DisplayType.getNumberFormat(12);
    public static CLogger log = CLogger.getCLogger(Allocation.class);
    private boolean m_calculating = false;
    public int m_C_Currency_ID = 0;
    public int m_C_BPartner_ID = 0;
    public int Account_ID = 0;
    private int m_noInvoices = 0;
    public BigDecimal totalInv = new BigDecimal(0.0);
    public BigDecimal totalPay = new BigDecimal(0.0);
    public BigDecimal totalDiff = new BigDecimal(0.0);
    public Timestamp allocDate = null;
    protected int i_documentno = 2;
    protected int i_bpartner = 3;
    private int i_payment = 7;
    private int i_open = 6;
    private int i_discount = 7;
    private int i_writeOff = 8;
    private int i_applied = 9;
    private int i_overUnder = 10;
    private int i_currency = 11;
    public int m_AD_Org_ID = 0;
    private ArrayList<Integer> m_bpartnerCheck = new ArrayList();
    protected MPNGJournalLine m_mPNGJournalLine = null;

    public void dynInit(int PNG_JournalLine_ID) throws Exception {
        this.m_C_Currency_ID = Env.getContextAsInt(Env.getCtx(), "$C_Currency_ID");
        log.info("Currency=" + this.m_C_Currency_ID);
        this.m_AD_Org_ID = Env.getAD_Org_ID(Env.getCtx());
        this.m_mPNGJournalLine = new MPNGJournalLine(Env.getCtx(), PNG_JournalLine_ID, null);
        this.totalPay = this.m_mPNGJournalLine.isInvEntryDr() ? this.m_mPNGJournalLine.getAmtToAllocDr().negate() : this.m_mPNGJournalLine.getAmtToAllocCr();
    }

    public void checkBPartner() {
        log.config("BPartner=" + this.m_C_BPartner_ID + ", Cur=" + this.m_C_Currency_ID);
        if (this.m_C_BPartner_ID == 0 || this.m_C_Currency_ID == 0) {
            return;
        }
        Integer key = new Integer(this.m_C_BPartner_ID);
        if (!this.m_bpartnerCheck.contains(key)) {
            new Thread(){

                @Override
                public void run() {
                    MPayment.setIsAllocated(Env.getCtx(), Allocation.this.m_C_BPartner_ID, null);
                    MInvoice.setIsPaid(Env.getCtx(), Allocation.this.m_C_BPartner_ID, null);
                }
            }.start();
            this.m_bpartnerCheck.add(key);
        }
    }

    public Vector<Vector<Object>> getInvoiceData(boolean isMultiCurrency, Object date, IMiniTable invoiceTable) {
        Vector<Vector<Object>> data = new Vector<Vector<Object>>();
        StringBuffer sql = new StringBuffer("SELECT i.DueDate as DateInvoiced,i.DocumentNo||' - '||TO_CHAR(i.DateInvoiced,'DD/MM/YYYY') as DocumentNo,i.C_Invoice_ID,c.ISO_Code,i.GrandTotal*i.MultiplierAP, currencyConvert(i.GrandTotal*i.MultiplierAP,i.C_Currency_ID,?,?,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID), currencyConvert(invoiceOpen(C_Invoice_ID,C_InvoicePaySchedule_ID),i.C_Currency_ID,?,?,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*i.MultiplierAP, currencyConvert(invoiceDiscount(i.C_Invoice_ID,?,C_InvoicePaySchedule_ID),i.C_Currency_ID,?,i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*i.Multiplier*i.MultiplierAP,i.MultiplierAP,c.C_Currency_ID,i.C_BPartner_ID,bp.Name as BPartnerName FROM C_Invoice_v i INNER JOIN C_Currency c ON (i.C_Currency_ID=c.C_Currency_ID)  INNER JOIN C_BPartner bp ON (i.C_BPartner_ID=bp.C_BPartner_ID)  INNER JOIN fact_acct facc ON (facc.ad_table_id = 318 and facc.record_id = i.c_invoice_id and facc.line_id is null and facc.c_tax_id is null) WHERE i.IsPaid='N' AND i.Processed='Y' AND facc.Account_ID = ?");
        if (this.m_C_BPartner_ID > 0) {
            sql.append(" AND i.C_BPartner_ID=?");
        }
        if (!isMultiCurrency) {
            sql.append(" AND i.C_Currency_ID=?");
        }
        if (this.m_AD_Org_ID != 0) {
            sql.append(" AND i.AD_Org_ID=" + this.m_AD_Org_ID);
        }
        sql.append(" ORDER BY i.DueDate, i.DateInvoiced, i.DocumentNo");
        log.fine("InvSQL=" + sql.toString());
        sql = new StringBuffer(MRole.getDefault(Env.getCtx(), false).addAccessSQL(sql.toString(), "i", true, false));
        try {
            int i = 1;
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(i++, this.m_C_Currency_ID);
            pstmt.setTimestamp(i++, (Timestamp)date);
            pstmt.setInt(i++, this.m_C_Currency_ID);
            pstmt.setTimestamp(i++, (Timestamp)date);
            pstmt.setTimestamp(i++, (Timestamp)date);
            pstmt.setInt(i++, this.m_C_Currency_ID);
            pstmt.setInt(i++, this.Account_ID);
            if (this.m_C_BPartner_ID > 0) {
                pstmt.setInt(i++, this.m_C_BPartner_ID);
            }
            if (!isMultiCurrency) {
                pstmt.setInt(i++, this.m_C_Currency_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(new Boolean(false));
                line.add(rs.getTimestamp(1));
                KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(2));
                line.add(pp);
                if (this.m_C_BPartner_ID <= 0) {
                    KeyNamePair ppBP = new KeyNamePair(rs.getInt("C_BPartner_ID"), rs.getString("BPartnerName"));
                    line.add(ppBP);
                }
                if (isMultiCurrency) {
                    line.add(rs.getString(4));
                    line.add(rs.getBigDecimal(5));
                }
                line.add(rs.getBigDecimal(6));
                BigDecimal open = rs.getBigDecimal(7);
                if (open == null) {
                    open = Env.ZERO;
                }
                line.add(open);
                BigDecimal discount = rs.getBigDecimal(8);
                if (discount == null) {
                    discount = Env.ZERO;
                }
                line.add(discount);
                line.add(Env.ZERO);
                line.add(Env.ZERO);
                line.add(open);
                IDColumn idC = new IDColumn(rs.getInt("C_Currency_ID"));
                line.add(idC);
                if (Env.ZERO.compareTo(open) == 0) continue;
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        return data;
    }

    public Vector<String> getInvoiceColumnNames(boolean isMultiCurrency) {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.translate(Env.getCtx(), "DueDate"));
        columnNames.add(Util.cleanAmp(Msg.translate(Env.getCtx(), "DocumentNo")));
        if (this.m_C_BPartner_ID <= 0) {
            columnNames.add(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        }
        if (isMultiCurrency) {
            columnNames.add(Msg.getMsg(Env.getCtx(), "TrxCurrency"));
            columnNames.add(Msg.translate(Env.getCtx(), "Amount"));
        }
        columnNames.add(Msg.getMsg(Env.getCtx(), "ConvertedAmount"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "OpenAmt"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Discount"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "WriteOff"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "AppliedAmt"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "OverUnderAmt"));
        columnNames.add("");
        return columnNames;
    }

    public void setInvoiceColumnClass(IMiniTable invoiceTable, boolean isMultiCurrency) {
        int i = 0;
        invoiceTable.setColumnClass(i++, Boolean.class, false);
        invoiceTable.setColumnClass(i++, Timestamp.class, true);
        invoiceTable.setColumnClass(i++, String.class, true);
        if (this.m_C_BPartner_ID <= 0) {
            invoiceTable.setColumnClass(i++, String.class, true);
        }
        if (isMultiCurrency) {
            invoiceTable.setColumnClass(i++, String.class, true);
            invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        }
        invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        invoiceTable.setColumnClass(i++, BigDecimal.class, false);
        invoiceTable.setColumnClass(i++, BigDecimal.class, false);
        invoiceTable.setColumnClass(i++, BigDecimal.class, false);
        invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        invoiceTable.setColumnClass(i++, IDColumn.class, true);
        invoiceTable.autoSize();
    }

    public void calculate(boolean isMultiCurrency) {
        this.i_open = isMultiCurrency ? 6 : 4;
        this.i_discount = isMultiCurrency ? 7 : 5;
        this.i_writeOff = isMultiCurrency ? 8 : 6;
        this.i_applied = isMultiCurrency ? 9 : 7;
        this.i_overUnder = isMultiCurrency ? 10 : 8;
        int n = this.i_currency = isMultiCurrency ? 11 : 9;
        if (this.m_C_BPartner_ID <= 0) {
            ++this.i_open;
            ++this.i_discount;
            ++this.i_writeOff;
            ++this.i_applied;
            ++this.i_overUnder;
            ++this.i_currency;
        }
    }

    public String writeOff(int row, int col, boolean isInvoice, IMiniTable payment, TableModel invoice, IMiniTable invoiceTable, boolean isAutoWriteOff) {
        String msg = "";
        if (this.m_calculating) {
            return msg;
        }
        this.m_calculating = true;
        log.config("Row=" + row + ", Col=" + col + ", InvoiceTable=" + isInvoice);
        if (!isInvoice) {
            BigDecimal open = (BigDecimal)payment.getValueAt(row, this.i_open);
            BigDecimal applied = (BigDecimal)payment.getValueAt(row, this.i_payment);
            if (col == 0) {
                if (((Boolean)payment.getValueAt(row, 0)).booleanValue()) {
                    applied = open;
                    if (this.totalDiff.abs().compareTo(applied.abs()) < 0 && this.totalDiff.signum() == -applied.signum()) {
                        applied = this.totalDiff.negate();
                    }
                } else {
                    applied = Env.ZERO;
                }
            }
            if (col == this.i_payment) {
                if (applied.signum() == -open.signum()) {
                    applied = applied.negate();
                }
                if (open.abs().compareTo(applied.abs()) < 0) {
                    applied = open;
                }
            }
            payment.setValueAt(applied, row, this.i_payment);
        } else {
            boolean selected = (Boolean)invoice.getValueAt(row, 0);
            BigDecimal open = (BigDecimal)invoice.getValueAt(row, this.i_open);
            BigDecimal discount = (BigDecimal)invoice.getValueAt(row, this.i_discount);
            BigDecimal applied = (BigDecimal)invoice.getValueAt(row, this.i_applied);
            BigDecimal writeOff = (BigDecimal)invoice.getValueAt(row, this.i_writeOff);
            BigDecimal overUnder = (BigDecimal)invoice.getValueAt(row, this.i_overUnder);
            int openSign = open.signum();
            if (col == 0) {
                if (selected) {
                    MInvoice mInvoice = this.getRowInvoice(row, invoice);
                    applied = open;
                    applied = applied.subtract(discount);
                    writeOff = Env.ZERO;
                    overUnder = Env.ZERO;
                    if (this.totalDiff.abs().compareTo(applied.abs()) < 0 && this.totalDiff.signum() == applied.signum()) {
                        applied = this.totalDiff;
                    }
                    if (isAutoWriteOff) {
                        writeOff = open.subtract(applied.add(discount));
                    } else {
                        overUnder = open.subtract(applied.add(discount));
                    }
                } else {
                    writeOff = Env.ZERO;
                    applied = Env.ZERO;
                    overUnder = Env.ZERO;
                    discount = Env.ZERO;
                }
            }
            if (selected && col != 0) {
                if (discount.signum() == -openSign) {
                    discount = discount.negate();
                }
                if (writeOff.signum() == -openSign) {
                    writeOff = writeOff.negate();
                }
                if (applied.signum() == -openSign) {
                    applied = applied.negate();
                }
                if (discount.abs().compareTo(open.abs()) > 0) {
                    discount = open;
                }
                if (writeOff.abs().compareTo(open.abs()) > 0) {
                    writeOff = open;
                }
                BigDecimal newTotal = discount.add(writeOff).add(applied).add(overUnder);
                BigDecimal difference = newTotal.subtract(open);
                BigDecimal diffWOD = writeOff.add(discount).subtract(open);
                if (diffWOD.signum() == open.signum()) {
                    if (col == this.i_discount) {
                        writeOff = writeOff.subtract(diffWOD);
                    } else {
                        discount = discount.subtract(diffWOD);
                    }
                    difference = difference.subtract(diffWOD);
                }
                if (col == this.i_applied) {
                    overUnder = overUnder.subtract(difference);
                } else {
                    applied = applied.subtract(difference);
                }
            }
            if (isAutoWriteOff && writeOff.doubleValue() / open.doubleValue() > 0.3) {
                msg = "AllocationWriteOffWarn";
            }
            invoice.setValueAt(discount, row, this.i_discount);
            invoice.setValueAt(applied, row, this.i_applied);
            invoice.setValueAt(writeOff, row, this.i_writeOff);
            invoice.setValueAt(overUnder, row, this.i_overUnder);
            invoiceTable.repaint();
        }
        this.m_calculating = false;
        return msg;
    }

    public MInvoice getRowInvoice(int iRow, TableModel invoice) {
        KeyNamePair knp = (KeyNamePair)invoice.getValueAt(iRow, this.i_documentno);
        int C_Invoice_ID = knp.getKey();
        return MInvoice.get(Env.getCtx(), C_Invoice_ID);
    }

    public String calculateInvoice(TableModel invoice, boolean isMultiCurrency) {
        this.totalInv = new BigDecimal(0.0);
        int rows = invoice.getRowCount();
        this.m_noInvoices = 0;
        int i = 0;
        while (i < rows) {
            if (((Boolean)invoice.getValueAt(i, 0)).booleanValue()) {
                Timestamp ts = (Timestamp)invoice.getValueAt(i, 1);
                if (!isMultiCurrency) {
                    this.allocDate = TimeUtil.max(this.allocDate, ts);
                }
                BigDecimal bd = (BigDecimal)invoice.getValueAt(i, this.i_applied);
                this.totalInv = this.totalInv.add(bd);
                ++this.m_noInvoices;
                log.fine("Invoice_" + i + " = " + bd + " - Total=" + this.totalPay);
            }
            ++i;
        }
        return String.valueOf(String.valueOf(this.m_noInvoices)) + " - " + Msg.getMsg(Env.getCtx(), "Sum") + "  " + this.format.format(this.totalInv) + " ";
    }

    public String saveData(int m_WindowNo, Object date, IMiniTable payment, IMiniTable invoice, String trxName) {
        if (this.m_noInvoices == 0) {
            return "";
        }
        int AD_Client_ID = Env.getContextAsInt(Env.getCtx(), m_WindowNo, "AD_Client_ID");
        int AD_Org_ID = Env.getContextAsInt(Env.getCtx(), m_WindowNo, "AD_Org_ID");
        int C_BPartner_ID = this.m_C_BPartner_ID;
        Timestamp DateTrx = (Timestamp)date;
        int C_Currency_ID = this.m_C_Currency_ID;
        if (AD_Org_ID == 0) {
            new AdempiereException("@Org0NotAllowed@");
        }
        log.config("Client=" + AD_Client_ID + ", Org=" + AD_Org_ID + ", BPartner=" + C_BPartner_ID + ", Date=" + DateTrx);
        int iRows = invoice.getRowCount();
        int iGeneratedLines = 0;
        int i = 0;
        while (i < iRows) {
            if (((Boolean)invoice.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp = (KeyNamePair)invoice.getValueAt(i, 2);
                int C_Invoice_ID = pp.getKey();
                BigDecimal AppliedAmt = (BigDecimal)invoice.getValueAt(i, this.i_applied);
                BigDecimal DiscountAmt = (BigDecimal)invoice.getValueAt(i, this.i_discount);
                BigDecimal WriteOffAmt = (BigDecimal)invoice.getValueAt(i, this.i_writeOff);
                BigDecimal OpenAmt = (BigDecimal)invoice.getValueAt(i, this.i_open);
                BigDecimal OverUnderAmt = OpenAmt.subtract(AppliedAmt).subtract(DiscountAmt).subtract(WriteOffAmt);
                int invC_Currency_ID = ((IDColumn)invoice.getValueAt(i, this.i_currency)).getRecord_ID();
                MPNGJrLineInvoice mJrLineInvoice = new MPNGJrLineInvoice(Env.getCtx(), 0, trxName);
                MInvoice mInvoice = MInvoice.get(Env.getCtx(), C_Invoice_ID);
                mJrLineInvoice.setPNG_JournalLine_ID(this.m_mPNGJournalLine.getPNG_JournalLine_ID());
                mJrLineInvoice.setInvoice(mInvoice);
                mJrLineInvoice.setInvoiceAmt(OpenAmt);
                mJrLineInvoice.setAmount(AppliedAmt);
                mJrLineInvoice.setDiscountAmt(DiscountAmt);
                mJrLineInvoice.setWriteOffAmt(WriteOffAmt);
                mJrLineInvoice.setOverUnderAmt(OverUnderAmt);
                BigDecimal bdOpenAmtCur = MConversionRate.convert(Env.getCtx(), OpenAmt, this.m_C_Currency_ID, invC_Currency_ID, AD_Client_ID, AD_Org_ID);
                MPNGJrLineInvoice.calcValues(this.m_mPNGJournalLine.getPNG_Journal_ID(), SetGetUtil.wrap(mJrLineInvoice), bdOpenAmtCur);
                mJrLineInvoice.saveEx();
                ++iGeneratedLines;
            }
            ++i;
        }
        if (this.totalPay.signum() == 0) {
            BigDecimal bdPositiveAmt = this.totalInv.abs();
            this.m_mPNGJournalLine.setAmount(bdPositiveAmt);
            if (this.m_mPNGJournalLine.getAccountCr_ID() > 0) {
                this.m_mPNGJournalLine.setAmtSourceCr(bdPositiveAmt);
            }
            if (this.m_mPNGJournalLine.getAccountDr_ID() > 0) {
                this.m_mPNGJournalLine.setAmtSourceDr(bdPositiveAmt);
            }
            this.m_mPNGJournalLine.saveEx(trxName);
        }
        return Msg.parseTranslation(Env.getCtx(), "@Generated@ " + iGeneratedLines);
    }
}

