/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.paymentterm.model;

import com.f3p.adempiere.model.AbstractBoostrappableValidator;
import com.f3p.adempiere.paymentterm.model.F3PMInvoicePaySchedule;
import com.f3p.adempiere.paymentterm.model.F3PMPaySchedule;
import com.f3p.adempiere.paymentterm.model.F3PMPaymentTerm;
import com.f3p.adempiere.util.ModelFactory;
import org.compiere.model.MClient;
import org.compiere.model.MPaySchedule;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.SetGetModel;
import org.compiere.model.SetGetUtil;
import org.compiere.model.X_C_Invoice;
import org.compiere.model.X_C_InvoicePaySchedule;
import org.compiere.model.X_C_Order;
import org.compiere.util.CLogger;

public class PaymentTermValidator
extends AbstractBoostrappableValidator {
    private static CLogger s_log = CLogger.getCLogger(PaymentTermValidator.class);

    @Override
    public String docValidate(PO po, int timing) {
        return null;
    }

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        super.initialize(engine, client);
        engine.addModelChange("C_Invoice", this);
        engine.addModelChange("C_Order", this);
        engine.addModelChange("C_InvoicePaySchedule", this);
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        s_log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        if (type == 1) {
            if (po instanceof X_C_Order || po instanceof X_C_Invoice) {
                SetGetModel model = SetGetUtil.wrap(po);
                int C_PaymentTerm_ID = po.get_ValueAsInt("C_PaymentTerm_ID");
                PaymentTermValidator.setPaymentRule(model, C_PaymentTerm_ID);
            } else if (po instanceof X_C_InvoicePaySchedule) {
                X_C_InvoicePaySchedule mInvoicePaySchedule = (X_C_InvoicePaySchedule)po;
                MPaySchedule mPaySchedule = ModelFactory.getPaySchedule(po.getCtx(), mInvoicePaySchedule.getC_PaySchedule_ID(), po.get_TrxName());
                String sPaymentRule = F3PMPaySchedule.getPaymentRule(mPaySchedule);
                if (sPaymentRule != null) {
                    F3PMInvoicePaySchedule.setPaymentRule(mInvoicePaySchedule, sPaymentRule);
                }
            }
        }
        return null;
    }

    public static void setPaymentRule(SetGetModel model, int C_PaymentTerm_ID) {
        String sPRule;
        MPaymentTerm mPaymentTerm = ModelFactory.getPaymentTerm(model.getCtx(), C_PaymentTerm_ID, model.get_TrxName());
        if (mPaymentTerm != null && (sPRule = F3PMPaymentTerm.getPaymentRule(mPaymentTerm)) != null) {
            model.set_AttrValue("PaymentRule", sPRule);
        }
    }
}

